/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.evcharger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.powertac.common.CapacityProfile;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.RegulationCapacity;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluator;
import org.powertac.common.TariffSubscription;
import org.powertac.common.config.ConfigurableInstance;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.CustomerModelAccessor;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateLogging;
import org.powertac.customer.AbstractCustomer;
import org.powertac.customer.evcharger.DemandElement;
import org.powertac.customer.evcharger.DemandSampler;
import org.powertac.customer.evcharger.StorageState;
import org.powertac.customer.evcharger.TariffInfo;

@Domain
@ConfigurableInstance
public class EvCharger
extends AbstractCustomer
implements CustomerModelAccessor {
    private static Logger log;
    @ConfigurableValue(valueType="String", publish=false, bootstrapState=false, dump=true, description="Name of statistical model config file")
    private String model;
    @ConfigurableValue(valueType="Double", publish=true, bootstrapState=true, dump=true, description="Population of chargers")
    private double population;
    @ConfigurableValue(valueType="Integer", publish=true, bootstrapState=true, dump=true, description="Minimum population subscribing to a specific tariff")
    private int minimumChunkSize;
    @ConfigurableValue(valueType="Double", publish=true, bootstrapState=true, dump=true, description="Individual Charger capacity in kW")
    private double chargerCapacity;
    @ConfigurableValue(valueType="Double", publish=false, bootstrapState=true, dump=true, description="Where in the min-max range we compute nominal demand")
    private double nominalDemandBias;
    @ConfigurableValue(valueType="Integer", publish=false, bootstrapState=true, dump=true, description="Maximum horizon for individual charging demand elements")
    private int maxDemandHorizon;
    @ConfigurableValue(valueType="String", publish=false, dump=false, bootstrapState=true, description="Collected demand statistics at end of boot session")
    private String storageRecord;
    @ConfigurableValue(valueType="Double", publish=false, bootstrapState=false, dump=true, description="Portion of flexibility to hold back")
    private double defaultFlexibilityMargin;
    private CapacityProfile defaultCapacityProfile;
    @ConfigurableValue(valueType="Double", publish=false, description="Probability customer will ignore tariff publications")
    private double evalInertia;
    @ConfigurableValue(valueType="Double", publish=false, description="Probability customer will ignore tariff publications")
    private double evalRationality;
    @ConfigurableValue(valueType="Boolean", publish=false, description="If true, then re-evaluate all tariffs in each cycle")
    private boolean evaluateAll;
    @ConfigurableValue(valueType="List", dump=false, description="default expected hourly consumption in kWh/charger, comma-separated values")
    private List<String> defaultCapacityData;
    @ConfigurableValue(valueType="Integer", publish=false, bootstrapState=true, description="periodicity of the customer data model")
    private int defaultProfileSize;
    private ArrayList<ArrayList<DemandElement>> demandInfoMean;
    private int[] demandInfoMeanCounter;
    private PowerType powerType;
    private RandomSeed evalSeed;
    private RandomSeed demandSeed;
    private HashMap<TariffSubscription, StorageState> subState;
    private HashMap<Tariff, TariffInfo> tariffInfo;
    private TariffEvaluator tariffEvaluator;
    private DemandSampler demandSampler;
    private double epsilon;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        EvCharger.ajc$preClinit();
        log = LogManager.getLogger((String)EvCharger.class.getName());
    }

    public EvCharger() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        this.model = "dummy.xml";
        this.population = 1000.0;
        this.minimumChunkSize = 20;
        this.chargerCapacity = 8.0;
        this.nominalDemandBias = 0.5;
        this.maxDemandHorizon = 96;
        this.defaultFlexibilityMargin = 0.02;
        this.defaultCapacityProfile = null;
        this.evalInertia = 0.9;
        this.evalRationality = 0.8;
        this.evaluateAll = true;
        this.defaultCapacityData = null;
        this.defaultProfileSize = 24;
        this.powerType = PowerType.ELECTRIC_VEHICLE;
        this.epsilon = 1.0E-9;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public EvCharger(String name) {
        super(name);
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        this.model = "dummy.xml";
        this.population = 1000.0;
        this.minimumChunkSize = 20;
        this.chargerCapacity = 8.0;
        this.nominalDemandBias = 0.5;
        this.maxDemandHorizon = 96;
        this.defaultFlexibilityMargin = 0.02;
        this.defaultCapacityProfile = null;
        this.evalInertia = 0.9;
        this.evalRationality = 0.8;
        this.evaluateAll = true;
        this.defaultCapacityData = null;
        this.defaultProfileSize = 24;
        this.powerType = PowerType.ELECTRIC_VEHICLE;
        this.epsilon = 1.0E-9;
        StateLogging.aspectOf().newstate(joinPoint);
    }

    public void initialize() {
        super.initialize();
        log.info("Initialize " + this.name);
        CustomerInfo info = new CustomerInfo(this.name, (int)Math.round(this.population));
        info.withPowerType(this.powerType).withCustomerClass(CustomerInfo.CustomerClass.SMALL).withUpRegulationKW(-100.0).withDownRegulationKW(100.0);
        this.addCustomerInfo(info);
        this.ensureSeeds();
        if (this.demandInfoMean == null) {
            this.demandInfoMean = new ArrayList();
            this.demandInfoMeanCounter = new int[this.defaultProfileSize];
        }
        this.tariffInfo = new HashMap();
        this.tariffEvaluator = this.createTariffEvaluator(this);
        this.tariffEvaluator.withPreferredContractDuration(14.0).withChunkSize(this.minimumChunkSize).withInertia(this.evalInertia).withRationality(this.evalRationality).withEvaluateAllTariffs(this.evaluateAll);
        this.tariffEvaluator.initializeInconvenienceFactors(0.0, 0.01, 0.0, 0.0);
        this.tariffEvaluator.initializeRegulationFactors(-0.1, 0.0, 0.1);
        this.demandSampler = new DemandSampler();
        this.demandSampler.initialize(this.model, this.getDemandSeed());
    }

    void initDemandInfoMean() {
        int repeat = 168;
        DateTime currentTime = this.service.getTimeService().getCurrentDateTime();
        int i = 0;
        while (i < repeat) {
            this.getDemandInfo(currentTime.plus((long)i * 3600000L));
            ++i;
        }
    }

    public void handleInitialSubscription(List<TariffSubscription> subscriptions) {
        if (subscriptions.size() != 1) {
            log.error("Should be only one subscription, but saw {}", (Object)subscriptions.size());
        }
        log.info("initial subscription for {}", (Object)this.getCustomerInfo().getName());
    }

    private void ensureSeeds() {
        if (this.evalSeed == null) {
            RandomSeedRepo repo = this.service.getRandomSeedRepo();
            this.evalSeed = repo.getRandomSeed(String.valueOf(EvCharger.class.getName()) + "-" + this.name, 0L, "eval");
            this.demandSeed = repo.getRandomSeed(EvCharger.class.getName(), (long)this.maxDemandHorizon, this.model);
        }
    }

    public CustomerInfo getCustomerInfo() {
        return this.getCustomerInfo(this.powerType);
    }

    public CapacityProfile getDefaultCapacityProfile() {
        if (this.defaultCapacityProfile == null) {
            if (this.defaultCapacityData == null) {
                log.error("Empty default capacity data");
                return null;
            }
            double[] dcp = new double[this.defaultCapacityData.size()];
            int index = 0;
            for (String item : this.defaultCapacityData) {
                dcp[index++] = Double.valueOf(item);
            }
            this.defaultCapacityProfile = new CapacityProfile(dcp, this.lastSunday());
        }
        return this.defaultCapacityProfile;
    }

    public double getMeanDefaultCapacity() {
        double[] profile;
        double sum = 0.0;
        double[] dArray = profile = this.getDefaultCapacityProfile().getProfile();
        int n = profile.length;
        int n2 = 0;
        while (n2 < n) {
            double val = dArray[n2];
            sum += val;
            ++n2;
        }
        return sum / (double)profile.length;
    }

    void setDefaultCapacityData(List<String> data) {
        this.defaultCapacityData = data;
    }

    public CapacityProfile getCapacityProfile(Tariff tariff) {
        return this.getTariffInfo(tariff).getCapacityProfile();
    }

    TariffInfo getTariffInfo(Tariff tariff) {
        TariffInfo result = this.tariffInfo.get(tariff);
        if (result == null) {
            result = new TariffInfo(this, tariff);
            this.tariffInfo.put(tariff, result);
        }
        return result;
    }

    public RandomSeed getDemandSeed() {
        return this.demandSeed;
    }

    public double getBrokerSwitchFactor(boolean isSuperseding) {
        if (isSuperseding) {
            return 0.0;
        }
        return 0.02;
    }

    public double getTariffChoiceSample() {
        return this.evalSeed.nextDouble();
    }

    public double getInertiaSample() {
        return this.evalSeed.nextDouble();
    }

    public double getShiftingInconvenienceFactor(Tariff tariff) {
        return 0.0;
    }

    public void notifyCustomer(TariffSubscription oldsub, TariffSubscription newsub, int count) {
        if (count < 0) {
            log.error("Negative population in notifyCustomer({}, {} {})", (Object)oldsub.getId(), (Object)newsub.getId(), (Object)count);
            return;
        }
        if (count == 0) {
            log.warn("Zero population in notifyCustomer({}, {}, 0)", (Object)oldsub.getId(), (Object)newsub.getId());
            return;
        }
        int timeslotIndex = this.service.getTimeslotRepo().currentSerialNumber();
        StorageState oldss = this.getStorageState(oldsub);
        if (oldss == null) {
            log.error("Null StorageState on subscription {}", (Object)oldsub.getId());
            return;
        }
        StorageState newss = this.getStorageState(newsub);
        if (newss == null) {
            newss = new StorageState(newsub, this.getChargerCapacity(), this.getMaxDemandHorizon()).withUnitCapacity(this.getChargerCapacity());
            this.setStorageState(newsub, newss);
        }
        newss.moveSubscribers(timeslotIndex, count, oldss);
    }

    void setStorageState(TariffSubscription sub, StorageState ss) {
        if (this.subState == null) {
            this.subState = new HashMap();
        }
        this.subState.put(sub, ss);
    }

    StorageState getStorageState(TariffSubscription sub) {
        return this.subState.get(sub);
    }

    public void step() {
        List<DemandElement> newDemand;
        DateTime currentTime = this.service.getTimeService().getCurrentDateTime();
        int timeslotIndex = this.service.getTimeslotRepo().currentSerialNumber();
        log.info("Step at ts {}", (Object)timeslotIndex);
        List subs = this.service.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(this.getCustomerInfo());
        if (subs.size() == 0) {
            log.error("No subscriptions at step {}", (Object)timeslotIndex);
        } else if (this.subState == null) {
            StorageState initialSS;
            TariffSubscription sub = (TariffSubscription)subs.get(0);
            TariffInfo ti = this.getTariffInfo(sub.getTariff());
            ti.setCapacityProfile(this.getDefaultCapacityProfile());
            if (this.storageRecord != null) {
                initialSS = StorageState.restoreState(this.getChargerCapacity(), sub, this.getMaxDemandHorizon(), this.storageRecord);
                this.setStorageState(sub, initialSS);
            } else {
                initialSS = new StorageState(sub, this.getChargerCapacity(), this.getMaxDemandHorizon());
                this.setStorageState(sub, initialSS);
            }
            if (this.demandInfoMean.size() == 0) {
                log.info("Initializing demandInfoMean");
                this.initDemandInfoMean();
            }
        }
        if (timeslotIndex > 0) {
            for (TariffSubscription sub : subs) {
                StorageState ss = this.getStorageState(sub);
                log.info("{} regulation for tariff {} = {}", (Object)this.getCustomerInfo().getName(), (Object)sub.getTariff().getId(), (Object)sub.getRegulation());
                double residue = ss.distributeRegulation(timeslotIndex, sub.getRegulation());
                if (Math.abs(residue) > this.epsilon) {
                    log.error("Attempt to distribute regulation {} in ts {} left residue of {}", (Object)sub.getRegulation(), (Object)timeslotIndex, (Object)residue);
                }
                ss.collapseElements(timeslotIndex);
                ss.rebalance(timeslotIndex);
            }
        }
        if ((newDemand = this.getDemandInfo(currentTime)).size() < 4) {
            log.info("short demand sample {}", (Object)newDemand.size());
        } else {
            int i = 0;
            while (i < 4) {
                DemandElement de = newDemand.get(i);
                log.info("New demand h={} nv={} d={}", (Object)de.getHorizon(), (Object)de.getNVehicles(), (Object)Arrays.toString(de.getdistribution()));
                ++i;
            }
        }
        for (TariffSubscription sub : this.service.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(this.getCustomerInfo())) {
            double ratio = (double)sub.getCustomersCommitted() / this.population;
            StorageState ss = this.getStorageState(sub);
            ss.distributeDemand(timeslotIndex, newDemand, ratio);
            double[] limits = ss.getMinMax(timeslotIndex);
            log.info("nominalDemandBias = {}", (Object)this.nominalDemandBias);
            double nominalDemand = this.computeNominalDemand(currentTime, sub, limits);
            log.info("Sub {}: Use power min={}, max={}, nominal={}", (Object)sub.getId(), (Object)limits[0], (Object)limits[1], (Object)nominalDemand);
            ss.distributeUsage(timeslotIndex, nominalDemand);
            sub.usePower(nominalDemand);
            RegulationCapacity rc = this.computeRegulationCapacity(sub, nominalDemand, limits[0], limits[1]);
            if (rc == null) continue;
            sub.setRegulationCapacity(rc);
        }
    }

    private double computeNominalDemand(DateTime time, TariffSubscription sub, double[] minMax) {
        double result = 0.0;
        TariffInfo info = this.getTariffInfo(sub);
        result = !info.isTOU() && !info.isVariableRate() ? minMax[0] + this.nominalDemandBias * (minMax[1] - minMax[0]) : minMax[0] + info.getDemandBias() * (minMax[1] - minMax[0]);
        return result;
    }

    private RegulationCapacity computeRegulationCapacity(TariffSubscription sub, double actualDemand, double minDemand, double maxDemand) {
        return new RegulationCapacity(sub, (actualDemand - minDemand) / (double)sub.getCustomersCommitted(), (actualDemand - maxDemand) / (double)sub.getCustomersCommitted());
    }

    public void evaluateTariffs(List<Tariff> tariffs) {
        log.info(String.valueOf(this.getName()) + ": evaluate tariffs");
        this.tariffEvaluator.evaluateTariffs();
    }

    TariffInfo getTariffInfo(TariffSubscription sub) {
        return this.getTariffInfo(sub.getTariff());
    }

    public void saveBootstrapState() {
        log.info("saveBootstrapState");
        int timeslot = this.service.getTimeslotRepo().currentSerialNumber();
        List subs = this.service.getTariffSubscriptionRepo().findActiveSubscriptionsForCustomer(this.getCustomerInfo());
        if (subs.size() > 1) {
            log.error("{} subscriptions, should be just one", (Object)subs.size());
        }
        TariffSubscription sub = (TariffSubscription)subs.get(0);
        StorageState finalState = this.getStorageState(sub);
        this.storageRecord = finalState.gatherState(timeslot);
    }

    public List<DemandElement> getDemandInfo(DateTime time) {
        List<DemandElement> demandInfo = new ArrayList<DemandElement>();
        if (!this.demandSampler.isEnabled()) {
            log.error("Demand sampler is currently disabled due to an internal error. Returning empty demand info.");
            return demandInfo;
        }
        try {
            int hod = time.getHourOfDay();
            demandInfo = this.demandSampler.sample(hod, (int)this.getPopulation(), this.chargerCapacity);
            this.updateDemandInfoMean(demandInfo, hod);
        }
        catch (IllegalArgumentException e) {
            log.error("Cannot sample new demandInfo due to an invalid argument. Returning empty demand info: " + e);
        }
        catch (Exception e) {
            log.error("Cannot sample new demand info. Returning emtpy demand info: " + e);
        }
        return demandInfo;
    }

    void updateDemandInfoMean(List<DemandElement> demandInfo, int hod) {
        if (hod > this.demandInfoMean.size()) {
            log.error("demandInfoMean not initialized at tod = {}", (Object)hod);
            return;
        }
        int count = this.demandInfoMeanCounter[hod];
        double scale = 1.0 / this.getPopulation();
        if (count == 0) {
            this.demandInfoMean.add((ArrayList)demandInfo.stream().map(de -> new DemandElement((DemandElement)de, scale)).collect(Collectors.toList()));
        } else {
            ArrayList<DemandElement> currentDemandInfoMean = this.demandInfoMean.get(hod);
            for (DemandElement de2 : demandInfo) {
                if (de2.getHorizon() < currentDemandInfoMean.size()) {
                    double invariantError;
                    DemandElement currentDemandElementMean = currentDemandInfoMean.get(de2.getHorizon());
                    double[] currentEnergyHistogram = currentDemandElementMean.getdistribution();
                    double[] newEnergyHistogram = new double[currentEnergyHistogram.length];
                    double histogramSum = 0.0;
                    double currentWeight = (double)count * currentDemandElementMean.getNVehicles();
                    if (0.0 != currentWeight + de2.getNVehicles()) {
                        int i = 0;
                        while (i < currentEnergyHistogram.length) {
                            newEnergyHistogram[i] = (currentEnergyHistogram[i] * currentWeight + de2.getdistribution()[i] * de2.getNVehicles()) / (currentWeight + de2.getNVehicles());
                            histogramSum += newEnergyHistogram[i];
                            ++i;
                        }
                    }
                    if (histogramSum > this.epsilon && Math.abs(invariantError = histogramSum - 1.0) > this.epsilon) {
                        double ratio = 1.0 / histogramSum;
                        log.info("DemandInfoMean restoring invariant at hod={} by {}", (Object)hod, (Object)ratio);
                        int i = 0;
                        while (i < newEnergyHistogram.length) {
                            int n = i++;
                            newEnergyHistogram[n] = newEnergyHistogram[n] * ratio;
                        }
                    }
                    currentDemandElementMean.setDistribution(newEnergyHistogram);
                    double meanVehicles = (currentDemandElementMean.getNVehicles() * (double)count + de2.getNVehicles() * scale) / (double)(count + 1);
                    currentDemandElementMean.setNVehicles(meanVehicles);
                    continue;
                }
                currentDemandInfoMean.add(new DemandElement(de2, scale));
            }
        }
        int n = hod;
        this.demandInfoMeanCounter[n] = this.demandInfoMeanCounter[n] + 1;
    }

    public List<ArrayList<DemandElement>> getDemandInfoMean() {
        return this.demandInfoMean;
    }

    double getPopulation() {
        return this.population;
    }

    EvCharger withPopulation(double population) {
        this.population = population;
        return this;
    }

    double getChargerCapacity() {
        return this.chargerCapacity;
    }

    int getMaxDemandHorizon() {
        return this.maxDemandHorizon;
    }

    EvCharger withChargerCapacity(double capacity) {
        this.chargerCapacity = capacity;
        return this;
    }

    double getNominalDemandBias() {
        return this.nominalDemandBias;
    }

    EvCharger withNominalDemandBias(double bias) {
        this.nominalDemandBias = bias;
        return this;
    }

    TariffEvaluator getTariffEvaluator() {
        return this.tariffEvaluator;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EvCharger.java", EvCharger.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.evcharger.EvCharger", "", "", ""), 135);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.powertac.customer.evcharger.EvCharger", "java.lang.String", "name", ""), 143);
    }
}

