/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.evcharger;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.customer.evcharger.StorageState;

class StorageElement {
    static Logger log = LogManager.getLogger((String)StorageElement.class.getName());
    double[] energy = new double[]{0.0};
    private double[] population = new double[]{0.0};
    private double epsilon = 1.0E-8;

    StorageElement(int arrayLength) {
        this.energy = new double[arrayLength];
        this.population = new double[arrayLength];
    }

    StorageElement(double activeChargers, double[] energy, double[] population) {
        this(energy, population);
    }

    StorageElement(double[] energy, double[] population) {
        this.energy = energy;
        this.population = population;
    }

    public static StorageElement restoreElement(int length, String data) {
        Matcher m;
        Pattern num = Pattern.compile("(\\d+.\\d+),?\\]? ?");
        StorageElement se = new StorageElement(length);
        String remains = data;
        int count = 0;
        while (count < length) {
            m = num.matcher(remains);
            if (!m.lookingAt()) {
                log.error("Failed to match population value, seeing {}", (Object)remains);
                return null;
            }
            se.population[count] = Double.valueOf(m.group(1));
            remains = remains.substring(m.end());
            ++count;
        }
        remains = remains.substring(1);
        count = 0;
        while (count < length) {
            m = num.matcher(remains);
            if (!m.lookingAt()) {
                log.error("Should be looking at population value, seeing {}", (Object)remains);
                return null;
            }
            se.energy[count] = Double.valueOf(m.group(1));
            remains = remains.substring(m.end());
            ++count;
        }
        return se;
    }

    void collapseArrays() {
        int len = this.population.length;
        if (len < 2) {
            return;
        }
        this.population = Arrays.copyOf(this.population, len - 1);
        this.energy = Arrays.copyOf(this.energy, len - 1);
    }

    void rebalance(double chargerCapacity) {
        if (1 == this.population.length) {
            return;
        }
        int i = this.energy.length - 1;
        while (i > 0) {
            double xRatio = (double)(this.energy.length - 1 - i) + 0.5;
            if (this.population[i] < this.epsilon) {
                this.population[i] = 0.0;
                this.energy[i] = 0.0;
            } else {
                double chunk = this.population[i] * chargerCapacity;
                double currentRatio = 0.0;
                currentRatio = this.energy[i] / chunk;
                if (!(currentRatio <= xRatio)) {
                    double move = currentRatio - xRatio;
                    if (move > 1.0 + this.epsilon || move < 0.0 - this.epsilon) {
                        log.error("Move ratio = {} out of range", (Object)move);
                    }
                    double moveP = this.population[i] * move;
                    int n = i;
                    this.population[n] = this.population[n] - moveP;
                    int n2 = i - 1;
                    this.population[n2] = this.population[n2] + moveP;
                    double moveE = this.energy[i] - this.population[i] * chargerCapacity * xRatio;
                    int n3 = i;
                    this.energy[n3] = this.energy[n3] - moveE;
                    int n4 = i - 1;
                    this.energy[n4] = this.energy[n4] + moveE;
                }
            }
            --i;
        }
    }

    double[] getRemainingCommitment() {
        return this.energy;
    }

    double[] getPopulation() {
        return this.population;
    }

    double[] getEnergy() {
        return this.energy;
    }

    void addCommitments(double[] population, double[] energy) {
        if (population.length > this.population.length) {
            StorageState.log.error("array size mismatch {} into {}", (Object)population.length, (Object)this.population.length);
        }
        int i = 0;
        while (i < population.length) {
            int n = i;
            this.population[n] = this.population[n] + population[i];
            int n2 = i;
            this.energy[n2] = this.energy[n2] + energy[i];
            ++i;
        }
    }

    StorageElement copy() {
        return new StorageElement(Arrays.copyOf(this.energy, this.energy.length), Arrays.copyOf(this.population, this.population.length));
    }

    StorageElement copyScaled(double scale) {
        double[] scaledPop = new double[this.population.length];
        double[] scaledEnergy = new double[this.energy.length];
        int i = 0;
        while (i < this.population.length) {
            scaledPop[i] = this.population[i] * scale;
            scaledEnergy[i] = this.energy[i] * scale;
            ++i;
        }
        return new StorageElement(scaledEnergy, scaledPop);
    }

    void addScaled(StorageElement element, double scale) {
        if (element.getPopulation().length != this.population.length) {
            StorageState.log.error("Attempt to add element of length {} to element of length {}", (Object)this.population.length, (Object)element.getPopulation().length);
        }
        int i = 0;
        while (i < this.population.length) {
            int n = i;
            this.population[n] = this.population[n] + element.getPopulation()[i] * scale;
            int n2 = i;
            this.energy[n2] = this.energy[n2] + element.getEnergy()[i] * scale;
            ++i;
        }
    }

    void scale(double fraction) {
        int i = 0;
        while (i < this.population.length) {
            int n = i;
            this.population[n] = this.population[n] * fraction;
            int n2 = i++;
            this.energy[n2] = this.energy[n2] * fraction;
        }
    }

    double[] getRatios(double chargerCapacity) {
        double[] result = new double[this.population.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.population[i] < 1.0E-9 ? 0.0 : this.energy[i] / chargerCapacity / this.population[i];
            ++i;
        }
        return result;
    }

    public String toString() {
        return String.format("SE %s %s", Arrays.toString(this.population), Arrays.toString(this.energy));
    }
}

