/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.evcharger;

import cern.colt.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.powertac.common.TariffSubscription;
import org.powertac.customer.evcharger.DemandElement;
import org.powertac.customer.evcharger.StorageElement;
import org.powertac.util.RingArray;

public class StorageState {
    static Logger log = LogManager.getLogger((String)StorageState.class.getName());
    private TariffSubscription mySub;
    private int ringArraySize = 96;
    private int startIndex = 0;
    private RingArray<StorageElement> capacityVector;
    private double unitCapacity = 0.0;
    private double epsilon = 1.0E-9;
    private double currentMin = 0.0;
    private double currentUsage = 0.0;

    public StorageState(double unitCapacity) {
        this.unitCapacity = unitCapacity;
    }

    public StorageState(TariffSubscription sub, double unitCapacity, int maxHorizon) {
        this(unitCapacity);
        this.mySub = sub;
        this.ringArraySize = maxHorizon;
        this.capacityVector = new RingArray(this.ringArraySize);
    }

    private StorageState(StorageState original) {
        this(original.unitCapacity);
        this.mySub = original.mySub;
        this.ringArraySize = original.ringArraySize;
        this.capacityVector = new RingArray(this.ringArraySize);
        int i = this.startIndex = original.startIndex;
        while (i < this.startIndex + original.capacityVector.getActiveLength(this.startIndex)) {
            this.capacityVector.set(i, (Object)((StorageElement)original.capacityVector.get(i)).copy());
            ++i;
        }
    }

    public StorageState copy() {
        return new StorageState(this);
    }

    public static StorageState restoreState(double unitCapacity, TariffSubscription sub, int maxHorizon, String input) {
        StorageState result = new StorageState(sub, unitCapacity, maxHorizon);
        String[] records = input.split("\\], ");
        log.debug("records.length={}", (Object)records.length);
        if (1 == records.length) {
            log.debug("first string length = {}", (Object)records[0].length());
        }
        Pattern intro = Pattern.compile("\\[?SE (\\d+) \\[");
        int arrayLength = 1;
        int i = 0;
        while (i < records.length) {
            String seInfo = records[i];
            Matcher m = intro.matcher(seInfo);
            if (!m.lookingAt()) {
                log.error("StorageElement prefix error {}", (Object)seInfo);
                return null;
            }
            int ts = Integer.valueOf(m.group(1));
            seInfo = seInfo.substring(m.end());
            StorageElement se = StorageElement.restoreElement(arrayLength++, seInfo);
            if (se == null) {
                System.out.println("failed to create SE - " + seInfo);
                return null;
            }
            result.putElement(ts, se);
            ++i;
        }
        return result;
    }

    public void moveSubscribers(int timeslotIndex, int count, StorageState oldState) {
        double fraction = (double)count / (double)oldState.getPopulation();
        if (this.getPopulation() == 0) {
            this.capacityVector.clear();
            this.copyScaled(timeslotIndex, oldState, fraction);
        } else if (count > 0) {
            this.addScaled(timeslotIndex, oldState, fraction);
        }
        this.scaleState(timeslotIndex, oldState, 1.0 - fraction);
    }

    private void copyScaled(int timeslot, StorageState from, double fraction) {
        this.capacityVector.clear();
        int i = timeslot;
        while (i < timeslot + from.getHorizon(timeslot)) {
            this.capacityVector.set(i, (Object)from.getElement(i).copyScaled(fraction));
            ++i;
        }
    }

    private void addScaled(int timeslot, StorageState from, double fraction) {
        int i = timeslot;
        while (i < timeslot + from.getHorizon(timeslot)) {
            this.capacityVector.set(i, (Object)from.getElement(i).copyScaled(fraction));
            ++i;
        }
    }

    private void scaleState(int timeslot, StorageState old, double fraction) {
        if (fraction > 1.0 + this.epsilon) {
            log.error("updateState called with fraction > 1");
            return;
        }
        if (fraction < -this.epsilon) {
            log.error("updateState called with negative fraction");
            return;
        }
        for (StorageElement element : old.getElementList(timeslot)) {
            element.scale(fraction);
        }
    }

    public void distributeDemand(int timeslot, List<DemandElement> newDemand, Double ratio) {
        if (newDemand == null || newDemand.size() == 0) {
            return;
        }
        this.capacityVector.clean(timeslot);
        this.setStartIndex(timeslot);
        int maxTimeslot = 0;
        for (DemandElement de : newDemand) {
            de.getNVehicles();
            ratio.doubleValue();
            maxTimeslot = Math.max(maxTimeslot, de.getHorizon() + timeslot);
        }
        Iterator<DemandElement> elements = newDemand.iterator();
        DemandElement nextDe = elements.next();
        int i = timeslot;
        while (i <= maxTimeslot && nextDe != null) {
            int arrayLength = i - timeslot + 1;
            StorageElement se = this.getElement(i);
            if (se == null) {
                se = new StorageElement(i - timeslot + 1);
                this.putElement(i, se);
            }
            if (i == nextDe.getHorizon() + timeslot) {
                nextDe.getNVehicles();
                ratio.doubleValue();
                double[] allocations = nextDe.getdistribution();
                double[] pop = new double[arrayLength];
                double[] energy = new double[arrayLength];
                int nValues = Math.round(Math.min(arrayLength, allocations.length));
                int ix = 0;
                while (ix < nValues) {
                    if (Double.isNaN(allocations[ix])) {
                        log.error("NaN demand ts {}, h {}, i {}", (Object)timeslot, (Object)nextDe.getHorizon(), (Object)ix);
                    } else if (!(allocations[ix] < this.epsilon)) {
                        pop[ix] = nextDe.getNVehicles() * allocations[ix] * ratio;
                        energy[ix] = this.getUnitCapacity() * pop[ix] * ((double)(arrayLength - ix) - 0.5);
                    }
                    ++ix;
                }
                if (allocations.length > se.getEnergy().length) {
                    log.error("ts {} h {}, se array length {} should be {}", (Object)timeslot, (Object)(i - timeslot), (Object)se.getEnergy().length, (Object)allocations.length);
                }
                se.addCommitments(pop, energy);
                nextDe = elements.hasNext() ? elements.next() : null;
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            int horizon = maxTimeslot - timeslot;
            buf.append(String.format("StorageState [p] [e], h = %d:", horizon));
            int i2 = 0;
            while (i2 < Math.min(6, horizon)) {
                buf.append("\n   ");
                StorageElement se = this.getElement(timeslot + i2);
                if (se == null) {
                    log.error("Null StorageElement at {} of {}", (Object)timeslot, (Object)maxTimeslot);
                } else {
                    buf.append(se.toString());
                    buf.append(", r").append(Arrays.toString((double[])se.getRatios(this.unitCapacity)));
                }
                ++i2;
            }
            log.debug((CharSequence)buf);
        }
    }

    public void distributeUsage(int timeslot, double capacity) {
        this.currentUsage = capacity;
        double[] minMax = this.getMinMax(timeslot);
        this.currentMin = minMax[0];
        double remainingCapacity = capacity;
        StorageElement target = this.getElement(timeslot);
        if (target == null) {
            log.warn("No StorageElement at ts {}", (Object)timeslot);
            return;
        }
        double[] energy = target.getEnergy();
        if (energy.length > 1) {
            log.error("Unsatisfiable demand {} in current timeslot{}", (Object)energy.toString(), (Object)timeslot);
            int i = 0;
            while (i < energy.length - 1) {
                remainingCapacity -= this.unitCapacity * target.getPopulation()[i];
                ++i;
            }
        } else {
            remainingCapacity -= energy[0];
            energy[0] = 0.0;
        }
        int ts = timeslot + 1;
        while (ts < timeslot + this.capacityVector.getActiveLength(timeslot)) {
            target = this.getElement(ts);
            double[] pop = target.getPopulation();
            energy = target.getEnergy();
            double usage = Math.min(this.unitCapacity * pop[0], energy[0]);
            target.energy[0] = target.energy[0] - usage;
            remainingCapacity -= usage;
            ++ts;
        }
        double remainingDemand = 0.0;
        int ts2 = timeslot + 1;
        while (ts2 < timeslot + this.capacityVector.getActiveLength(timeslot)) {
            target = this.getElement(ts2);
            int p = 1;
            while (p < target.getPopulation().length) {
                double hrEnergy = Math.min(target.getPopulation()[p] * this.getUnitCapacity(), target.getEnergy()[p]);
                remainingDemand += hrEnergy;
                ++p;
            }
            ++ts2;
        }
        if (0.0 == remainingDemand) {
            if (Math.abs(remainingCapacity) > this.epsilon) {
                log.error("Remaining capacity = {} with remainingDemand = 0.0", (Object)remainingCapacity);
            }
        } else {
            double capacityRatio = remainingCapacity / remainingDemand;
            int ts3 = timeslot + 1;
            while (ts3 < timeslot + this.capacityVector.getActiveLength(timeslot)) {
                target = this.getElement(ts3);
                int e = 1;
                while (e < target.getEnergy().length) {
                    double hrEnergy = Math.min(target.getPopulation()[e] * this.getUnitCapacity(), target.getEnergy()[e]);
                    double[] dArray = target.getEnergy();
                    int n = e++;
                    dArray[n] = dArray[n] - hrEnergy * capacityRatio;
                }
                ++ts3;
            }
        }
    }

    public double distributeRegulation(int timeslot, double regulation) {
        if (Math.abs(regulation) < this.epsilon) {
            return 0.0;
        }
        double result = 0.0;
        if (Math.abs(this.currentUsage - this.currentMin) < this.epsilon) {
            if (regulation > 0.0) {
                log.error("up-regulation {} requested in ts {}, no available capacity", (Object)regulation, (Object)timeslot);
                return result;
            }
            log.warn("ts {} request for down-regulation from min usage not implemented");
            return result;
        }
        double ratio = (this.currentUsage + regulation - this.currentMin) / (this.currentUsage - this.currentMin);
        log.info("Regulation {}, currentUsage={}, currentMin={}, ratio={}", (Object)regulation, (Object)this.currentUsage, (Object)this.currentMin, (Object)ratio);
        int ts = timeslot;
        while (ts < timeslot + this.capacityVector.getActiveLength(timeslot)) {
            StorageElement target = this.getElement(ts);
            double[] pop = target.getPopulation();
            double[] energy = target.getEnergy();
            int i = 1;
            while (i < pop.length) {
                double minMultiplier = Math.max((double)(pop.length - i) - 0.5, 0.0);
                double minE = minMultiplier * pop[i] * this.getUnitCapacity();
                double du = energy[i] - minE;
                double dr = du * ratio;
                energy[i] = minE + dr;
                result += du - dr;
                ++i;
            }
            ++ts;
        }
        return regulation - result;
    }

    public void collapseElements(int timeslot) {
        int ts = timeslot;
        while (ts < timeslot + this.capacityVector.getActiveLength(timeslot)) {
            StorageElement target = this.getElement(ts);
            int lastIndex = target.getEnergy().length - 1;
            if (target.getEnergy()[lastIndex] < -this.epsilon) {
                log.error("negative demand {} timeslot {}", (Object)target.getEnergy()[lastIndex], (Object)ts);
                target.getEnergy()[lastIndex] = 0.0;
                target.getPopulation()[lastIndex] = 0.0;
            } else if (target.getEnergy()[lastIndex] > this.epsilon) {
                double[] dArray = target.getEnergy();
                int n = lastIndex - 1;
                dArray[n] = dArray[n] + target.getEnergy()[lastIndex];
                double[] dArray2 = target.getPopulation();
                int n2 = lastIndex - 1;
                dArray2[n2] = dArray2[n2] + target.getPopulation()[lastIndex];
            }
            target.collapseArrays();
            ++ts;
        }
    }

    public void rebalance(int timeslot) {
        int ts = timeslot + 1;
        while (ts < timeslot + this.capacityVector.getActiveLength(timeslot)) {
            StorageElement target = this.getElement(ts);
            target.rebalance(this.unitCapacity);
            ++ts;
        }
    }

    double[] getMinMax(int timeslot) {
        double minDemand = 0.0;
        double maxDemand = 0.0;
        StorageElement target = this.getElement(timeslot);
        if (target == null || target.getEnergy().length == 0) {
            return new double[]{0.0, 0.0, 0.0};
        }
        minDemand += target.getEnergy()[0];
        int ts = timeslot + 1;
        while (ts < timeslot + this.getHorizon(timeslot)) {
            target = this.getElement(ts);
            double[] pop = target.getPopulation();
            minDemand += Math.min(target.getEnergy()[0], pop[0] * this.getUnitCapacity());
            int i = 1;
            while (i < pop.length) {
                maxDemand += Math.min(target.getEnergy()[i], pop[i] * this.getUnitCapacity());
                ++i;
            }
            ++ts;
        }
        return new double[]{minDemand, maxDemand += minDemand, minDemand + (maxDemand - minDemand) / 2.0};
    }

    public String gatherState(int timeslot) {
        String result = "[";
        log.debug("gatherState({}), horizon={}", (Object)timeslot, (Object)this.getHorizon(timeslot));
        int i = timeslot;
        while (i < timeslot + this.getHorizon(timeslot)) {
            StorageElement se = this.getElement(i);
            result = result.concat(String.format("SE %d %s %s, ", i, Arrays.toString((double[])se.getPopulation()), Arrays.toString((double[])se.getEnergy())));
            ++i;
        }
        log.debug("gatherState() result length = {}", (Object)result.length());
        return result;
    }

    TariffSubscription getSubscription() {
        return this.mySub;
    }

    int getPopulation() {
        return this.mySub.getCustomersCommitted();
    }

    double getUnitCapacity() {
        return this.unitCapacity;
    }

    StorageState withUnitCapacity(double capacity) {
        if (this.unitCapacity < -this.epsilon) {
            log.error("Invalid unit capacity {}", (Object)capacity);
        } else {
            this.unitCapacity = capacity;
        }
        return this;
    }

    int getHorizon(int timeslot) {
        return this.capacityVector.getActiveLength(timeslot);
    }

    StorageElement getElement(int index) {
        return (StorageElement)this.capacityVector.get(index);
    }

    List<StorageElement> getElementList(int start) {
        return this.capacityVector.asList(start);
    }

    private void putElement(int index, StorageElement se) {
        this.capacityVector.set(index, (Object)se);
    }

    int getStartIndex() {
        return this.startIndex;
    }

    void setStartIndex(int index) {
        this.startIndex = index;
    }
}

