/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.customer.evcharger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.CapacityProfile;
import org.powertac.common.Competition;
import org.powertac.common.Tariff;
import org.powertac.customer.evcharger.DemandElement;
import org.powertac.customer.evcharger.EvCharger;
import org.powertac.customer.evcharger.StorageState;

class TariffInfo {
    private static Logger log = LogManager.getLogger((String)TariffInfo.class.getName());
    private final EvCharger evCharger;
    private Tariff tariff;
    private int profileSize;
    private CapacityProfile capacityProfile;
    private double[] tariffCost;
    private double meanTariffCost;
    private double maxTariffCost = 0.0;
    private double minTariffCost = -1.7976931348623157E308;
    private double[] upRegulationPremium;
    private double[] downRegulationPremium;
    private double regulationBias = 0.1;

    TariffInfo(EvCharger evCharger, Tariff tariff) {
        this.evCharger = evCharger;
        this.tariff = tariff;
        if (tariff.isWeekly()) {
            this.profileSize = (int)(604800000L / Competition.currentCompetition().getTimeslotDuration());
            log.info("Weekly profile size: {}", (Object)this.profileSize);
        } else {
            this.profileSize = (int)(86400000L / Competition.currentCompetition().getTimeslotDuration());
            log.info("Daily profile size: {}", (Object)this.profileSize);
        }
        this.upRegulationPremium = new double[this.profileSize];
        this.downRegulationPremium = new double[this.profileSize];
    }

    Tariff getTariff() {
        return this.tariff;
    }

    void setCapacityProfile(CapacityProfile profile) {
        this.capacityProfile = profile;
    }

    CapacityProfile getCapacityProfile() {
        if (this.capacityProfile == null) {
            if (!this.isTOU() && !this.isVariableRate()) {
                this.generateSimpleProfile();
            } else if (this.isTOU()) {
                this.generateTouProfile();
            } else {
                this.setCapacityProfile(this.evCharger.getDefaultCapacityProfile());
            }
        }
        return this.capacityProfile;
    }

    protected void generateSimpleProfile() {
        this.minTariffCost = this.meanTariffCost = this.tariff.getUsageCharge(1.0, 0.0, false);
        this.maxTariffCost = this.meanTariffCost;
        this.setCapacityProfile(this.evCharger.getDefaultCapacityProfile());
    }

    void generateTouProfile() {
        Instant lastSunday;
        if (this.profileSize == 0) {
            log.error("zero profile size");
            this.generateSimpleProfile();
            return;
        }
        this.computeRegulationPremium();
        Instant evalTime = lastSunday = this.evCharger.lastSunday();
        this.tariffCost = new double[this.profileSize];
        double costSum = 0.0;
        long increment = Competition.currentCompetition().getTimeslotDuration();
        int index = 0;
        while (index < this.profileSize) {
            this.tariffCost[index] = this.getTariff().getUsageCharge(evalTime, 1.0, 0.0);
            this.maxTariffCost = Math.min(this.maxTariffCost, this.tariffCost[index]);
            this.minTariffCost = Math.max(this.minTariffCost, this.tariffCost[index]);
            costSum += this.tariffCost[index];
            evalTime = evalTime.plus(increment);
            ++index;
        }
        this.meanTariffCost = costSum / (double)this.profileSize;
        StorageState ss = new StorageState(null, this.evCharger.getChargerCapacity(), this.evCharger.getMaxDemandHorizon()).withUnitCapacity(this.evCharger.getChargerCapacity());
        List<ArrayList<DemandElement>> demandInfo = this.evCharger.getDemandInfoMean();
        if (demandInfo.size() == 0) {
            log.error("empty demandInfo");
            this.generateSimpleProfile();
            return;
        }
        int timeslot = 0;
        while (timeslot < demandInfo.size()) {
            List demand = demandInfo.get(timeslot);
            ss.distributeDemand(timeslot, demand, 1.0);
            double[] limits = ss.getMinMax(timeslot);
            double usage = this.determineUsage(timeslot, limits);
            ss.distributeUsage(timeslot, usage);
            ss.collapseElements(timeslot + 1);
            ss.rebalance(timeslot + 1);
            ++timeslot;
        }
        int repeat = 1;
        if (this.profileSize > demandInfo.size()) {
            repeat = (int)Math.ceil((double)this.profileSize / (double)demandInfo.size());
        }
        double[] profileData = new double[demandInfo.size() * repeat];
        int tsOffset = timeslot;
        int i = 0;
        while (i < repeat) {
            int hour = 0;
            while (hour < demandInfo.size()) {
                double usage;
                List demand = demandInfo.get(hour);
                ss.distributeDemand(timeslot, demand, 1.0);
                double[] limits = ss.getMinMax(timeslot);
                profileData[timeslot - tsOffset] = usage = this.determineUsage(timeslot - tsOffset, limits);
                ss.distributeUsage(timeslot, usage);
                ss.collapseElements(timeslot + 1);
                ss.rebalance(timeslot + 1);
                ++timeslot;
                ++hour;
            }
            ++i;
        }
        this.capacityProfile = new CapacityProfile(profileData, lastSunday);
    }

    double determineUsage(int hour, double[] limits) {
        if (!this.isTOU()) {
            return limits[2];
        }
        int index = hour % this.profileSize;
        double result = limits[2];
        if (this.tariffCost[index] >= this.meanTariffCost) {
            result = limits[1];
            if (this.downRegulationPremium[hour] > 0.0) {
                result -= (limits[2] - limits[0]) * this.regulationBias;
            }
        } else {
            result = limits[0];
            if (this.upRegulationPremium[hour] > 0.0) {
                result += (limits[1] - limits[2]) * this.regulationBias;
            }
        }
        return result;
    }

    boolean isTOU() {
        return this.tariff.isTimeOfUse();
    }

    boolean isVariableRate() {
        return this.tariff.isVariableRate();
    }

    double getDemandBias() {
        double result = this.evCharger.getNominalDemandBias();
        return result;
    }

    void computeRegulationPremium() {
        if (this.tariff.hasRegulationRate()) {
            double upregPayment = this.getTariff().getRegulationCharge(-1.0, 0.0, false);
            double downregCost = this.getTariff().getRegulationCharge(1.0, 0.0, false);
            Instant evalTime = this.evCharger.lastSunday();
            long increment = Competition.currentCompetition().getTimeslotDuration();
            int index = 0;
            while (index < this.profileSize) {
                double cost = this.getTariff().getUsageCharge(evalTime, 1.0, 0.0);
                this.upRegulationPremium[index] = upregPayment + cost;
                this.downRegulationPremium[index] = downregCost - cost;
                evalTime = evalTime.plus(increment);
                ++index;
            }
        } else {
            Arrays.fill(this.upRegulationPremium, 0.0);
            Arrays.fill(this.downRegulationPremium, 0.0);
        }
    }
}

