/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.du;

import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.PluginConfig;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.PluginConfigRepo;
import org.powertac.du.DefaultBrokerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultBrokerInitializationService
implements InitializationService {
    private static Logger log = Logger.getLogger((String)DefaultBrokerInitializationService.class.getName());
    @Autowired
    private DefaultBrokerService defaultBrokerService;
    @Autowired
    private PluginConfigRepo pluginConfigRepo;
    @Autowired
    private BrokerRepo brokerRepo;

    public void setDefaults() {
        this.brokerRepo.add(this.defaultBrokerService.createBroker("default broker"));
        this.pluginConfigRepo.makePluginConfig("defaultBroker", "init").addConfiguration("consumptionRate", "-0.5").addConfiguration("productionRate", "0.02").addConfiguration("initialBidKWh", "1000.0").addConfiguration("buyLimitPriceMax", "-5.0").addConfiguration("buyLimitPriceMin", "-100.0").addConfiguration("sellLimitPriceMin", "0.1").addConfiguration("sellLimitPriceMax", "30.0");
    }

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("TariffMarket");
        if (index == -1) {
            return null;
        }
        PluginConfig config = this.pluginConfigRepo.findByRoleName("defaultBroker");
        if (config == null) {
            log.error((Object)"PluginConfig for Generic does not exist.");
            return "fail";
        }
        this.defaultBrokerService.init(config);
        return "DefaultBroker";
    }
}

