/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.du;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.CashPosition;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.MarketPosition;
import org.powertac.common.MarketTransaction;
import org.powertac.common.Order;
import org.powertac.common.RandomSeed;
import org.powertac.common.Rate;
import org.powertac.common.RateCore;
import org.powertac.common.RegulationRate;
import org.powertac.common.TariffSpecification;
import org.powertac.common.TariffTransaction;
import org.powertac.common.Timeslot;
import org.powertac.common.WeatherReport;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.BootstrapDataCollector;
import org.powertac.common.interfaces.BrokerProxy;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.common.msg.MarketBootstrapData;
import org.powertac.common.msg.TimeslotComplete;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.du.DefaultBroker;
import org.powertac.util.MessageDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultBrokerService
implements BootstrapDataCollector,
InitializationService {
    private static Logger log = LogManager.getLogger((String)DefaultBrokerService.class.getName());
    @Autowired
    private BrokerProxy brokerProxyService;
    @Autowired
    private CompetitionControl competitionControlService;
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private ServerConfiguration serverPropertiesService;
    private DefaultBroker face;
    private Competition competition;
    private double defaultConsumptionRate = -1.0;
    private double defaultProductionRate = 0.01;
    private double initialBidKWh = 500.0;
    private double buyLimitPriceMax = -1.0;
    private double buyLimitPriceMin = -100.0;
    private double sellLimitPriceMax = 100.0;
    private double sellLimitPriceMin = 0.2;
    private int usageRecordLength = 168;
    private boolean bootstrapMode = false;
    private HashMap<Timeslot, ArrayList<MarketTransaction>> marketTxMap;
    private ArrayList<Double> marketMWh;
    private ArrayList<Double> marketPrice;
    private ArrayList<WeatherReport> weather;
    private HashMap<TariffSpecification, HashMap<CustomerInfo, CustomerRecord>> customerSubscriptions;
    private RandomSeed randomSeed;
    private HashMap<Timeslot, Order> lastOrder;
    private double minMWh = 1.0E-6;

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("TariffMarket");
        if (index == -1) {
            return null;
        }
        this.competition = competition;
        this.brokerRepo.add(this.createBroker("default broker"));
        this.competitionControlService.loginBroker(this.face.getUsername());
        this.bootstrapMode = this.competitionControlService.isBootstrapMode();
        log.info("init, bootstrapMode=" + this.bootstrapMode);
        this.customerSubscriptions = new LinkedHashMap<TariffSpecification, HashMap<CustomerInfo, CustomerRecord>>();
        this.lastOrder = new HashMap();
        this.randomSeed = this.randomSeedRepo.getRandomSeed(this.getClass().getName(), 0L, "pricing");
        if (this.bootstrapMode) {
            this.marketTxMap = new HashMap();
            this.marketMWh = new ArrayList();
            this.marketPrice = new ArrayList();
            this.weather = new ArrayList();
        }
        this.serverPropertiesService.configureMe((Object)this);
        TariffSpecification defaultConsumption = new TariffSpecification((Broker)this.face, PowerType.CONSUMPTION).addRate((RateCore)new Rate().withValue(this.defaultConsumptionRate));
        this.tariffMarketService.setDefaultTariff(defaultConsumption);
        this.customerSubscriptions.put(defaultConsumption, new LinkedHashMap());
        TariffSpecification defaultProduction = new TariffSpecification((Broker)this.face, PowerType.PRODUCTION).addRate((RateCore)new Rate().withValue(this.defaultProductionRate));
        this.tariffMarketService.setDefaultTariff(defaultProduction);
        this.customerSubscriptions.put(defaultProduction, new LinkedHashMap());
        TariffSpecification defaultStorage = new TariffSpecification((Broker)this.face, PowerType.STORAGE).addRate((RateCore)new Rate().withValue(this.defaultConsumptionRate)).addRate((RateCore)new RegulationRate().withUpRegulationPayment(this.defaultProductionRate).withDownRegulationPayment(this.defaultConsumptionRate));
        this.tariffMarketService.setDefaultTariff(defaultStorage);
        this.customerSubscriptions.put(defaultStorage, new LinkedHashMap());
        return "DefaultBroker";
    }

    public Broker createBroker(String username) {
        this.face = new DefaultBroker(username);
        this.face.setService(this);
        return this.face;
    }

    public DefaultBroker getFace() {
        return this.face;
    }

    public void activate() {
        Timeslot current = this.timeslotRepo.currentTimeslot();
        log.info("activate: timeslot " + current.getSerialNumber());
        if (current.getSerialNumber() < 24) {
            double currentKWh = this.collectUsage(current.getSerialNumber());
            double neededKWh = 0.0;
            for (Timeslot timeslot : this.timeslotRepo.enabledTimeslots()) {
                int index = timeslot.getSerialNumber() % 24;
                double historicalKWh = this.collectUsage(index);
                neededKWh = historicalKWh != 0.0 ? historicalKWh : currentKWh;
                this.submitOrder(neededKWh, timeslot);
            }
        } else if (current.getSerialNumber() <= this.usageRecordLength) {
            for (Timeslot timeslot : this.timeslotRepo.enabledTimeslots()) {
                double neededKWh = 0.0;
                int index = timeslot.getSerialNumber() % 24;
                int count = 0;
                while (index <= current.getSerialNumber()) {
                    neededKWh += this.collectUsage(index);
                    index += 24;
                    ++count;
                }
                this.submitOrder(neededKWh / (double)count, timeslot);
            }
        } else {
            double neededKWh = 0.0;
            for (Timeslot timeslot : this.timeslotRepo.enabledTimeslots()) {
                int index = timeslot.getSerialNumber() % this.usageRecordLength;
                neededKWh = this.collectUsage(index);
                this.submitOrder(neededKWh, timeslot);
            }
        }
    }

    double collectUsage(int index) {
        double result = 0.0;
        for (HashMap<CustomerInfo, CustomerRecord> customerMap : this.customerSubscriptions.values()) {
            for (CustomerRecord record : customerMap.values()) {
                result += record.getUsage(index);
            }
        }
        log.debug("Usage(" + index + ")=" + result);
        return -result;
    }

    private void submitOrder(double neededKWh, Timeslot timeslot) {
        double neededMWh = neededKWh / 1000.0;
        if (Math.abs(neededMWh) < this.competition.getMinimumOrderQuantity()) {
            return;
        }
        MarketPosition posn = this.face.findMarketPositionByTimeslot(timeslot.getSerialNumber());
        if (posn != null) {
            neededMWh -= posn.getOverallBalance();
        }
        log.debug("needed mWh=" + neededMWh);
        if (Math.abs(neededMWh) < this.minMWh) {
            log.info("no power required in timeslot " + timeslot.getSerialNumber());
            return;
        }
        Double limitPrice = this.computeLimitPrice(timeslot, neededMWh);
        log.info("new order for " + neededMWh + " at " + limitPrice + " in timeslot " + timeslot.getSerialNumber());
        Order result = new Order((Broker)this.face, timeslot.getSerialNumber(), neededMWh, limitPrice);
        this.lastOrder.put(timeslot, result);
        this.brokerProxyService.routeMessage((Object)result);
    }

    private Double computeLimitPrice(Timeslot timeslot, double amountNeeded) {
        double minPrice;
        Double oldLimitPrice;
        if (amountNeeded > 0.0) {
            oldLimitPrice = this.buyLimitPriceMax;
            minPrice = this.buyLimitPriceMin;
        } else {
            oldLimitPrice = this.sellLimitPriceMax;
            minPrice = this.sellLimitPriceMin;
        }
        Order lastTry = this.lastOrder.get(timeslot);
        if (lastTry != null && Math.signum(amountNeeded) == Math.signum(lastTry.getMWh())) {
            oldLimitPrice = lastTry.getLimitPrice();
        }
        double newLimitPrice = minPrice;
        Timeslot current = this.timeslotRepo.currentTimeslot();
        int remainingTries = timeslot.getSerialNumber() - current.getSerialNumber() - Competition.currentCompetition().getDeactivateTimeslotsAhead();
        if (remainingTries > 0) {
            double range = (minPrice - oldLimitPrice) * 2.0 / (double)remainingTries;
            log.debug("oldLimitPrice=" + oldLimitPrice + ", range=" + range);
            double computedPrice = oldLimitPrice + this.randomSeed.nextDouble() * range;
            return Math.max(newLimitPrice, computedPrice);
        }
        return null;
    }

    public void receiveBrokerMessage(Object msg) {
        if (msg != null) {
            MessageDispatcher.dispatch((Object)this, (String)"handleMessage", (Object[])new Object[]{msg});
        }
    }

    public void handleMessage(TariffTransaction ttx) {
        TariffTransaction.Type txType = ttx.getTxType();
        CustomerInfo customer = ttx.getCustomerInfo();
        HashMap<CustomerInfo, CustomerRecord> customerMap = this.customerSubscriptions.get(ttx.getTariffSpec());
        CustomerRecord record = customerMap.get(customer);
        if (TariffTransaction.Type.SIGNUP == txType) {
            if (record == null) {
                record = new CustomerRecord(customer, ttx.getCustomerCount());
                customerMap.put(customer, record);
            } else {
                record.signup(ttx.getCustomerCount());
            }
        } else if (TariffTransaction.Type.WITHDRAW == txType) {
            if (customerMap.get(customer) == null) {
                log.warn("unknown customer withdraws subscription");
            } else {
                record.withdraw(ttx.getCustomerCount());
            }
        } else if (TariffTransaction.Type.PRODUCE == txType) {
            if (ttx.getCustomerCount() != record.subscribedPopulation) {
                log.info("production by subset " + ttx.getCustomerCount() + " of subscribed population " + record.subscribedPopulation);
            }
            record.produceConsume(ttx.getKWh(), ttx.getPostedTime());
        } else if (TariffTransaction.Type.CONSUME == txType) {
            if (ttx.getCustomerCount() != record.subscribedPopulation) {
                log.info("consumption by subset " + ttx.getCustomerCount() + " of subscribed population " + record.subscribedPopulation);
            }
            record.produceConsume(ttx.getKWh(), ttx.getPostedTime());
        }
    }

    public void handleMessage(WeatherReport report) {
        if (this.bootstrapMode) {
            this.weather.add(report);
        }
    }

    public void handleMessage(MarketTransaction tx) {
        Order lastTry;
        if (this.bootstrapMode) {
            ArrayList<Object> txs = this.marketTxMap.get(tx.getTimeslot());
            if (txs == null) {
                txs = new ArrayList();
                this.marketTxMap.put(tx.getTimeslot(), txs);
            }
            txs.add(tx);
        }
        if ((lastTry = this.lastOrder.get(tx.getTimeslot())) == null) {
            log.error("order corresponding to market tx " + tx + " is null");
        } else if (tx.getMWh() == lastTry.getMWh().doubleValue()) {
            this.lastOrder.put(tx.getTimeslot(), null);
        }
    }

    public void handleMessage(CustomerBootstrapData cbd) {
        CustomerInfo customer;
        TariffSpecification tariff = null;
        for (TariffSpecification spec : this.customerSubscriptions.keySet()) {
            if (!cbd.getPowerType().canUse(spec.getPowerType())) continue;
            tariff = spec;
            break;
        }
        if (tariff == null) {
            log.error("Failed to find tariff for powerType " + cbd.getPowerType());
        }
        if (null == (customer = this.customerRepo.findByNameAndPowerType(cbd.getCustomerName(), cbd.getPowerType()))) {
            log.error("Failed to find customer " + cbd.getCustomerName());
        } else {
            HashMap<CustomerInfo, CustomerRecord> customerMap = this.customerSubscriptions.get(tariff);
            CustomerRecord record = customerMap.get(customer);
            if (record == null) {
                record = new CustomerRecord(customer, customer.getPopulation());
                customerMap.put(customer, record);
            }
            int offset = this.timeslotRepo.currentTimeslot().getSerialNumber() - cbd.getNetUsage().length;
            for (int i = 0; i < cbd.getNetUsage().length; ++i) {
                record.produceConsume(cbd.getNetUsage()[i], i + offset);
            }
        }
    }

    public void handleMessage(CashPosition cp) {
        if (this.bootstrapMode) {
            this.recordDeliveredPrice();
        }
    }

    public void handleMessage(TimeslotComplete tc) {
        this.activate();
    }

    private void recordDeliveredPrice() {
        Timeslot current = this.timeslotRepo.currentTimeslot();
        ArrayList<Object> txList = this.marketTxMap.get(current);
        if (txList == null) {
            txList = new ArrayList();
            this.marketTxMap.put(current, txList);
        }
        double totalMWh = 0.0;
        double totalCost = 0.0;
        for (MarketTransaction marketTransaction : txList) {
            if (!(marketTransaction.getMWh() > 0.0)) continue;
            log.info("record price: mwh=" + marketTransaction.getMWh() + ", price=" + marketTransaction.getPrice());
            totalMWh += marketTransaction.getMWh();
            totalCost += marketTransaction.getPrice() * marketTransaction.getMWh();
        }
        log.info("market totals: mwh=" + totalMWh + ", price=" + totalCost / totalMWh);
        this.marketMWh.add(totalMWh);
        if (totalMWh == 0.0) {
            this.marketPrice.add(0.0);
        } else {
            this.marketPrice.add(totalCost / totalMWh);
        }
    }

    public List<Object> collectBootstrapData(int maxTimeslots) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (CustomerBootstrapData customerBootstrapData : this.getCustomerBootstrapData(maxTimeslots)) {
            result.add(customerBootstrapData);
        }
        result.add(this.getMarketBootstrapData(maxTimeslots));
        for (CustomerBootstrapData customerBootstrapData : this.getWeatherReports(maxTimeslots)) {
            result.add(customerBootstrapData);
        }
        return result;
    }

    List<CustomerBootstrapData> getCustomerBootstrapData(int maxTimeslots) {
        ArrayList<CustomerBootstrapData> result = new ArrayList<CustomerBootstrapData>();
        for (TariffSpecification spec : this.customerSubscriptions.keySet()) {
            HashMap<CustomerInfo, CustomerRecord> customerMap = this.customerSubscriptions.get(spec);
            for (CustomerInfo customer : customerMap.keySet()) {
                CustomerRecord record = customerMap.get(customer);
                ArrayList<Double> usageList = record.bootstrapUsage;
                int startIndex = Math.max(0, usageList.size() - maxTimeslots);
                double[] usage = new double[usageList.size() - startIndex];
                for (int i = 0; i < usage.length; ++i) {
                    usage[i] = usageList.get(i + startIndex);
                }
                result.add(new CustomerBootstrapData(customer, customer.getPowerType(), usage));
            }
        }
        return result;
    }

    MarketBootstrapData getMarketBootstrapData(int maxTimeslots) {
        if (this.marketMWh.size() != this.marketPrice.size()) {
            log.error("marketMWh.size()=" + this.marketMWh.size() + " != " + "marketPrice.size()=" + this.marketPrice.size());
        }
        int startOffset = Math.max(0, this.marketMWh.size() - maxTimeslots);
        int size = this.marketMWh.size() - startOffset;
        double[] mwh = new double[size];
        double[] price = new double[size];
        for (int i = 0; i < size; ++i) {
            mwh[i] = this.marketMWh.get(i + startOffset);
            price[i] = this.marketPrice.get(i + startOffset);
        }
        return new MarketBootstrapData(mwh, price);
    }

    List<WeatherReport> getWeatherReports(int maxTimeslotCount) {
        int discardCount = this.weather.size() - maxTimeslotCount;
        if (discardCount > 0) {
            for (int i = 0; i < discardCount; ++i) {
                this.weather.remove(0);
            }
        }
        return this.weather;
    }

    public double getConsumptionRate() {
        return this.defaultConsumptionRate;
    }

    @ConfigurableValue(valueType="Double", description="Fixed price/kwh for default consumption tariff")
    public void setConsumptionRate(double defaultConsumptionRate) {
        this.defaultConsumptionRate = defaultConsumptionRate;
    }

    public double getProductionRate() {
        return this.defaultProductionRate;
    }

    @ConfigurableValue(valueType="Double", description="Fixed price/kwh for default production tariff")
    public void setProductionRate(double defaultProductionRate) {
        this.defaultProductionRate = defaultProductionRate;
    }

    public double getInitialBidKWh() {
        return this.initialBidKWh;
    }

    @ConfigurableValue(valueType="Double", description="Quantity to buy in day-ahead market before seeing actual customer data")
    public void setInitialBidKWh(double initialBidKWh) {
        this.initialBidKWh = initialBidKWh;
    }

    public double getBuyLimitPriceMax() {
        return this.buyLimitPriceMax;
    }

    @ConfigurableValue(valueType="Double", description="Initial limit price/mwh for bids in day-ahead market")
    public void setBuyLimitPriceMax(double buyLimitPriceMax) {
        this.buyLimitPriceMax = buyLimitPriceMax;
    }

    public double getBuyLimitPriceMin() {
        return this.buyLimitPriceMin;
    }

    @ConfigurableValue(valueType="Double", description="Final limit price/mwh for bids in day-ahead market")
    public void setBuyLimitPriceMin(double buyLimitPriceMin) {
        this.buyLimitPriceMin = buyLimitPriceMin;
    }

    public double getSellLimitPriceMax() {
        return this.sellLimitPriceMax;
    }

    @ConfigurableValue(valueType="Double", description="Initial limit price/mwh for asks in day-ahead market")
    public void setSellLimitPriceMax(double sellLimitPriceMax) {
        this.sellLimitPriceMax = sellLimitPriceMax;
    }

    public double getSellLimitPriceMin() {
        return this.sellLimitPriceMin;
    }

    @ConfigurableValue(valueType="Double", description="Final limit price/mwh for asks in day-ahead market")
    public void setSellLimitPriceMin(double sellLimitPriceMin) {
        this.sellLimitPriceMin = sellLimitPriceMin;
    }

    HashMap<String, Integer> getCustomerCounts() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (TariffSpecification spec : this.customerSubscriptions.keySet()) {
            HashMap<CustomerInfo, CustomerRecord> customerMap = this.customerSubscriptions.get(spec);
            for (CustomerRecord record : customerMap.values()) {
                result.put(record.customer.getName() + spec.getPowerType(), record.subscribedPopulation);
            }
        }
        return result;
    }

    double getUsageForCustomer(CustomerInfo customer, TariffSpecification tariffSpec, int index) {
        CustomerRecord record = this.customerSubscriptions.get(tariffSpec).get(customer);
        return record.getUsage(index);
    }

    boolean isBootstrapMode() {
        return this.bootstrapMode;
    }

    static /* synthetic */ int access$000(DefaultBrokerService x0) {
        return x0.usageRecordLength;
    }

    class CustomerRecord {
        CustomerInfo customer;
        int subscribedPopulation = 0;
        double[] usage = new double[DefaultBrokerService.access$000(DefaultBrokerService.this)];
        int usageIndexOffset = -1;
        ArrayList<Double> bootstrapUsage = new ArrayList();
        Instant base = null;
        double alpha = 0.3;

        CustomerRecord(CustomerInfo customer, int population) {
            this.customer = customer;
            this.subscribedPopulation = population;
            this.base = DefaultBrokerService.this.timeslotRepo.findBySerialNumber(0).getStartInstant();
        }

        CustomerInfo getCustomerInfo() {
            return this.customer;
        }

        void signup(int population) {
            this.subscribedPopulation = Math.min(this.customer.getPopulation(), this.subscribedPopulation + population);
        }

        void withdraw(int population) {
            this.subscribedPopulation -= population;
        }

        void produceConsume(double kwh, Instant when) {
            int index = this.getIndex(when);
            this.produceConsume(kwh, index);
        }

        void produceConsume(double kwh, int rawIndex) {
            if (DefaultBrokerService.this.bootstrapMode) {
                if (this.bootstrapUsage.size() <= rawIndex) {
                    while (this.bootstrapUsage.size() < rawIndex) {
                        this.bootstrapUsage.add(0.0);
                    }
                    this.bootstrapUsage.add(kwh);
                } else {
                    this.bootstrapUsage.set(rawIndex, this.bootstrapUsage.get(rawIndex) + kwh);
                }
            }
            int index = this.getIndex(rawIndex);
            double kwhPerCustomer = kwh / (double)this.subscribedPopulation;
            double oldUsage = this.usage[index];
            this.usage[index] = oldUsage == 0.0 ? kwhPerCustomer : this.alpha * kwhPerCustomer + (1.0 - this.alpha) * oldUsage;
            log.debug("consume " + kwh + " at " + index + ", customer " + this.customer.getName());
        }

        double getUsage(int index) {
            if (index < 0) {
                log.warn("usage requested for negative index " + index);
                index = 0;
            }
            return this.usage[this.getIndex(index)] * (double)this.subscribedPopulation;
        }

        int getIndex(Instant when) {
            int offset = this.getUsageIndexOffset();
            int result = (int)((when.getMillis() - this.base.getMillis()) / Competition.currentCompetition().getTimeslotDuration()) - offset;
            log.debug("offset=" + offset + ", index=" + result);
            return result;
        }

        private int getIndex(int rawIndex) {
            return rawIndex % this.usage.length;
        }

        private int getUsageIndexOffset() {
            if (this.usageIndexOffset < 0) {
                this.usageIndexOffset = 0;
                if (!DefaultBrokerService.this.bootstrapMode) {
                    this.usageIndexOffset = Competition.currentCompetition().getBootstrapTimeslotCount() + Competition.currentCompetition().getBootstrapDiscardedTimeslots();
                }
            }
            return this.usageIndexOffset;
        }
    }
}

