/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.BigMatrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.quadratic.QuadraticSolver;
import org.ojalgo.type.StandardType;
import org.powertac.common.Broker;
import org.powertac.common.Orderbook;
import org.powertac.common.PluginConfig;
import org.powertac.common.RandomSeed;
import org.powertac.common.Timeslot;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.CompetitionControl;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.OrderbookRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionUtilityService
extends TimeslotPhaseProcessor {
    Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private OrderbookRepo orderbookRepo;
    @Autowired
    private Accounting accountingService;
    @Autowired
    private CompetitionControl competitionControlService;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private RandomSeed randomGen;
    long id = 0L;
    private double distributionFee = -0.01;
    private double balancingCost = -0.06;
    private double defaultSpotPrice = -30.0;

    public void init(PluginConfig config) {
        double distributionFeeMin = config.getDoubleValue("distributionFeeMin", Double.valueOf(-0.005));
        double distributionFeeMax = config.getDoubleValue("distributionFeeMax", Double.valueOf(-0.15));
        double balancingCostMin = config.getDoubleValue("balancingCostMin", Double.valueOf(-0.04));
        double balancingCostMax = config.getDoubleValue("balancingCostMax", Double.valueOf(-0.08));
        this.randomGen = this.randomSeedService.getRandomSeed("DistributionUtilityService", this.id, "model");
        this.distributionFee = distributionFeeMin + this.randomGen.nextDouble() * (distributionFeeMax - distributionFeeMin);
        this.balancingCost = balancingCostMin + this.randomGen.nextDouble() * (balancingCostMax - balancingCostMin);
        super.init();
        this.log.info((Object)("Configured DU: distro fee = " + this.distributionFee + ", balancing cost = " + this.balancingCost));
    }

    public void activate(Instant time, int phaseNumber) {
        this.log.info((Object)"Activate");
        List brokerList = this.brokerRepo.findRetailBrokers();
        if (brokerList == null) {
            this.log.error((Object)"Failed to retrieve retail broker list");
            return;
        }
        this.balanceTimeslot(this.timeslotRepo.currentTimeslot(), brokerList);
    }

    public double getMarketBalance(Broker broker) {
        double result = this.accountingService.getCurrentMarketPosition(broker) * 1000.0 + this.accountingService.getCurrentNetLoad(broker);
        this.log.info((Object)("market balance for " + broker.getUsername() + ": " + result));
        return result;
    }

    public double getSpotPrice() {
        Double result = this.defaultSpotPrice;
        Orderbook ob = this.orderbookRepo.findSpotByTimeslot(this.timeslotRepo.currentTimeslot());
        if (ob != null) {
            result = -ob.getClearingPrice().doubleValue();
        } else {
            this.log.info((Object)"null Orderbook");
        }
        return result / 1000.0;
    }

    public double getPMax() {
        double result = this.defaultSpotPrice;
        List obs = this.orderbookRepo.findAllByTimeslot(this.timeslotRepo.currentTimeslot());
        if (obs.size() > 0) {
            Double max = null;
            for (Orderbook ob : obs) {
                Double price = ob.getClearingPrice();
                if (price == null || max != null && !(price > max)) continue;
                max = price;
            }
            result = max;
        }
        return result;
    }

    public double getPMin() {
        double result = this.defaultSpotPrice;
        List obs = this.orderbookRepo.findAllByTimeslot(this.timeslotRepo.currentTimeslot());
        if (obs.size() > 0) {
            Double min = null;
            for (Orderbook ob : obs) {
                Double price = ob.getClearingPrice();
                if (price == null || min != null && !(price < min)) continue;
                min = price;
            }
            result = min;
        }
        return result;
    }

    public List<ChargeInfo> balanceTimeslot(Timeslot currentTimeslot, List<Broker> brokerList) {
        ArrayList<Double> brokerBalances = new ArrayList<Double>();
        for (Broker broker : brokerList) {
            brokerBalances.add(this.getMarketBalance(broker));
        }
        List<Double> balanceCharges = this.computeNonControllableBalancingCharges(brokerList, brokerBalances);
        ArrayList<ChargeInfo> chargeInfoList = new ArrayList<ChargeInfo>();
        for (int i = 0; i < brokerList.size(); ++i) {
            Broker theBroker = brokerList.get(i);
            double theNetLoad = -this.accountingService.getCurrentNetLoad(theBroker);
            this.accountingService.addDistributionTransaction(theBroker, theNetLoad, theNetLoad * this.distributionFee);
            double theBalanceCharge = -balanceCharges.get(i).doubleValue();
            chargeInfoList.add(new ChargeInfo(theBroker.getUsername(), theNetLoad, theBalanceCharge));
            if (theBalanceCharge == 0.0) continue;
            this.accountingService.addBalancingTransaction(theBroker, ((Double)brokerBalances.get(i)).doubleValue(), theBalanceCharge);
        }
        return chargeInfoList;
    }

    List<Double> computeNonControllableBalancingCharges(List<Broker> brokerList, List<Double> balanceList) {
        int i;
        BigMatrix[] inputMatrices = new BigMatrix[6];
        int numOfBrokers = brokerList.size();
        double P = -this.getSpotPrice();
        double c0 = -this.balancingCost;
        double x = 0.0;
        double[] brokerBalance = new double[numOfBrokers];
        double[][] AE = new double[1][numOfBrokers];
        double[][] BE = new double[1][1];
        double[][] Q = new double[numOfBrokers][numOfBrokers];
        double[][] C = new double[numOfBrokers][1];
        double[][] AI = new double[numOfBrokers + 1][numOfBrokers];
        double[][] BI = new double[numOfBrokers + 1][1];
        for (i = 0; i < numOfBrokers; ++i) {
            brokerBalance[i] = balanceList.get(i);
            x += brokerBalance[i];
        }
        for (i = 0; i < numOfBrokers; ++i) {
            AE[0][i] = 0.0;
            C[i][0] = brokerBalance[i] * P;
            for (int j = 0; j < numOfBrokers; ++j) {
                if (i == j) {
                    Q[i][j] = 1.0;
                    AI[i][j] = -1.0;
                    continue;
                }
                Q[i][j] = 0.0;
                AI[i][j] = 0.0;
            }
            AI[numOfBrokers][i] = -1.0;
            BI[i][0] = brokerBalance[i] * P;
        }
        BE[0][0] = 0.0;
        BI[numOfBrokers][0] = x * c0;
        inputMatrices[0] = BigMatrix.FACTORY.copy(AE);
        inputMatrices[1] = BigMatrix.FACTORY.copy(BE);
        inputMatrices[2] = BigMatrix.FACTORY.copy(Q);
        inputMatrices[3] = BigMatrix.FACTORY.copy(C);
        inputMatrices[4] = BigMatrix.FACTORY.copy(AI);
        inputMatrices[5] = BigMatrix.FACTORY.copy(BI);
        QuadraticSolver.Builder tmpBuilder = new QuadraticSolver.Builder((MatrixStore)inputMatrices[2].round(StandardType.DECIMAL_032).toPrimitiveStore(), (MatrixStore)inputMatrices[3].round(StandardType.DECIMAL_032).negate().toPrimitiveStore());
        tmpBuilder.equalities((MatrixStore)inputMatrices[0].round(StandardType.DECIMAL_032).toPrimitiveStore(), (MatrixStore)inputMatrices[1].round(StandardType.DECIMAL_032).toPrimitiveStore());
        tmpBuilder.inequalities((MatrixStore)inputMatrices[4].round(StandardType.DECIMAL_032).toPrimitiveStore(), (MatrixStore)inputMatrices[5].round(StandardType.DECIMAL_032).toPrimitiveStore());
        QuadraticSolver myQuadraticSolver = tmpBuilder.build();
        BasicMatrix result = myQuadraticSolver.solve().getSolution();
        ArrayList<Double> solutionList = new ArrayList<Double>();
        for (int i2 = 0; i2 < numOfBrokers; ++i2) {
            solutionList.add(result.doubleValue(i2, 0));
        }
        return solutionList;
    }

    public class ChargeInfo {
        public String itsBrokerName = "";
        public double itsNetLoadKWh = 0.0;
        public double itsBalanceCharge = 0.0;

        public ChargeInfo(String inBrokerName, double inNetLoadKWh, double inBalanceCharge) {
            this.itsBrokerName = inBrokerName;
            this.itsNetLoadKWh = inNetLoadKWh;
            this.itsBalanceCharge = inBalanceCharge;
        }
    }
}

