/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.List;
import org.apache.log4j.Logger;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.BigMatrix;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.quadratic.QuadraticSolver;
import org.ojalgo.type.StandardType;
import org.powertac.distributionutility.ChargeInfo;
import org.powertac.distributionutility.SettlementContext;
import org.powertac.distributionutility.SettlementProcessor;

public class SimpleSettlementProcessor
implements SettlementProcessor {
    static Logger log = null;

    public SimpleSettlementProcessor() {
        if (null == log) {
            log = Logger.getLogger((String)this.getClass().getName());
        }
    }

    @Override
    public void settle(SettlementContext service, List<ChargeInfo> brokerData) {
        int i;
        BigMatrix[] inputMatrices = new BigMatrix[6];
        int numOfBrokers = brokerData.size();
        double pMax = service.getPPlus();
        double pMin = service.getPMinus();
        log.debug((Object)("pMax=" + pMax + ", pMin=" + pMin));
        double c0 = -service.getBalancingCost().doubleValue();
        double x = 0.0;
        double[] brokerBalance = new double[numOfBrokers];
        double[][] AE = new double[1][numOfBrokers];
        double[][] BE = new double[1][1];
        double[][] Q = new double[numOfBrokers][numOfBrokers];
        double[][] C = new double[numOfBrokers][1];
        double[][] AI = new double[numOfBrokers + 1][numOfBrokers];
        double[][] BI = new double[numOfBrokers + 1][1];
        for (i = 0; i < numOfBrokers; ++i) {
            brokerBalance[i] = brokerData.get(i).getNetLoadKWh();
            x += brokerBalance[i];
            log.debug((Object)("broker[" + i + "].balance=" + brokerBalance[i]));
        }
        for (i = 0; i < numOfBrokers; ++i) {
            AE[0][i] = 0.0;
            if (brokerBalance[i] < 0.0) {
                BI[i][0] = brokerBalance[i] * pMax;
                C[i][0] = brokerBalance[i] * pMax;
            } else {
                BI[i][0] = brokerBalance[i] * pMin;
                C[i][0] = brokerBalance[i] * pMin;
            }
            for (int j = 0; j < numOfBrokers; ++j) {
                if (i == j) {
                    Q[i][j] = 1.0;
                    AI[i][j] = -1.0;
                    continue;
                }
                Q[i][j] = 0.0;
                AI[i][j] = 0.0;
            }
            AI[numOfBrokers][i] = -1.0;
        }
        BE[0][0] = 0.0;
        BI[numOfBrokers][0] = x * c0;
        inputMatrices[0] = BigMatrix.FACTORY.copy(AE);
        inputMatrices[1] = BigMatrix.FACTORY.copy(BE);
        inputMatrices[2] = BigMatrix.FACTORY.copy(Q);
        inputMatrices[3] = BigMatrix.FACTORY.copy(C);
        inputMatrices[4] = BigMatrix.FACTORY.copy(AI);
        inputMatrices[5] = BigMatrix.FACTORY.copy(BI);
        QuadraticSolver.Builder tmpBuilder = new QuadraticSolver.Builder((MatrixStore)inputMatrices[2].round(StandardType.DECIMAL_032).toPrimitiveStore(), (MatrixStore)inputMatrices[3].round(StandardType.DECIMAL_032).negate().toPrimitiveStore());
        tmpBuilder.equalities((MatrixStore)inputMatrices[0].round(StandardType.DECIMAL_032).toPrimitiveStore(), (MatrixStore)inputMatrices[1].round(StandardType.DECIMAL_032).toPrimitiveStore());
        tmpBuilder.inequalities((MatrixStore)inputMatrices[4].round(StandardType.DECIMAL_032).toPrimitiveStore(), (MatrixStore)inputMatrices[5].round(StandardType.DECIMAL_032).toPrimitiveStore());
        QuadraticSolver myQuadraticSolver = tmpBuilder.build();
        BasicMatrix result = myQuadraticSolver.solve().getSolution();
        for (int i2 = 0; i2 < numOfBrokers; ++i2) {
            brokerData.get(i2).setBalanceCharge(-result.doubleValue(i2, 0));
        }
    }
}

