/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.interfaces.CapacityControl;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.repo.TariffRepo;
import org.powertac.distributionutility.ChargeInfo;
import org.powertac.distributionutility.SettlementContext;
import org.powertac.distributionutility.SettlementProcessor;
import org.powertac.util.Predicate;

public class StaticSettlementProcessor
implements SettlementProcessor {
    static Logger log = Logger.getLogger((String)StaticSettlementProcessor.class.getName());
    TariffRepo tariffRepo;
    CapacityControl capacityControlService;
    double epsilon = 1.0E-6;

    @Override
    public void settle(SettlementContext service, List<ChargeInfo> brokerData) {
        this.tariffRepo = service.getTariffRepo();
        this.capacityControlService = service.getCapacityControlService();
        double totalImbalance = 0.0;
        for (ChargeInfo info : brokerData) {
            totalImbalance += info.getNetLoadKWh();
        }
        log.debug((Object)("totalImbalance=" + totalImbalance));
        SortedSet<BOWrapper> candidates = this.filterAndSort(brokerData, totalImbalance);
        BOWrapper dummy = new BOWrapper(-totalImbalance, totalImbalance < 0.0 ? service.getPPlus() : service.getPMinus());
        candidates.add(dummy);
        for (BOWrapper bo : candidates) {
            double avail;
            if (bo == dummy) continue;
            bo.availableCapacity = avail = this.capacityControlService.getCurtailableUsage(bo.balancingOrder);
        }
        this.determineExerciseSet(totalImbalance, candidates);
        BOWrapper lastExercised = candidates.first();
        for (BOWrapper bow : candidates) {
            if (0.0 == bow.exercisedCapacity) break;
            lastExercised = bow;
            if (!(Math.abs(bow.availableCapacity - bow.exercisedCapacity) > 0.0)) continue;
            break;
        }
        if (null == lastExercised) {
            log.warn((Object)"unable to settle: lastExercised is null");
            return;
        }
        SortedSet<BOWrapper> nonExercised = candidates.tailSet(lastExercised);
        this.computeVcgPayments(brokerData, totalImbalance, candidates, nonExercised);
        double pPlus = service.getPPlus();
        double pMinus = service.getPMinus();
        for (ChargeInfo info : brokerData) {
            double charge = 0.0;
            double net = info.getNetLoadKWh();
            charge = net < 0.0 ? pPlus * net : pMinus * net;
            log.info((Object)("Broker " + info.getBrokerName() + " balance charge = " + charge));
            info.setBalanceCharge(charge + info.getBalanceCharge());
        }
    }

    private SortedSet<BOWrapper> filterAndSort(List<ChargeInfo> brokerData, double totalImbalance) {
        TreeSet<BOWrapper> orders = new TreeSet<BOWrapper>(new Comparator<BOWrapper>(){

            @Override
            public int compare(BOWrapper b0, BOWrapper b1) {
                if (b0 == b1) {
                    return 0;
                }
                if (b0.price < b1.price) {
                    return -1;
                }
                return 1;
            }
        });
        Object tester = totalImbalance < 0.0 ? new Predicate<BalancingOrder>(){

            public boolean apply(BalancingOrder bo) {
                Tariff tariff = StaticSettlementProcessor.this.tariffRepo.findTariffById(bo.getTariffId());
                return tariff.getPowerType().isConsumption();
            }
        } : new Predicate<BalancingOrder>(){

            public boolean apply(BalancingOrder bo) {
                Tariff tariff = StaticSettlementProcessor.this.tariffRepo.findTariffById(bo.getTariffId());
                return tariff.getPowerType().isProduction();
            }
        };
        for (ChargeInfo info : brokerData) {
            List<BalancingOrder> balancingOrders = info.getBalancingOrders();
            if (null == balancingOrders || balancingOrders.size() <= 0) continue;
            for (BalancingOrder bo : info.getBalancingOrders()) {
                if (!tester.apply((Object)bo)) continue;
                BOWrapper bow = new BOWrapper(info, bo);
                orders.add(bow);
            }
        }
        return orders;
    }

    private void determineExerciseSet(double totalImbalance, SortedSet<BOWrapper> candidates) {
        double remainingImbalance = totalImbalance;
        double sgn = Math.signum(totalImbalance);
        for (BOWrapper bo : candidates) {
            if (sgn * remainingImbalance <= 0.0) break;
            double exercise = Math.min(sgn * remainingImbalance, -sgn * bo.availableCapacity);
            bo.exercisedCapacity = -sgn * exercise;
            log.debug((Object)("exercising order " + bo.toString() + " for " + bo.exercisedCapacity));
            remainingImbalance -= sgn * exercise;
        }
    }

    private void computeVcgPayments(List<ChargeInfo> brokerData, double totalImbalance, SortedSet<BOWrapper> candidates, SortedSet<BOWrapper> nonExercised) {
        double sgn = Math.signum(totalImbalance);
        for (ChargeInfo info : brokerData) {
            ArrayList<BOWrapper> exercised = new ArrayList<BOWrapper>();
            double exercisedQty = 0.0;
            for (BOWrapper bow : candidates) {
                if (0.0 == bow.exercisedCapacity) break;
                if (bow.info != info) continue;
                exercised.add(bow);
                exercisedQty += bow.exercisedCapacity;
            }
            if (exercised.size() <= 0) continue;
            double marginalCost = 0.0;
            double remainingQty = exercisedQty;
            Iterator nonExercisedOrders = nonExercised.iterator();
            Iterator exercisedOrders = exercised.iterator();
            BOWrapper nextNonExercised = (BOWrapper)nonExercisedOrders.next();
            while (nextNonExercised.info == info) {
                nextNonExercised = (BOWrapper)nonExercisedOrders.next();
            }
            double avail = nextNonExercised.availableCapacity - nextNonExercised.exercisedCapacity;
            BOWrapper nextExercised = (BOWrapper)exercisedOrders.next();
            double exerciseValue = 0.0;
            double exercisedRemainingQty = nextExercised.exercisedCapacity;
            while (Math.abs(remainingQty) > this.epsilon) {
                double used = sgn * Math.max(sgn * avail, sgn * exercisedRemainingQty);
                exerciseValue += used * nextNonExercised.price;
                marginalCost += used * nextNonExercised.price;
                remainingQty -= used;
                exercisedRemainingQty -= used;
                if (Math.abs(remainingQty) <= this.epsilon) {
                    this.capacityControlService.exerciseBalancingControl(nextExercised.balancingOrder, nextExercised.exercisedCapacity, exerciseValue);
                    continue;
                }
                if (Math.abs(used - avail) <= this.epsilon) {
                    nextNonExercised = (BOWrapper)nonExercisedOrders.next();
                    while (nextNonExercised.info == info) {
                        nextNonExercised = (BOWrapper)nonExercisedOrders.next();
                    }
                    avail = nextNonExercised.availableCapacity - nextNonExercised.exercisedCapacity;
                    continue;
                }
                if (exercisedOrders.hasNext()) {
                    this.capacityControlService.exerciseBalancingControl(nextExercised.balancingOrder, nextExercised.exercisedCapacity, exerciseValue);
                    nextExercised = (BOWrapper)exercisedOrders.next();
                    exercisedRemainingQty = nextExercised.exercisedCapacity;
                    exerciseValue = 0.0;
                    continue;
                }
                if (!(Math.abs(remainingQty) > 0.0)) continue;
                log.warn((Object)("Out of orders to process for broker " + info.getBrokerName() + " with qty " + remainingQty + " remaining"));
            }
            log.info((Object)("VCG payment for " + info.getBrokerName() + ": " + marginalCost));
            info.setBalanceCharge(marginalCost);
        }
    }

    class BOWrapper {
        ChargeInfo info = null;
        BalancingOrder balancingOrder = null;
        double availableCapacity = 0.0;
        double exercisedCapacity = 0.0;
        double price = 0.0;

        BOWrapper(ChargeInfo info, BalancingOrder bo) {
            this.info = info;
            this.balancingOrder = bo;
            this.price = bo.getPrice();
        }

        BOWrapper(double availableCapacity, double price) {
            this.availableCapacity = availableCapacity;
            this.price = price;
        }

        public String toString() {
            if (null == this.balancingOrder) {
                return "Dummy";
            }
            return this.balancingOrder.getBroker().getUsername() + ":" + this.balancingOrder.getTariffId();
        }
    }
}

