/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.Orderbook;
import org.powertac.common.RandomSeed;
import org.powertac.common.Timeslot;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.CapacityControl;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.OrderbookRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.distributionutility.ChargeInfo;
import org.powertac.distributionutility.DynamicSettlementProcessor;
import org.powertac.distributionutility.SettlementContext;
import org.powertac.distributionutility.SettlementProcessor;
import org.powertac.distributionutility.SimpleSettlementProcessor;
import org.powertac.distributionutility.StaticSettlementProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionUtilityService
extends TimeslotPhaseProcessor
implements SettlementContext,
InitializationService {
    Logger log = Logger.getLogger((String)this.getClass().getName());
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private OrderbookRepo orderbookRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private Accounting accountingService;
    @Autowired
    private CapacityControl capacityControlService;
    @Autowired
    private ServerConfiguration serverProps;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private RandomSeed randomGen;
    @ConfigurableValue(valueType="Double", description="Low end of distribution fee range")
    private double distributionFeeMin = -0.005;
    @ConfigurableValue(valueType="Double", description="High end of distribution fee range")
    private double distributionFeeMax = -0.15;
    @ConfigurableValue(valueType="Double", publish=true, description="Distribution fee: overrides random value selection")
    private Double distributionFee = null;
    @ConfigurableValue(valueType="Double", description="Low end of balancing cost range for simple settlement processor")
    private double balancingCostMin = -0.01;
    @ConfigurableValue(valueType="Double", description="High end of balancing cost range for simple settlement processor")
    private double balancingCostMax = -0.02;
    @ConfigurableValue(valueType="Double", publish=true, description="Balancing cost for simple settlement processor: overrides random value selection")
    private Double balancingCost = null;
    @ConfigurableValue(valueType="Double", publish=true, description="Slope of up-regulation cost /kwh")
    private double pPlusPrime = 0.0;
    @ConfigurableValue(valueType="Double", publish=true, description="Slope of down-regulation cost /kwh")
    private double pMinusPrime = 0.0;
    @ConfigurableValue(valueType="Double", publish=true, description="Spot price/mwh used if unavailable from wholesale market")
    private double defaultSpotPrice = 30.0;
    @ConfigurableValue(valueType="String", publish=true, description="Balancing settlement processing: blank for no controllable capacity, \"static\" for per-timeslot processing of balancing orders")
    private String settlementProcess = "";
    private Map<String, Class<?>> settlementMap = new HashMap<String, Class<?>>(){
        {
            this.put("simple", SimpleSettlementProcessor.class);
            this.put("static", StaticSettlementProcessor.class);
            this.put("dynamic", DynamicSettlementProcessor.class);
        }
    };

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        super.init();
        this.distributionFee = null;
        this.balancingCost = null;
        this.serverProps.configureMe((Object)this);
        this.randomGen = this.randomSeedService.getRandomSeed("DistributionUtilityService", 0L, "model");
        if (null == this.distributionFee) {
            this.distributionFee = this.distributionFeeMin + this.randomGen.nextDouble() * (this.distributionFeeMax - this.distributionFeeMin);
        }
        if (null == this.balancingCost) {
            this.balancingCost = this.balancingCostMin + this.randomGen.nextDouble() * (this.balancingCostMax - this.balancingCostMin);
        }
        this.log.info((Object)("Configured DU: distro fee = " + this.distributionFee + ", balancing cost = " + this.balancingCost));
        this.serverProps.publishConfiguration((Object)this);
        return "DistributionUtility";
    }

    public void activate(Instant time, int phaseNumber) {
        this.log.info((Object)"Activate");
        List brokerList = this.brokerRepo.findRetailBrokers();
        if (brokerList == null) {
            this.log.error((Object)"Failed to retrieve retail broker list");
            return;
        }
        this.balanceTimeslot(this.timeslotRepo.currentTimeslot(), brokerList);
        for (Broker broker : brokerList) {
            double netLoad = -this.accountingService.getCurrentNetLoad(broker);
            this.accountingService.addDistributionTransaction(broker, netLoad, netLoad * this.distributionFee);
        }
    }

    public List<ChargeInfo> balanceTimeslot(Timeslot currentTimeslot, List<Broker> brokerList) {
        HashMap<Broker, ChargeInfo> chargeInfoMap = new HashMap<Broker, ChargeInfo>();
        for (Broker broker : brokerList) {
            ChargeInfo info = new ChargeInfo(broker, this.getMarketBalance(broker));
            chargeInfoMap.put(broker, info);
        }
        Collection boc = this.tariffRepo.getBalancingOrders();
        for (BalancingOrder order : boc) {
            ChargeInfo info = (ChargeInfo)chargeInfoMap.get(order.getBroker());
            info.addBalancingOrder(order);
        }
        this.log.info((Object)("balancing prices: pPlus=" + this.getPPlus() + ", pMinus=" + this.getPMinus()));
        ArrayList<ChargeInfo> brokerData = new ArrayList<ChargeInfo>(chargeInfoMap.values());
        this.getSettlementProcessor().settle(this, brokerData);
        for (ChargeInfo info : brokerData) {
            double balanceCharge = info.getBalanceCharge();
            if (balanceCharge == 0.0) continue;
            this.accountingService.addBalancingTransaction(info.getBroker(), info.getNetLoadKWh(), balanceCharge);
        }
        return brokerData;
    }

    public double getMarketBalance(Broker broker) {
        double result = this.accountingService.getCurrentMarketPosition(broker) * 1000.0 + this.accountingService.getCurrentNetLoad(broker);
        this.log.info((Object)("market balance for " + broker.getUsername() + ": " + result));
        return result;
    }

    double getSpotPrice() {
        Double result = this.defaultSpotPrice;
        Orderbook ob = this.orderbookRepo.findSpotByTimeslot(this.timeslotRepo.currentTimeslot());
        if (ob != null) {
            result = ob.getClearingPrice();
        } else {
            this.log.info((Object)"null Orderbook");
        }
        return result / 1000.0;
    }

    @Override
    public double getPPlus() {
        double result = this.defaultSpotPrice;
        List obs = this.orderbookRepo.findAllByTimeslot(this.timeslotRepo.currentTimeslot());
        if (obs != null && obs.size() > 0) {
            Double max = null;
            for (Orderbook ob : obs) {
                Double price = ob.getClearingPrice();
                if (price == null || max != null && !(price > max)) continue;
                max = price;
            }
            result = max;
        }
        return result / 1000.0;
    }

    @Override
    public double getPMinus() {
        double result = this.defaultSpotPrice;
        List obs = this.orderbookRepo.findAllByTimeslot(this.timeslotRepo.currentTimeslot());
        if (obs != null && obs.size() > 0) {
            Double min = null;
            for (Orderbook ob : obs) {
                Double price = ob.getClearingPrice();
                if (price == null || min != null && !(price < min)) continue;
                min = price;
            }
            result = min;
        }
        return result / 1000.0;
    }

    @Override
    public double getPPlusPrime() {
        return this.pPlusPrime;
    }

    @Override
    public double getPMinusPrime() {
        return this.pMinusPrime;
    }

    double getDistributionFeeMin() {
        return this.distributionFeeMin;
    }

    double getDistributionFeeMax() {
        return this.distributionFeeMax;
    }

    Double getDistributionFee() {
        return this.distributionFee;
    }

    double getBalancingCostMin() {
        return this.balancingCostMin;
    }

    double getBalancingCostMax() {
        return this.balancingCostMax;
    }

    @Override
    public Double getBalancingCost() {
        return this.balancingCost;
    }

    double getDefaultSpotPrice() {
        return this.defaultSpotPrice;
    }

    private SettlementProcessor getSettlementProcessor() {
        Class<?> processor;
        if (this.settlementProcess.equals("")) {
            this.settlementProcess = "simple";
        }
        if (null == (processor = this.settlementMap.get(this.settlementProcess))) {
            this.log.error((Object)("Null settlement processor for " + this.settlementProcess));
            processor = this.settlementMap.get("simple");
        }
        SettlementProcessor result = null;
        try {
            Constructor<?> constructor = processor.getDeclaredConstructor(TariffRepo.class, CapacityControl.class);
            result = (SettlementProcessor)constructor.newInstance(this.tariffRepo, this.capacityControlService);
        }
        catch (Exception e) {
            this.log.error((Object)("cannot create settlement processor: " + e.toString()));
        }
        return result;
    }
}

