/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.powertac.common.Tariff;
import org.powertac.common.interfaces.CapacityControl;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.repo.TariffRepo;
import org.powertac.distributionutility.ChargeInfo;
import org.powertac.distributionutility.SettlementContext;
import org.powertac.distributionutility.SettlementProcessor;
import org.powertac.util.Predicate;

public class StaticSettlementProcessor
extends SettlementProcessor {
    private double epsilon = 1.0E-6;
    double pPlus;
    double pMinus;
    double pPlusPrime;
    double pMinusPrime;

    StaticSettlementProcessor(TariffRepo tariffRepo, CapacityControl capacityControl) {
        super(tariffRepo, capacityControl);
    }

    @Override
    public void settle(SettlementContext service, List<ChargeInfo> brokerData) {
        this.pPlus = service.getPPlus();
        this.pPlusPrime = service.getPPlusPrime();
        this.pMinus = service.getPMinus();
        this.pMinusPrime = service.getPMinusPrime();
        double totalImbalance = 0.0;
        double totalQty = 0.0;
        for (ChargeInfo info : brokerData) {
            totalImbalance += info.getNetLoadKWh();
            totalQty += Math.abs(info.getNetLoadKWh());
        }
        log.debug((Object)("totalImbalance=" + totalImbalance));
        if (Math.abs(totalImbalance) < this.epsilon) {
            if (totalQty < this.epsilon) {
                return;
            }
            totalImbalance = this.epsilon * totalQty;
        }
        SortedSet<BOWrapper> candidates = this.filterAndSort(brokerData, totalImbalance);
        for (BOWrapper bo : candidates) {
            bo.availableCapacity = this.capacityControlService.getCurtailableUsage(bo.balancingOrder);
        }
        this.insertDummyOrders(candidates, totalImbalance);
        double satisfied = this.determineExerciseSet(totalImbalance, candidates);
        BOWrapper lastExercised = candidates.first();
        for (BOWrapper bow : candidates) {
            if (0.0 == bow.exercisedCapacity) break;
            lastExercised = bow;
            if (!(Math.abs(bow.availableCapacity - bow.exercisedCapacity) > 0.0)) continue;
            break;
        }
        if (null == lastExercised) {
            log.warn((Object)"unable to settle: lastExercised is null");
            return;
        }
        this.computeVcgCharges(brokerData, totalImbalance, candidates);
        this.computeImbalanceCharges(brokerData, totalImbalance, candidates);
    }

    private SortedSet<BOWrapper> filterAndSort(List<ChargeInfo> brokerData, double totalImbalance) {
        TreeSet<BOWrapper> orders = new TreeSet<BOWrapper>(new Comparator<BOWrapper>(){

            @Override
            public int compare(BOWrapper b0, BOWrapper b1) {
                if (b0 == b1) {
                    return 0;
                }
                if (b0.price < b1.price) {
                    return -1;
                }
                return 1;
            }
        });
        Object tester = totalImbalance < 0.0 ? new Predicate<BalancingOrder>(){

            public boolean apply(BalancingOrder bo) {
                Tariff tariff = StaticSettlementProcessor.this.tariffRepo.findTariffById(bo.getTariffId());
                return tariff.getPowerType().isConsumption();
            }
        } : new Predicate<BalancingOrder>(){

            public boolean apply(BalancingOrder bo) {
                Tariff tariff = StaticSettlementProcessor.this.tariffRepo.findTariffById(bo.getTariffId());
                return tariff.getPowerType().isProduction();
            }
        };
        for (ChargeInfo info : brokerData) {
            List<BalancingOrder> balancingOrders = info.getBalancingOrders();
            if (null == balancingOrders || balancingOrders.size() <= 0) continue;
            for (BalancingOrder bo : info.getBalancingOrders()) {
                if (!tester.apply((Object)bo)) continue;
                BOWrapper bow = new BOWrapper(info, bo);
                orders.add(bow);
            }
        }
        return orders;
    }

    private void insertDummyOrders(SortedSet<BOWrapper> orders, double totalImbalance) {
        double price = this.pPlus;
        double slope = this.pPlusPrime;
        if (totalImbalance >= 0.0) {
            price = this.pMinus;
            slope = this.pMinusPrime;
        }
        BOWrapper dummy = new BOWrapper(-totalImbalance, price, slope);
        orders.add(dummy);
        if (dummy.slope != 0.0) {
            this.splitDummyOrder(orders, orders.tailSet(dummy));
        }
    }

    private void splitDummyOrder(SortedSet<BOWrapper> orders, SortedSet<BOWrapper> tail) {
        if (tail.size() <= 1) {
            return;
        }
        Iterator bos = tail.iterator();
        BOWrapper dummy = (BOWrapper)bos.next();
        BOWrapper nextBO = (BOWrapper)bos.next();
        double capacity = (nextBO.price - dummy.price) / dummy.slope;
        if (Math.signum(capacity) != Math.signum(dummy.availableCapacity)) {
            log.error((Object)("Sign of needed capacity " + capacity + " != sign of dummy avail capacity " + dummy.availableCapacity));
        } else {
            if (Math.abs(capacity) >= Math.abs(dummy.availableCapacity)) {
                return;
            }
            BOWrapper newDummy = new BOWrapper(dummy.availableCapacity - capacity, nextBO.price + this.epsilon, dummy.slope);
            dummy.availableCapacity = capacity;
            orders.add(newDummy);
            this.splitDummyOrder(orders, orders.tailSet(newDummy));
        }
    }

    private double determineExerciseSet(double totalImbalance, SortedSet<BOWrapper> candidates) {
        double remainingImbalance = totalImbalance;
        double sgn = Math.signum(totalImbalance);
        for (BOWrapper bo : candidates) {
            if (sgn * remainingImbalance <= 0.0) break;
            double exercise = Math.min(sgn * remainingImbalance, -sgn * bo.availableCapacity);
            bo.exercisedCapacity = -sgn * exercise;
            log.debug((Object)("exercising order " + bo.toString() + " for " + bo.exercisedCapacity));
            remainingImbalance -= sgn * exercise;
        }
        return totalImbalance - remainingImbalance;
    }

    private void computeVcgCharges(List<ChargeInfo> brokerData, double totalImbalance, SortedSet<BOWrapper> candidates) {
        HashSet<ChargeInfo> nonParticipants = new HashSet<ChargeInfo>();
        for (ChargeInfo info : brokerData) {
            nonParticipants.add(info);
            double newMC = this.computeMarginalPrice(totalImbalance, candidates, nonParticipants);
            nonParticipants.remove(info);
            info.setBalanceChargeP2(this.exerciseControls(info, candidates, newMC));
        }
    }

    private void computeImbalanceCharges(List<ChargeInfo> brokerData, double totalImbalance, SortedSet<BOWrapper> candidates) {
        HashSet<ChargeInfo> contributors = new HashSet<ChargeInfo>();
        HashSet<ChargeInfo> nonContributors = new HashSet<ChargeInfo>();
        double sgn = Math.signum(totalImbalance);
        for (ChargeInfo info : brokerData) {
            if (sgn != Math.signum(info.getNetLoadKWh())) {
                nonContributors.add(info);
                continue;
            }
            contributors.add(info);
        }
        double rpQty = 0.0;
        for (BOWrapper bid : candidates) {
            if (!bid.isDummy()) continue;
            rpQty += bid.exercisedCapacity;
        }
        for (ChargeInfo info : contributors) {
            nonContributors.add(info);
            double originalMC = this.computeMarginalPrice(totalImbalance, candidates, nonContributors);
            double p1 = originalMC * (-rpQty - this.getExercisedCapacity(info, candidates));
            for (ChargeInfo other : contributors) {
                if (other == info) continue;
                nonContributors.add(other);
                double newMC = this.computeMarginalPrice(totalImbalance, candidates, nonContributors);
                nonContributors.remove(other);
                p1 -= newMC * this.getExercisedCapacity(other, candidates);
            }
            nonContributors.remove(info);
            info.setBalanceChargeP1(p1 * info.getNetLoadKWh() / totalImbalance);
        }
        HashSet<ChargeInfo> excludes = new HashSet<ChargeInfo>();
        for (ChargeInfo info : nonContributors) {
            excludes.add(info);
            double originalMC = this.computeMarginalPrice(totalImbalance, candidates, excludes);
            double p1 = originalMC * (-rpQty - this.getExercisedCapacity(info, candidates));
            for (ChargeInfo other : brokerData) {
                if (other == info) continue;
                excludes.add(other);
                double newMC = this.computeMarginalPrice(totalImbalance, candidates, nonContributors);
                excludes.remove(other);
                p1 -= newMC * this.getExercisedCapacity(other, candidates);
            }
            excludes.remove(info);
            info.setBalanceChargeP1(p1 * info.getNetLoadKWh() / totalImbalance);
        }
    }

    private double computeMarginalPrice(double imbalance, SortedSet<BOWrapper> candidates, Set<ChargeInfo> exclude) {
        double result = 0.0;
        double sgn = Math.signum(imbalance);
        double remaining = -imbalance;
        for (BOWrapper bow : candidates) {
            if (null != exclude && exclude.contains(bow.info)) continue;
            if (sgn * bow.getCapacity() < sgn * remaining + this.epsilon) {
                result = bow.getMarginalPrice(remaining);
                break;
            }
            remaining -= bow.getCapacity();
        }
        return result;
    }

    private double exerciseControls(ChargeInfo broker, SortedSet<BOWrapper> candidates, double marginalPrice) {
        double result = 0.0;
        for (BOWrapper candidate : candidates) {
            if (candidate.info != broker || 0.0 == candidate.exercisedCapacity) continue;
            this.capacityControlService.exerciseBalancingControl(candidate.balancingOrder, candidate.exercisedCapacity, candidate.exercisedCapacity * marginalPrice);
            result += candidate.exercisedCapacity * marginalPrice;
        }
        return result;
    }

    private double getExercisedCapacity(ChargeInfo broker, SortedSet<BOWrapper> candidates) {
        double result = 0.0;
        for (BOWrapper candidate : candidates) {
            if (candidate.info != broker) continue;
            result += candidate.exercisedCapacity;
        }
        return result;
    }

    class BOWrapper {
        ChargeInfo info = null;
        BalancingOrder balancingOrder = null;
        double availableCapacity = 0.0;
        double exercisedCapacity = 0.0;
        double price = 0.0;
        double slope = 0.0;

        BOWrapper(ChargeInfo info, BalancingOrder bo) {
            this.info = info;
            this.balancingOrder = bo;
            this.price = bo.getPrice();
        }

        BOWrapper(double availableCapacity, double price) {
            this.availableCapacity = availableCapacity;
            this.price = price;
        }

        BOWrapper(double availableCapacity, double price, double slope) {
            this.availableCapacity = availableCapacity;
            this.price = price;
            this.slope = slope;
        }

        boolean isDummy() {
            return null == this.balancingOrder;
        }

        double getCapacity() {
            return this.availableCapacity;
        }

        double getMarginalPrice(double qty) {
            return this.price + this.slope * qty;
        }

        public String toString() {
            if (null == this.balancingOrder) {
                return "Dummy";
            }
            return this.balancingOrder.getBroker().getUsername() + ":" + this.balancingOrder.getTariffId();
        }
    }
}

