/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.powertac.common.Tariff;
import org.powertac.common.interfaces.CapacityControl;
import org.powertac.common.msg.BalancingOrder;
import org.powertac.common.repo.TariffRepo;
import org.powertac.distributionutility.ChargeInfo;
import org.powertac.distributionutility.SettlementContext;
import org.powertac.distributionutility.SettlementProcessor;
import org.powertac.util.Predicate;

public class StaticSettlementProcessor
extends SettlementProcessor {
    private double epsilon = 1.0E-6;
    double pPlus;
    double pMinus;
    double pPlusPrime;
    double pMinusPrime;

    StaticSettlementProcessor(TariffRepo tariffRepo, CapacityControl capacityControl) {
        super(tariffRepo, capacityControl);
    }

    @Override
    public void settle(SettlementContext service, List<ChargeInfo> brokerData) {
        this.pPlus = service.getPPlus();
        this.pPlusPrime = service.getPPlusPrime();
        this.pMinus = service.getPMinus();
        this.pMinusPrime = service.getPMinusPrime();
        double totalImbalance = 0.0;
        double totalQty = 0.0;
        for (ChargeInfo info : brokerData) {
            totalImbalance += info.getNetLoadKWh();
            totalQty += Math.abs(info.getNetLoadKWh());
        }
        log.info((Object)("totalImbalance=" + totalImbalance));
        if (Math.abs(totalImbalance) < this.epsilon) {
            if (totalQty < this.epsilon) {
                return;
            }
            totalImbalance = this.epsilon / 2.0;
        }
        SortedSet<BOWrapper> candidates = this.findCandidateOrders(brokerData, totalImbalance);
        for (BOWrapper bo : candidates) {
            bo.availableCapacity = this.capacityControlService.getCurtailableUsage(bo.balancingOrder);
        }
        this.insertDummyOrders(candidates, totalImbalance * 2.0);
        double satisfied = this.determineExerciseSet(totalImbalance, candidates);
        SortedSet<BOWrapper> nonExercised = this.determineNonExercisedSet(candidates);
        HashSet<ChargeInfo> nonParticipants = new HashSet<ChargeInfo>();
        for (ChargeInfo info : brokerData) {
            info.setBalanceChargeP2(this.computeVcgCharges(info, totalImbalance, candidates, nonExercised, nonParticipants));
        }
        this.computeImbalanceCharges(brokerData, totalImbalance, candidates);
        for (ChargeInfo info : brokerData) {
            this.exerciseControls(info, candidates, info.getBalanceChargeP2());
        }
        if (log.isInfoEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("DU static settlement <broker(p2,p1)>:");
            for (ChargeInfo info : brokerData) {
                sb.append(" ").append(info.getBrokerName()).append("(");
                sb.append(info.getBalanceChargeP2()).append(",");
                sb.append(info.getBalanceChargeP1()).append(")");
            }
            log.info((Object)sb.toString());
            double rmQty = 0.0;
            double rmCost = 0.0;
            for (BOWrapper bo : candidates) {
                if (!bo.isDummy()) continue;
                rmQty += bo.exercisedCapacity;
                rmCost = bo.exercisedCapacity * bo.getMarginalPrice(bo.exercisedCapacity);
            }
            double brokerCost = 0.0;
            for (ChargeInfo info : brokerData) {
                brokerCost += info.getBalanceChargeP1() + info.getBalanceChargeP2();
            }
            log.info((Object)("DU budget: rm cost = " + rmCost + ", broker cost = " + brokerCost));
        }
    }

    private SortedSet<BOWrapper> findCandidateOrders(List<ChargeInfo> brokerData, double totalImbalance) {
        TreeSet<BOWrapper> orders = new TreeSet<BOWrapper>(new BOComparator());
        Object tester = totalImbalance < 0.0 ? new Predicate<BalancingOrder>(){

            public boolean apply(BalancingOrder bo) {
                Tariff tariff = StaticSettlementProcessor.this.tariffRepo.findTariffById(bo.getTariffId());
                return tariff.getPowerType().isConsumption();
            }
        } : new Predicate<BalancingOrder>(){

            public boolean apply(BalancingOrder bo) {
                Tariff tariff = StaticSettlementProcessor.this.tariffRepo.findTariffById(bo.getTariffId());
                return tariff.getPowerType().isProduction();
            }
        };
        for (ChargeInfo info : brokerData) {
            List<BalancingOrder> balancingOrders = info.getBalancingOrders();
            if (null == balancingOrders || balancingOrders.size() <= 0) continue;
            for (BalancingOrder bo : info.getBalancingOrders()) {
                if (!tester.apply((Object)bo)) continue;
                BOWrapper bow = new BOWrapper(info, bo);
                orders.add(bow);
            }
        }
        return orders;
    }

    private void insertDummyOrders(SortedSet<BOWrapper> orders, double totalImbalance) {
        double price = this.pPlus;
        double slope = this.pPlusPrime;
        if (totalImbalance >= 0.0) {
            price = this.pMinus;
            slope = this.pMinusPrime;
        }
        BOWrapper dummy = new BOWrapper(-totalImbalance, price, slope, 0.0);
        orders.add(dummy);
        if (dummy.slope != 0.0) {
            this.splitDummyOrder(orders, orders.tailSet(dummy));
        }
    }

    private void splitDummyOrder(SortedSet<BOWrapper> orders, SortedSet<BOWrapper> tail) {
        if (tail.size() <= 1) {
            return;
        }
        Iterator bos = tail.iterator();
        BOWrapper dummy = (BOWrapper)bos.next();
        BOWrapper nextBO = (BOWrapper)bos.next();
        double capacity = (nextBO.price - dummy.price) / dummy.slope;
        if (Math.signum(capacity) != Math.signum(dummy.availableCapacity)) {
            log.error((Object)("Sign of needed capacity " + capacity + " != sign of dummy avail capacity " + dummy.availableCapacity));
        } else {
            if (Math.abs(capacity) >= Math.abs(dummy.availableCapacity)) {
                return;
            }
            BOWrapper newDummy = new BOWrapper(dummy.availableCapacity - capacity, nextBO.price + this.epsilon / 1000.0, dummy.slope, capacity + dummy.startX);
            dummy.availableCapacity = capacity;
            orders.add(newDummy);
            this.splitDummyOrder(orders, orders.tailSet(newDummy));
        }
    }

    private double determineExerciseSet(double totalImbalance, SortedSet<BOWrapper> candidates) {
        double remainingImbalance = totalImbalance;
        double sgn = Math.signum(totalImbalance);
        for (BOWrapper bo : candidates) {
            if (sgn * remainingImbalance <= 0.0) break;
            double exercise = Math.min(sgn * remainingImbalance, -sgn * bo.availableCapacity);
            bo.exercisedCapacity = -sgn * exercise;
            log.debug((Object)("exercising order " + bo.toString() + " for " + bo.exercisedCapacity + " at " + bo.price));
            remainingImbalance -= sgn * exercise;
        }
        return totalImbalance - remainingImbalance;
    }

    SortedSet<BOWrapper> determineNonExercisedSet(SortedSet<BOWrapper> candidates) {
        BOWrapper lastExercised = candidates.first();
        for (BOWrapper bow : candidates) {
            if (0.0 == bow.exercisedCapacity) break;
            lastExercised = bow;
            if (!(Math.abs(bow.availableCapacity - bow.exercisedCapacity) > 0.0)) continue;
            break;
        }
        if (null == lastExercised) {
            log.warn((Object)"unable to settle: lastExercised is null");
            return null;
        }
        return candidates.tailSet(lastExercised);
    }

    private double computeVcgCharges(ChargeInfo target, double totalImbalance, SortedSet<BOWrapper> candidates, SortedSet<BOWrapper> nonExercised, Set<ChargeInfo> nonParticipants) {
        double remainingQty = 0.0;
        double sgn = Math.signum(totalImbalance);
        for (BOWrapper bow : candidates) {
            if (0.0 == bow.exercisedCapacity) break;
            if (target == bow.info) {
                remainingQty += bow.exercisedCapacity;
            }
            if (!(Math.abs(bow.availableCapacity - bow.exercisedCapacity) > 0.0)) continue;
            break;
        }
        double price = 0.0;
        nonParticipants.add(target);
        double rmQty = 0.0;
        double rmMarginalPrice = 0.0;
        for (BOWrapper nextNonExercised : nonExercised) {
            if (Math.abs(remainingQty) < this.epsilon) break;
            if (nonParticipants.contains(nextNonExercised.info)) continue;
            double avail = nextNonExercised.availableCapacity - nextNonExercised.exercisedCapacity;
            double used = sgn * Math.max(sgn * avail, sgn * remainingQty);
            price += sgn * nextNonExercised.getTotalNEPrice(used);
            remainingQty -= used;
            log.debug((Object)("  VCG cost part of " + nextNonExercised.getTotalNEPrice(used) + " for " + used + " kWh at " + nextNonExercised.price));
        }
        price -= rmQty * rmMarginalPrice;
        nonParticipants.remove(target);
        if (Math.abs(remainingQty) > this.epsilon) {
            log.error((Object)"Not enough orders to compute VCG price.");
        }
        log.debug((Object)("VCG price is " + price));
        return -price;
    }

    private void computeImbalanceCharges(List<ChargeInfo> brokerData, double totalImbalance, SortedSet<BOWrapper> candidates) {
        HashSet<ChargeInfo> contributors = new HashSet<ChargeInfo>();
        HashSet<ChargeInfo> nonContributors = new HashSet<ChargeInfo>();
        double sgn = Math.signum(totalImbalance);
        if (Math.abs(totalImbalance) < this.epsilon) {
            double penaltyPlus = this.pPlus;
            double penaltyMinus = this.pMinus;
            for (ChargeInfo info : brokerData) {
                double sign = Math.signum(info.getNetLoadKWh());
                if (sign < 0.0) {
                    info.setBalanceChargeP1(penaltyPlus * info.getNetLoadKWh());
                    continue;
                }
                info.setBalanceChargeP1(penaltyMinus * info.getNetLoadKWh());
            }
            return;
        }
        for (ChargeInfo info : brokerData) {
            if (info.getNetLoadKWh() != 0.0 && sgn != Math.signum(info.getNetLoadKWh())) {
                nonContributors.add(info);
                continue;
            }
            contributors.add(info);
        }
        for (ChargeInfo broker : contributors) {
            double rpCost;
            nonContributors.add(broker);
            SortedSet<BOWrapper> remains = this.filterOrders(candidates, nonContributors);
            double satisfied = this.determineExerciseSet(totalImbalance, remains);
            SortedSet<BOWrapper> nonExercised = this.determineNonExercisedSet(remains);
            double imbalanceCost = rpCost = this.findRpCost(remains);
            for (ChargeInfo target : contributors) {
                if (target == broker) continue;
                imbalanceCost -= this.computeVcgCharges(target, totalImbalance, remains, nonExercised, nonContributors);
            }
            nonContributors.remove(broker);
            broker.setBalanceChargeP1(imbalanceCost * broker.getNetLoadKWh() / totalImbalance);
        }
        HashSet<ChargeInfo> excludes = new HashSet<ChargeInfo>();
        for (ChargeInfo info : nonContributors) {
            excludes.add(info);
            SortedSet<BOWrapper> remains = this.filterOrders(candidates, excludes);
            double satisfied = this.determineExerciseSet(totalImbalance, remains);
            SortedSet<BOWrapper> nonExercised = this.determineNonExercisedSet(remains);
            double imbalanceCost = this.findRpCost(remains);
            for (ChargeInfo target : brokerData) {
                if (target == info) continue;
                excludes.add(target);
                imbalanceCost -= this.computeVcgCharges(target, totalImbalance, remains, nonExercised, excludes);
                excludes.remove(target);
            }
            excludes.remove(info);
            info.setBalanceChargeP1(imbalanceCost * info.getNetLoadKWh() / totalImbalance);
        }
    }

    private double findRpCost(SortedSet<BOWrapper> remains) {
        double rpCost = 0.0;
        for (BOWrapper bid : remains) {
            if (!bid.isDummy()) continue;
            rpCost = -bid.getTotalEPrice();
        }
        return rpCost;
    }

    private SortedSet<BOWrapper> filterOrders(SortedSet<BOWrapper> candidates, HashSet<ChargeInfo> exclude) {
        TreeSet<BOWrapper> remains = new TreeSet<BOWrapper>(new BOComparator());
        for (BOWrapper bow : candidates) {
            if (exclude.contains(bow.info)) continue;
            remains.add(bow.duplicate());
        }
        return remains;
    }

    private void exerciseControls(ChargeInfo broker, SortedSet<BOWrapper> candidates, double settlementPrice) {
        for (BOWrapper candidate : candidates) {
            if (candidate.info != broker || 0.0 == candidate.exercisedCapacity) continue;
            this.capacityControlService.exerciseBalancingControl(candidate.balancingOrder, candidate.exercisedCapacity, settlementPrice);
            broker.addCurtailment(candidate.exercisedCapacity);
        }
    }

    class BOComparator
    implements Comparator<BOWrapper> {
        BOComparator() {
        }

        @Override
        public int compare(BOWrapper b0, BOWrapper b1) {
            if (b0 == b1) {
                return 0;
            }
            if (b0.price < b1.price) {
                return -1;
            }
            return 1;
        }
    }

    class BOWrapper
    implements Cloneable {
        ChargeInfo info;
        BalancingOrder balancingOrder;
        double availableCapacity;
        double exercisedCapacity;
        double price;
        double slope;
        double startX;

        BOWrapper(ChargeInfo info, BalancingOrder bo) {
            this.info = null;
            this.balancingOrder = null;
            this.availableCapacity = 0.0;
            this.exercisedCapacity = 0.0;
            this.price = 0.0;
            this.slope = 0.0;
            this.startX = 0.0;
            this.info = info;
            this.balancingOrder = bo;
            this.price = bo.getPrice();
        }

        BOWrapper(double availableCapacity, double price, double slope, double startX) {
            this.info = null;
            this.balancingOrder = null;
            this.availableCapacity = 0.0;
            this.exercisedCapacity = 0.0;
            this.price = 0.0;
            this.slope = 0.0;
            this.startX = 0.0;
            this.availableCapacity = availableCapacity;
            this.price = price;
            this.slope = slope;
            this.startX = startX;
        }

        BOWrapper duplicate() {
            try {
                return (BOWrapper)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        }

        boolean isDummy() {
            return null == this.balancingOrder;
        }

        double getCapacity() {
            return this.availableCapacity;
        }

        double getMarginalPrice(double qty) {
            return this.price + this.slope * qty;
        }

        double getTotalNEPrice(double qty) {
            double oldMPrice = this.getMarginalPrice(this.exercisedCapacity);
            double newMPrice = this.getMarginalPrice(this.exercisedCapacity + qty);
            return newMPrice * qty + (newMPrice - oldMPrice) * this.exercisedCapacity + this.startX * (newMPrice - this.price);
        }

        double getTotalEPrice() {
            double oldMPrice = this.getMarginalPrice(this.exercisedCapacity);
            return oldMPrice * this.exercisedCapacity + this.startX * (oldMPrice - this.price);
        }

        public String toString() {
            if (null == this.balancingOrder) {
                return "Dummy";
            }
            return this.balancingOrder.getBroker().getUsername() + ":" + this.balancingOrder.getTariffId() + ":" + this.availableCapacity + ":" + this.exercisedCapacity;
        }
    }
}

