/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.ArrayList;
import java.util.List;
import org.powertac.common.Broker;
import org.powertac.common.msg.BalancingOrder;

class ChargeInfo {
    private Broker broker = null;
    private double netLoadKWh = 0.0;
    private double curtailment = 0.0;
    private double balanceChargeP1 = 0.0;
    private double balanceChargeP2 = 0.0;
    private List<BalancingOrder> balancingOrders = null;

    ChargeInfo(Broker broker, double netLoad) {
        this.broker = broker;
        this.netLoadKWh = netLoad;
    }

    Broker getBroker() {
        return this.broker;
    }

    String getBrokerName() {
        return this.broker.getUsername();
    }

    double getNetLoadKWh() {
        return this.netLoadKWh;
    }

    double getBalanceCharge() {
        return this.balanceChargeP1 + this.balanceChargeP2;
    }

    double getBalanceChargeP1() {
        return this.balanceChargeP1;
    }

    void setBalanceChargeP1(double charge) {
        this.balanceChargeP1 = charge;
    }

    double getBalanceChargeP2() {
        return this.balanceChargeP2;
    }

    void setBalanceChargeP2(double charge) {
        this.balanceChargeP2 = charge;
    }

    List<BalancingOrder> getBalancingOrders() {
        return this.balancingOrders;
    }

    void addBalancingOrder(BalancingOrder order) {
        if (null == this.balancingOrders) {
            this.balancingOrders = new ArrayList<BalancingOrder>();
        }
        this.balancingOrders.add(order);
    }

    void addCurtailment(double kWh) {
        this.curtailment += kWh;
    }

    double getCurtailment() {
        return this.curtailment;
    }

    public String toString() {
        return "CI(" + this.broker.getUsername() + "): p1=" + this.balanceChargeP1 + ", p2=" + this.balanceChargeP2;
    }
}

