/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.RandomSeed;
import org.powertac.common.TariffTransaction;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BalancingMarket;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.OrderbookRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionUtilityService
extends TimeslotPhaseProcessor
implements InitializationService {
    Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getSimpleName());
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private OrderbookRepo orderbookRepo;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private Accounting accounting;
    @Autowired
    private BalancingMarket balancingMarket;
    @Autowired
    private ServerConfiguration serverProps;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private RandomSeed randomGen;
    @ConfigurableValue(valueType="Double", description="Low end of distribution fee range")
    private double distributionFeeMin = -0.005;
    @ConfigurableValue(valueType="Double", description="High end of distribution fee range")
    private double distributionFeeMax = -0.15;
    @ConfigurableValue(valueType="Double", publish=true, description="Distribution fee: overrides random value selection")
    private Double distributionFee = null;

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("BalancingMarket");
        if (index == -1) {
            return null;
        }
        super.init();
        this.distributionFee = null;
        this.serverProps.configureMe((Object)this);
        this.randomGen = this.randomSeedService.getRandomSeed("DistributionUtilityService", 0L, "model");
        if (null == this.distributionFee) {
            this.distributionFee = this.distributionFeeMin + this.randomGen.nextDouble() * (this.distributionFeeMax - this.distributionFeeMin);
        }
        this.log.info((Object)("Configured DU: distro fee = " + this.distributionFee));
        this.serverProps.publishConfiguration((Object)this);
        return "DistributionUtility";
    }

    public void activate(Instant time, int phaseNumber) {
        this.log.info((Object)"Activate");
        List brokerList = this.brokerRepo.findRetailBrokers();
        if (brokerList == null) {
            this.log.error((Object)"Failed to retrieve retail broker list");
            return;
        }
        Map totals = this.accounting.getCurrentSupplyDemandByBroker();
        for (Broker broker : brokerList) {
            Map brokerTotals = (Map)totals.get(broker);
            if (null == brokerTotals) continue;
            double consumption = (Double)brokerTotals.get(TariffTransaction.Type.CONSUME);
            double production = (Double)brokerTotals.get(TariffTransaction.Type.PRODUCE);
            double imports = this.accounting.getCurrentMarketPosition(broker) * 1000.0;
            double imbalance = this.balancingMarket.getMarketBalance(broker);
            double balanceAdj = this.balancingMarket.getRegulation(broker);
            this.log.info((Object)("Distribution tx for " + broker.getUsername() + "(c,p,m,i,b) = (" + consumption + "," + production + "," + imports + "," + imbalance + "," + balanceAdj + ")"));
            double transport = (production - consumption - balanceAdj + Math.abs(imports - imbalance)) / 2.0;
            this.accounting.addDistributionTransaction(broker, transport, transport * this.distributionFee);
        }
    }

    double getDistributionFeeMin() {
        return this.distributionFeeMin;
    }

    double getDistributionFeeMax() {
        return this.distributionFeeMax;
    }

    Double getDistributionFee() {
        return this.distributionFee;
    }

    @ConfigurableValue(valueType="Double", name="balancingCost", publish=true, description="Low end of distribution fee range")
    public double getBalancingCost() {
        return this.balancingMarket.getBalancingCost();
    }

    @ConfigurableValue(valueType="Double", name="pPlusPrime", publish=true, description="Slope of up-regulation cost function")
    public double getPPlusPrime() {
        return this.balancingMarket.getPPlusPrime();
    }

    @ConfigurableValue(valueType="Double", name="pMinusPrime", publish=true, description="slope of down-regulation cost function")
    public double getPMinusPrime() {
        return this.balancingMarket.getPMinusPrime();
    }

    @ConfigurableValue(valueType="Double", name="defaultSpotPrice", publish=true, description="value used for spot price/MWh if unavailable from market")
    public double getDefaultSpotPrice() {
        return this.balancingMarket.getDefaultSpotPrice();
    }
}

