/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.distributionutility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Broker;
import org.powertac.common.Competition;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TariffTransaction;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.Accounting;
import org.powertac.common.interfaces.BalancingMarket;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.msg.CustomerBootstrapData;
import org.powertac.common.repo.BootstrapDataRepo;
import org.powertac.common.repo.BrokerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DistributionUtilityService
extends TimeslotPhaseProcessor
implements InitializationService {
    static Logger log = LogManager.getLogger((String)DistributionUtilityService.class.getSimpleName());
    @Autowired
    private BrokerRepo brokerRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private BootstrapDataRepo bootstrapDataRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    private Accounting accounting;
    @Autowired
    private BalancingMarket balancingMarket;
    @Autowired
    private ServerConfiguration serverProps;
    @Autowired
    private RandomSeedRepo randomSeedService;
    private RandomSeed randomGen;
    @ConfigurableValue(valueType="Boolean", publish=true, description="If true, DU should charge for energy transport")
    private boolean useTransportFee = true;
    @ConfigurableValue(valueType="Double", description="Low end of distribution fee range")
    private double distributionFeeMin = -0.005;
    @ConfigurableValue(valueType="Double", description="High end of distribution fee range")
    private double distributionFeeMax = -0.15;
    @ConfigurableValue(valueType="Double", publish=true, description="Distribution fee: overrides random value selection")
    private Double distributionFee = null;
    @ConfigurableValue(valueType="Boolean", publish=true, description="If true, DU should assess fixed per-customer meter charges")
    private boolean useMeterFee = false;
    @ConfigurableValue(valueType="Double", publish=true, description="Per-customer meter fee for small customers")
    private double mSmall = -0.015;
    @ConfigurableValue(valueType="Double", publish=true, description="Per-customer meter fee for large customers")
    private double mLarge = -0.05;
    @ConfigurableValue(valueType="Boolean", publish=true, description="If true, DU should assess transmission capacity fees")
    private boolean useCapacityFee = false;
    @ConfigurableValue(valueType="Integer", publish=true, description="Assessment interval in hours")
    private int assessmentInterval = 168;
    private Integer timeslotOffset = null;
    @ConfigurableValue(valueType="Double", publish=true, description="Std deviation coefficient (nu)")
    private double stdCoefficient = 1.2;
    @ConfigurableValue(valueType="Double", publish=true, description="Per-point fee (lambda)")
    private double feePerPoint = -180.0;
    private double[] netDemand;
    private HashMap<Broker, double[]> brokerNetDemand = null;
    private double runningMean = 0.0;
    private double runningVar = 0.0;
    private double runningSigma = 0.0;
    private int runningCount = 0;
    private int lastAssessmentTimeslot = 0;

    public String initialize(Competition competition, List<String> completedInits) {
        int index = completedInits.indexOf("BalancingMarket");
        if (index == -1) {
            return null;
        }
        super.init();
        this.distributionFee = null;
        this.serverProps.configureMe((Object)this);
        this.netDemand = null;
        this.brokerNetDemand = null;
        this.timeslotOffset = null;
        this.runningMean = 0.0;
        this.runningVar = 0.0;
        this.runningSigma = 0.0;
        this.runningCount = 0;
        this.lastAssessmentTimeslot = 0;
        if (this.useCapacityFee) {
            this.netDemand = new double[this.assessmentInterval];
            this.processBootstrapRecord();
        }
        this.randomGen = this.randomSeedService.getRandomSeed("DistributionUtilityService", 0L, "model");
        if (null == this.distributionFee) {
            this.distributionFee = this.distributionFeeMin + this.randomGen.nextDouble() * (this.distributionFeeMax - this.distributionFeeMin);
        }
        if (!this.useTransportFee) {
            this.distributionFee = 0.0;
        }
        log.info("Configured DU: distro fee = " + this.distributionFee);
        this.serverProps.publishConfiguration((Object)this);
        return "DistributionUtility";
    }

    private void processBootstrapRecord() {
        List usage = this.bootstrapDataRepo.getData(CustomerBootstrapData.class);
        if (null == usage || 0 == usage.size()) {
            return;
        }
        double[] first = ((CustomerBootstrapData)usage.get(0)).getNetUsage();
        if (336 != first.length) {
            log.warn("First item in customer bootstrap data is {} hrs long", new Object[]{first.length});
        }
        double[] result = new double[first.length];
        for (Object item : usage) {
            double[] data = ((CustomerBootstrapData)item).getNetUsage();
            if (data.length != first.length) {
                log.warn("Length inconsistency for record {}, length = {}", new Object[]{((CustomerBootstrapData)item).getCustomerName(), data.length});
            }
            for (int i = 0; i < Math.min(first.length, data.length); ++i) {
                int n = i;
                result[n] = result[n] - data[i];
            }
        }
        for (int i = 0; i < result.length; ++i) {
            this.updateStats(result[i]);
        }
        log.info("Bootstrap data: n = {}, mean = {}, sigma = {}", new Object[]{this.runningCount, this.runningMean, this.runningSigma});
    }

    public void activate(Instant time, int phaseNumber) {
        log.info("Activate");
        List brokerList = this.brokerRepo.findRetailBrokers();
        if (brokerList == null) {
            log.error("Failed to retrieve retail broker list");
            return;
        }
        if (this.useCapacityFee && null == this.brokerNetDemand) {
            this.brokerNetDemand = new HashMap();
            for (Broker b : brokerList) {
                this.brokerNetDemand.put(b, new double[this.assessmentInterval]);
            }
        }
        int timeslot = this.timeslotRepo.getTimeslotIndex(time);
        Map totals = this.accounting.getCurrentSupplyDemandByBroker();
        if (this.useCapacityFee) {
            this.assessCapacityFees(brokerList, timeslot, totals);
        }
        for (Broker broker : brokerList) {
            double transport = 0.0;
            double distroCharge = 0.0;
            int nSmall = 0;
            int nLarge = 0;
            if (this.useMeterFee) {
                List subs = this.tariffSubscriptionRepo.findActiveSubscriptionsForBroker(broker);
                for (TariffSubscription sub : subs) {
                    if (CustomerInfo.CustomerClass.LARGE == sub.getCustomer().getCustomerClass()) {
                        nLarge += sub.getCustomersCommitted();
                        continue;
                    }
                    nSmall += sub.getCustomersCommitted();
                }
                distroCharge += (double)nLarge * this.mLarge;
                log.info("Meter charges for {}: small={}, large={}, charge={}", new Object[]{broker.getUsername(), nSmall, nLarge, distroCharge += (double)nSmall * this.mSmall});
            }
            if (this.useTransportFee) {
                Map brokerTotals = (Map)totals.get(broker);
                if (null == brokerTotals) continue;
                double consumption = (Double)brokerTotals.get(TariffTransaction.Type.CONSUME);
                double production = (Double)brokerTotals.get(TariffTransaction.Type.PRODUCE);
                double imports = this.accounting.getCurrentMarketPosition(broker) * 1000.0;
                double imbalance = this.balancingMarket.getMarketBalance(broker);
                double balanceAdj = this.balancingMarket.getRegulation(broker);
                log.info("Distribution tx for " + broker.getUsername() + "(c,p,m,i,b) = (" + consumption + "," + production + "," + imports + "," + imbalance + "," + balanceAdj + ")");
                transport = (production - consumption - balanceAdj + Math.abs(imports - imbalance)) / 2.0;
                distroCharge += transport * this.distributionFee;
            }
            this.accounting.addDistributionTransaction(broker, nSmall, nLarge, transport, distroCharge);
        }
    }

    void assessCapacityFees(List<Broker> brokerList, int timeslot, Map<Broker, Map<TariffTransaction.Type, Double>> totals) {
        if (null == this.timeslotOffset) {
            this.timeslotOffset = timeslot;
            this.lastAssessmentTimeslot = timeslot;
            log.info("Start timeslot {}, timeslotOffset = {}", new Object[]{timeslot, this.timeslotOffset});
        } else if (0 == (timeslot - this.timeslotOffset) % this.assessmentInterval) {
            log.info("Peak-demand assessment at timeslot {}", new Object[]{timeslot});
            double threshold = this.runningMean + this.stdCoefficient * this.runningSigma;
            ArrayList<PeakEvent> peaks = new ArrayList<PeakEvent>();
            for (int i = 0; i < this.netDemand.length; ++i) {
                if (!(this.netDemand[i] >= threshold)) continue;
                peaks.add(new PeakEvent(this.netDemand[i], i));
            }
            log.info("{} peaks found above threshold {}", new Object[]{peaks.size(), threshold});
            if (peaks.size() > 0) {
                peaks.sort(null);
                HashMap<Broker, Double> brokerCharge = new HashMap<Broker, Double>();
                for (PeakEvent peak : peaks.subList(0, Math.min(3, peaks.size()))) {
                    double excess = peak.value - threshold;
                    double charge = excess * this.feePerPoint;
                    for (Broker broker : brokerList) {
                        double[] brokerDemand = this.brokerNetDemand.get(broker);
                        double cost = charge * brokerDemand[peak.index] / this.netDemand[peak.index];
                        brokerCharge.put(broker, cost);
                        double brokerExcess = excess * brokerDemand[peak.index] / this.netDemand[peak.index];
                        this.accounting.addCapacityTransaction(broker, this.lastAssessmentTimeslot + peak.index, threshold, brokerExcess, cost);
                    }
                    if (!log.isInfoEnabled()) continue;
                    double pts = peak.value - threshold;
                    StringBuilder sb = new StringBuilder(String.format("Peak at ts %d, pts=%.3f, charge=%.3f (", peak.index + timeslot - this.assessmentInterval, pts, charge));
                    for (Broker broker : brokerCharge.keySet()) {
                        sb.append(String.format("%s:%.3f, ", broker.getUsername(), brokerCharge.get(broker)));
                    }
                    sb.append(")");
                    log.info(sb.toString());
                }
            } else {
                for (Broker broker : brokerList) {
                    this.accounting.addCapacityTransaction(broker, timeslot, threshold, 0.0, 0.0);
                }
            }
            this.lastAssessmentTimeslot = timeslot;
        }
        this.recordNetDemand(timeslot, totals);
    }

    private void recordNetDemand(int timeslot, Map<Broker, Map<TariffTransaction.Type, Double>> totals) {
        int index = (timeslot - this.timeslotOffset) % this.assessmentInterval;
        double totalConsumption = 0.0;
        for (Broker broker : totals.keySet()) {
            double netConsumption;
            Map<TariffTransaction.Type, Double> data;
            double[] brokerDemand = this.brokerNetDemand.get(broker);
            if (null == brokerDemand) {
                log.warn("Broker {} not in brokerNetDemand map", new Object[]{broker.getUsername()});
                brokerDemand = new double[this.assessmentInterval];
                this.brokerNetDemand.put(broker, brokerDemand);
            }
            if (null == (data = totals.get(broker))) {
                brokerDemand[index] = 0.0;
                continue;
            }
            brokerDemand[index] = netConsumption = -(data.get(TariffTransaction.Type.PRODUCE) + data.get(TariffTransaction.Type.CONSUME));
            totalConsumption += netConsumption;
        }
        log.info("Total net consumption for ts {} = {}", new Object[]{timeslot, totalConsumption});
        this.netDemand[index] = totalConsumption;
        if (this.runningCount == 0) {
            this.runningMean = totalConsumption;
            this.runningVar = 0.0;
            this.runningCount = 1;
        } else {
            this.updateStats(totalConsumption);
            log.info("Net demand k = {}, mean = {}, sigma = {}", new Object[]{this.runningCount, this.runningMean, this.runningSigma});
        }
    }

    private void updateStats(double netConsumption) {
        double lastM = this.runningMean;
        ++this.runningCount;
        this.runningMean = lastM + (netConsumption - lastM) / (double)this.runningCount;
        this.runningVar += (netConsumption - lastM) * (netConsumption - this.runningMean);
        this.runningSigma = Math.sqrt(this.runningVar / ((double)this.runningCount - 1.0));
    }

    boolean usingTransportFee() {
        return this.useTransportFee;
    }

    double getDistributionFeeMin() {
        return this.distributionFeeMin;
    }

    double getDistributionFeeMax() {
        return this.distributionFeeMax;
    }

    Double getDistributionFee() {
        if (null == this.distributionFee) {
            return 0.0;
        }
        return this.distributionFee;
    }

    boolean usingMeterFee() {
        return this.useMeterFee;
    }

    double getMSmall() {
        return this.mSmall;
    }

    double getMLarge() {
        return this.mLarge;
    }

    boolean usingCapacityFee() {
        return this.useCapacityFee;
    }

    int getAssessmentInterval() {
        return this.assessmentInterval;
    }

    double getStdCoefficient() {
        return this.stdCoefficient;
    }

    double getFeePerPoint() {
        return this.feePerPoint;
    }

    double getRunningMean() {
        return this.runningMean;
    }

    double getRunningVar() {
        return this.runningVar;
    }

    double getRunningSigma() {
        return this.runningSigma;
    }

    int getRunningCount() {
        return this.runningCount;
    }

    int getLastAssessmentTimeslot() {
        return this.lastAssessmentTimeslot;
    }

    @ConfigurableValue(valueType="Double", name="balancingCost", publish=true, description="Low end of distribution fee range")
    public double getBalancingCost() {
        return this.balancingMarket.getBalancingCost();
    }

    @ConfigurableValue(valueType="Double", name="pPlusPrime", publish=true, description="Slope of up-regulation cost function")
    public double getPPlusPrime() {
        return this.balancingMarket.getPPlusPrime();
    }

    @ConfigurableValue(valueType="Double", name="pMinusPrime", publish=true, description="slope of down-regulation cost function")
    public double getPMinusPrime() {
        return this.balancingMarket.getPMinusPrime();
    }

    @ConfigurableValue(valueType="Double", name="defaultSpotPrice", publish=true, description="value used for spot price/MWh if unavailable from market")
    public double getDefaultSpotPrice() {
        return this.balancingMarket.getDefaultSpotPrice();
    }

    class PeakEvent
    implements Comparable<PeakEvent> {
        double value = 0.0;
        int index = 0;

        PeakEvent(double val, int idx) {
            this.value = val;
            this.index = idx;
        }

        @Override
        public int compareTo(PeakEvent o) {
            if (this.value > o.value) {
                return 1;
            }
            if (this.value < o.value) {
                return -1;
            }
            return this.index - o.index;
        }
    }
}

