/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.Random;
import org.powertac.factoredcustomer.BehaviorsProfile;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.w3c.dom.Element;

class AttitudesProfile
extends BehaviorsProfile {
    long minCapacityPerCustomer;
    long maxCapacityPerCustomer;
    ProbabilityDistribution curtailableCapacity;
    double curtailingThreshold;
    ProbabilityDistribution shiftableCapacity;
    double shiftingThreshold;
    double[] capacityRatioByMonth;
    double[] capacityRatioByDay;
    double[] capacityRatioByHour;
    InfluenceKind temperatureInfluence;
    double temperatureCorrelation;
    WeatherGranularity temperatureGranularity;
    InfluenceKind windSpeedInfluence;
    double windSpeedCorrelation;
    InfluenceKind cloudCoverInfluence;
    double cloudCoverCorrelation;

    AttitudesProfile(Element xml, Random random) {
        super(xml, random);
        Element minCapacityPerCustomerElement = (Element)xml.getElementsByTagName("minCapacityPerCustomer").item(0);
        this.minCapacityPerCustomer = Long.parseLong(minCapacityPerCustomerElement.getAttribute("value"));
        Element maxCapacityPerCustomerElement = (Element)xml.getElementsByTagName("maxCapacityPerCustomer").item(0);
        this.maxCapacityPerCustomer = Long.parseLong(maxCapacityPerCustomerElement.getAttribute("value"));
        Element curtailableCapacityElement = (Element)xml.getElementsByTagName("curtailableCapacity").item(0);
        this.curtailableCapacity = new ProbabilityDistribution(curtailableCapacityElement, random.nextLong());
        Element curtailingThresholdElement = (Element)xml.getElementsByTagName("curtailingThreshold").item(0);
        this.curtailingThreshold = Double.parseDouble(curtailingThresholdElement.getAttribute("changeRatio"));
        Element shiftableCapacityElement = (Element)xml.getElementsByTagName("shiftableCapacity").item(0);
        this.shiftableCapacity = new ProbabilityDistribution(shiftableCapacityElement, random.nextLong());
        Element shiftingThresholdElement = (Element)xml.getElementsByTagName("shiftingThreshold").item(0);
        this.shiftingThreshold = Double.parseDouble(shiftingThresholdElement.getAttribute("changeRatio"));
        Element capacityRatioByMonthElement = (Element)xml.getElementsByTagName("capacityRatioByMonth").item(0);
        this.capacityRatioByMonth = this.parseDoubleArray(capacityRatioByMonthElement.getAttribute("array"));
        Element capacityRatioByDayElement = (Element)xml.getElementsByTagName("capacityRatioByDay").item(0);
        this.capacityRatioByDay = this.parseDoubleArray(capacityRatioByDayElement.getAttribute("array"));
        Element capacityRatioByHourElement = (Element)xml.getElementsByTagName("capacityRatioByHour").item(0);
        this.capacityRatioByHour = this.parseDoubleArray(capacityRatioByHourElement.getAttribute("array"));
        Element temperatureInfluenceElement = (Element)xml.getElementsByTagName("temperatureInfluence").item(0);
        this.temperatureInfluence = Enum.valueOf(InfluenceKind.class, temperatureInfluenceElement.getAttribute("kind"));
        this.temperatureCorrelation = Double.parseDouble(temperatureInfluenceElement.getAttribute("correlation"));
        this.temperatureGranularity = Enum.valueOf(WeatherGranularity.class, temperatureInfluenceElement.getAttribute("granularity"));
        Element windSpeedInfluenceElement = (Element)xml.getElementsByTagName("windSpeedInfluence").item(0);
        this.windSpeedInfluence = Enum.valueOf(InfluenceKind.class, windSpeedInfluenceElement.getAttribute("kind"));
        this.windSpeedCorrelation = Double.parseDouble(windSpeedInfluenceElement.getAttribute("correlation"));
        Element cloudCoverInfluenceElement = (Element)xml.getElementsByTagName("cloudCoverInfluence").item(0);
        this.cloudCoverInfluence = Enum.valueOf(InfluenceKind.class, cloudCoverInfluenceElement.getAttribute("kind"));
        this.cloudCoverCorrelation = Double.parseDouble(cloudCoverInfluenceElement.getAttribute("correlation"));
    }

    protected double[] parseDoubleArray(String input) {
        String[] items = input.split(",");
        double[] ret = new double[items.length];
        for (int i = 0; i < items.length; ++i) {
            ret[i] = Double.parseDouble(items[i]);
        }
        return ret;
    }

    static enum WeatherGranularity {
        MONTHLY,
        HOURLY,
        NONE;

    }

    static enum InfluenceKind {
        DIRECT,
        DEVIATION,
        NONE;

    }
}

