/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.Random;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.w3c.dom.Element;

class BehaviorsProfile
extends CapacityProfile {
    ProbabilityDistribution baseTotalCapacity = null;
    ProbabilityDistribution baseCapacityPerCustomer = null;
    double[][] elasticityOfCapacity = null;

    BehaviorsProfile(Element xml, Random random) {
        super(xml, random);
        Element baseTotalCapacityElement = (Element)xml.getElementsByTagName("baseTotalCapacity").item(0);
        if (baseTotalCapacityElement != null) {
            this.baseTotalCapacity = new ProbabilityDistribution(baseTotalCapacityElement, random.nextLong());
        } else {
            Element baseCapacityPerCustomerElement = (Element)xml.getElementsByTagName("baseCapacityPerCustomer").item(0);
            this.baseCapacityPerCustomer = new ProbabilityDistribution(baseCapacityPerCustomerElement, random.nextLong());
        }
        Element elasticityElement = (Element)xml.getElementsByTagName("elasticityOfCapacity").item(0);
        if (elasticityElement == null) {
            throw new Error("Undefined element: elasticityOfCapacity");
        }
        String elasticityFunction = elasticityElement.getAttribute("function");
        if (elasticityFunction != null) {
            this.elasticityOfCapacity = this.pairsAsDoubleArray(elasticityFunction);
        }
    }
}

