/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.Random;
import org.powertac.common.enumerations.PowerType;
import org.w3c.dom.Element;

class CapacityProfile {
    String capacityId;
    CapacityType capacityType;
    CapacitySubType capacitySubType;
    SpecType specType;
    String description;
    double baseBenchmarkRate;

    CapacityProfile(Element xml, Random random) {
        this.capacityId = xml.getAttribute("id");
        this.capacityType = Enum.valueOf(CapacityType.class, xml.getAttribute("type"));
        this.capacitySubType = Enum.valueOf(CapacitySubType.class, xml.getAttribute("subType"));
        this.specType = Enum.valueOf(SpecType.class, xml.getAttribute("specType"));
        this.description = xml.getAttribute("description");
        Element baseBenchmarkRateElement = (Element)xml.getElementsByTagName("baseBenchmarkRate").item(0);
        this.baseBenchmarkRate = Double.parseDouble(baseBenchmarkRateElement.getAttribute("value"));
    }

    PowerType determinePowerType() {
        return CapacityProfile.reportPowerType(this.capacityType, this.capacitySubType);
    }

    static PowerType reportPowerType(CapacityType capacityType, CapacitySubType capacitySubType) {
        switch (capacityType) {
            case CONSUMPTION: {
                switch (capacitySubType) {
                    case NONE: {
                        return PowerType.CONSUMPTION;
                    }
                    case INTERRUPTIBLE: {
                        return PowerType.INTERRUPTIBLE_CONSUMPTION;
                    }
                    case THERMAL_STORAGE: {
                        return PowerType.INTERRUPTIBLE_CONSUMPTION;
                    }
                }
                throw new Error("Incompatible capacity subType: " + (Object)((Object)capacitySubType));
            }
            case PRODUCTION: {
                switch (capacitySubType) {
                    case NONE: {
                        return PowerType.PRODUCTION;
                    }
                    case SOLAR: {
                        return PowerType.SOLAR_PRODUCTION;
                    }
                    case WIND: {
                        return PowerType.WIND_PRODUCTION;
                    }
                    case RUN_OF_RIVER: {
                        return PowerType.RUN_OF_RIVER_PRODUCTION;
                    }
                    case PUMPED_STORAGE: {
                        return PowerType.PUMPED_STORAGE_PRODUCTION;
                    }
                    case CHP: {
                        return PowerType.CHP_PRODUCTION;
                    }
                    case FOSSIL: {
                        return PowerType.FOSSIL_PRODUCTION;
                    }
                }
                throw new Error("Incompatible capacity subType: " + (Object)((Object)capacitySubType));
            }
            case STORAGE: {
                switch (capacitySubType) {
                    case BATTERY_STORAGE: {
                        return PowerType.BATTERY_STORAGE;
                    }
                    case ELECTRIC_VEHICLE: {
                        return PowerType.ELECTRIC_VEHICLE;
                    }
                }
                throw new Error("Incompatible capacity subType: " + (Object)((Object)capacitySubType));
            }
        }
        throw new Error("Incompatible capacity type: " + (Object)((Object)capacityType));
    }

    static CapacityType reportCapacityType(PowerType powerType) {
        switch (powerType) {
            case CONSUMPTION: 
            case INTERRUPTIBLE_CONSUMPTION: 
            case THERMAL_STORAGE_CONSUMPTION: {
                return CapacityType.CONSUMPTION;
            }
            case PRODUCTION: 
            case SOLAR_PRODUCTION: 
            case WIND_PRODUCTION: 
            case RUN_OF_RIVER_PRODUCTION: 
            case PUMPED_STORAGE_PRODUCTION: 
            case CHP_PRODUCTION: 
            case FOSSIL_PRODUCTION: {
                return CapacityType.PRODUCTION;
            }
            case BATTERY_STORAGE: 
            case ELECTRIC_VEHICLE: {
                return CapacityType.STORAGE;
            }
        }
        throw new Error("Unexpected powerType: " + powerType);
    }

    protected double[][] pairsAsDoubleArray(String input) {
        String[] pairs = input.split(",");
        double[][] ret = new double[pairs.length][2];
        for (int i = 0; i < pairs.length; ++i) {
            String[] vals = pairs[i].split(":");
            ret[i][0] = Double.parseDouble(vals[0]);
            ret[i][1] = Double.parseDouble(vals[1]);
        }
        return ret;
    }

    static SpecType reportSpecType(Element xml) {
        return Enum.valueOf(SpecType.class, xml.getAttribute("specType"));
    }

    static enum SpecType {
        BEHAVIORS,
        FACTORED;

    }

    static enum CapacitySubType {
        NONE,
        INTERRUPTIBLE,
        THERMAL_STORAGE,
        SOLAR,
        WIND,
        RUN_OF_RIVER,
        PUMPED_STORAGE,
        CHP,
        FOSSIL,
        BATTERY_STORAGE,
        ELECTRIC_VEHICLE;

    }

    static enum CapacityType {
        CONSUMPTION,
        PRODUCTION,
        STORAGE;

    }
}

