/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.Map;
import org.powertac.factoredcustomer.CustomerCategory;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.FactoredCustomer;

class CustomerFactory {
    CustomerCreator defaultCreator;
    Map<CustomerCategory, CustomerCreator> customerCreators = new HashMap<CustomerCategory, CustomerCreator>();

    CustomerFactory() {
    }

    void registerDefaultCreator(CustomerCreator creator) {
        this.defaultCreator = creator;
    }

    void registerCreator(CustomerCreator creator) {
        this.registerCreator(creator.getCategory(), creator);
    }

    void registerCreator(CustomerProfile.EntityType entityType, CustomerProfile.CustomerRole customerRole, CustomerProfile.ModelType modelType, CustomerCreator creator) {
        this.registerCreator(new CustomerCategory(entityType, customerRole, modelType), creator);
    }

    void registerCreator(CustomerCategory category, CustomerCreator creator) {
        this.customerCreators.put(category, creator);
    }

    FactoredCustomer processProfile(CustomerProfile profile) {
        CustomerCreator creator = this.customerCreators.get(profile.category);
        if (creator == null) {
            creator = this.defaultCreator;
        }
        return creator.createModel(profile);
    }

    public static interface CustomerCreator {
        public CustomerCategory getCategory();

        public FactoredCustomer createModel(CustomerProfile var1);
    }
}

