/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.powertac.common.CustomerInfo;
import org.powertac.common.RandomSeed;
import org.powertac.common.enumerations.CustomerType;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.factoredcustomer.AttitudesProfile;
import org.powertac.factoredcustomer.BehaviorsProfile;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerCategory;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class CustomerProfile {
    @Autowired
    RandomSeedRepo randomSeedRepo;
    private static long profileCounter = 0L;
    long profileId = ++profileCounter;
    Random random;
    String name;
    CustomerCategory category;
    CustomerInfo customerInfo;
    TariffUtilityCriteria tariffUtilityCriteria = null;
    List<List<Double>> tariffAllocationRules = new ArrayList<List<Double>>();
    ProbabilityDistribution tariffSwitchingInertia = null;
    double[] temperatureByMonth = null;
    ProbabilityDistribution customerWealth = null;
    ProbabilityDistribution newTariffsExposure = null;
    ProbabilityDistribution tariffSwitchDelay = null;
    ProbabilityDistribution waitAfterTariffSwitch = null;
    boolean preferFewerTariffs = false;
    List<CapacityProfile> capacityProfiles = new ArrayList<CapacityProfile>();

    CustomerProfile(Element xml) {
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        RandomSeed rs = this.randomSeedRepo.getRandomSeed(CustomerProfile.class.getName(), this.profileId, "Initializer");
        this.random = new Random(rs.getValue());
        this.name = xml.getAttribute("name");
        Element categoryElement = (Element)xml.getElementsByTagName("category").item(0);
        EntityType entityType = Enum.valueOf(EntityType.class, categoryElement.getAttribute("entityType"));
        CustomerRole customerRole = Enum.valueOf(CustomerRole.class, categoryElement.getAttribute("customerRole"));
        ModelType modelType = Enum.valueOf(ModelType.class, categoryElement.getAttribute("modelType"));
        this.category = new CustomerCategory(entityType, customerRole, modelType);
        int population = Integer.parseInt(((Element)xml.getElementsByTagName("population").item(0)).getAttribute("value"));
        this.customerInfo = new CustomerInfo(this.name, population);
        switch (this.category.entityType) {
            case RESIDENTIAL: {
                this.customerInfo.withCustomerType(CustomerType.CustomerHousehold);
                break;
            }
            case COMMERCIAL: {
                this.customerInfo.withCustomerType(CustomerType.CustomerOffice);
                break;
            }
            case INDUSTRIAL: {
                this.customerInfo.withCustomerType(CustomerType.CustomerFactory);
                break;
            }
            default: {
                this.customerInfo.withCustomerType(CustomerType.CustomerOther);
            }
        }
        Element multiContractingElement = (Element)xml.getElementsByTagName("multiContracting").item(0);
        this.customerInfo.withMultiContracting(Boolean.parseBoolean(multiContractingElement.getAttribute("value")));
        Element canNegotiateElement = (Element)xml.getElementsByTagName("canNegotiate").item(0);
        this.customerInfo.withCanNegotiate(Boolean.parseBoolean(canNegotiateElement.getAttribute("value")));
        boolean customerBehaviorsInitialized = false;
        boolean customerFactorsInitialized = false;
        NodeList capacities = xml.getElementsByTagName("capacity");
        for (int i = 0; i < capacities.getLength(); ++i) {
            BehaviorsProfile capacityProfile;
            Element capacitySpec = (Element)capacities.item(i);
            CapacityProfile.SpecType specType = CapacityProfile.reportSpecType(capacitySpec);
            if (specType == CapacityProfile.SpecType.BEHAVIORS) {
                if (!customerBehaviorsInitialized) {
                    Element tariffUtilityElement = (Element)xml.getElementsByTagName("tariffUtility").item(0);
                    this.tariffUtilityCriteria = Enum.valueOf(TariffUtilityCriteria.class, tariffUtilityElement.getAttribute("criteria"));
                    String tariffAllocationRulesConfig = tariffUtilityElement.getAttribute("allocationRules");
                    this.populateTariffAllocationRules(tariffAllocationRulesConfig);
                    Element tariffSwitchingInertiaElement = (Element)xml.getElementsByTagName("tariffSwitchingInertia").item(0);
                    this.tariffSwitchingInertia = new ProbabilityDistribution(tariffSwitchingInertiaElement, this.random.nextLong());
                    customerBehaviorsInitialized = true;
                }
                capacityProfile = new BehaviorsProfile(capacitySpec, this.random);
            } else {
                if (!customerFactorsInitialized) {
                    Element temperatureByMonthElement = (Element)xml.getElementsByTagName("temperatureByMonth").item(0);
                    String temperatureByMonthString = temperatureByMonthElement.getAttribute("array");
                    this.temperatureByMonth = this.parseDoubleArray(temperatureByMonthString);
                    Element customerWealthElement = (Element)xml.getElementsByTagName("customerWealth").item(0);
                    this.customerWealth = new ProbabilityDistribution(customerWealthElement, this.random.nextLong());
                    Element newTariffsExposureElement = (Element)xml.getElementsByTagName("newTariffsExposure").item(0);
                    this.newTariffsExposure = new ProbabilityDistribution(newTariffsExposureElement, this.random.nextLong());
                    Element tariffSwitchDelayElement = (Element)xml.getElementsByTagName("tariffSwitchDelay").item(0);
                    this.tariffSwitchDelay = new ProbabilityDistribution(tariffSwitchDelayElement, this.random.nextLong());
                    Element waitAfterTariffSwitchElement = (Element)xml.getElementsByTagName("waitAfterTariffSwitch").item(0);
                    this.waitAfterTariffSwitch = new ProbabilityDistribution(waitAfterTariffSwitchElement, this.random.nextLong());
                    Element preferFewerTariffsElement = (Element)xml.getElementsByTagName("preferFewerTariffs").item(0);
                    this.preferFewerTariffs = Boolean.parseBoolean(preferFewerTariffsElement.getAttribute("value"));
                    customerFactorsInitialized = true;
                }
                capacityProfile = new AttitudesProfile(capacitySpec, this.random);
            }
            this.capacityProfiles.add(capacityProfile);
            PowerType powerType = capacityProfile.determinePowerType();
            if (this.customerInfo.getPowerTypes().contains(powerType)) continue;
            this.customerInfo.addPowerType(powerType);
        }
    }

    void populateTariffAllocationRules(String config) {
        String[] rules = config.split(",");
        ArrayList<Double> degenerateRule = new ArrayList<Double>(1);
        degenerateRule.add(1.0);
        this.tariffAllocationRules.add(degenerateRule);
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i].length() <= 0) continue;
            String[] vals = rules[i].split(":");
            ArrayList<Double> rule = new ArrayList<Double>(vals.length);
            for (int j = 0; j < vals.length; ++j) {
                rule.add(Double.parseDouble(vals[j]));
            }
            this.tariffAllocationRules.add(rule);
        }
    }

    protected double[] parseDoubleArray(String input) {
        String[] items = input.split(",");
        double[] ret = new double[items.length];
        for (int i = 0; i < items.length; ++i) {
            ret[i] = Double.parseDouble(items[i]);
        }
        return ret;
    }

    static enum TariffUtilityCriteria {
        BEST_VALUE,
        PREFER_GREEN;

    }

    static enum ModelType {
        INDIVIDUAL,
        POPULATION;

    }

    static enum CustomerRole {
        CONSUMER,
        PRODUCER,
        HYBRID;

    }

    static enum EntityType {
        RESIDENTIAL,
        COMMERCIAL,
        INDUSTRIAL;

    }
}

