/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.TimeService;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.factoredcustomer.BehaviorsProfile;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerProfile;
import org.springframework.beans.factory.annotation.Autowired;

class DefaultCapacityManager {
    private static Logger log = Logger.getLogger((String)DefaultCapacityManager.class.getName());
    @Autowired
    TimeService timeService;
    @Autowired
    TimeslotRepo timeslotRepo;
    protected static final int BASE_CAPACITY_TIMESLOTS = 24;
    protected static final int NUM_HOURS_IN_DAY = 24;
    CustomerProfile customerProfile;
    CapacityProfile capacityProfile;

    DefaultCapacityManager(CustomerProfile customer, CapacityProfile capacity) {
        this.customerProfile = customer;
        this.capacityProfile = capacity;
        this.timeService = (TimeService)SpringApplicationContext.getBean((String)"timeService");
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
    }

    double computeDailyUsageCharge(Tariff tariff) {
        Timeslot hourlyTimeslot = this.timeslotRepo.currentTimeslot();
        double totalUsage = 0.0;
        double totalCharge = 0.0;
        for (int i = 0; i < 24; ++i) {
            double baseCapacity = 0.0;
            if (this.capacityProfile.specType == CapacityProfile.SpecType.BEHAVIORS) {
                BehaviorsProfile behaviorsProfile = (BehaviorsProfile)this.capacityProfile;
                if (behaviorsProfile.baseTotalCapacity != null) {
                    baseCapacity = ((BehaviorsProfile)this.capacityProfile).baseTotalCapacity.drawSample();
                } else {
                    double draw = behaviorsProfile.baseCapacityPerCustomer.drawSample();
                    baseCapacity += draw * (double)this.customerProfile.customerInfo.getPopulation();
                }
            }
            double hourlyUsage = (double)this.customerProfile.customerInfo.getPopulation() * (baseCapacity / 24.0);
            totalCharge += tariff.getUsageCharge(hourlyTimeslot.getStartInstant(), hourlyUsage, totalUsage);
            totalUsage += hourlyUsage;
            hourlyTimeslot = hourlyTimeslot.getNext();
        }
        return totalCharge;
    }

    double drawBaseCapacitySample(TariffSubscription subscription) {
        double baseCapacity = 0.0;
        BehaviorsProfile behaviorsProfile = (BehaviorsProfile)this.capacityProfile;
        if (behaviorsProfile.baseTotalCapacity != null) {
            double popRatio = subscription.getCustomersCommitted() / this.customerProfile.customerInfo.getPopulation();
            baseCapacity = popRatio * behaviorsProfile.baseTotalCapacity.drawSample() / 24.0;
        } else {
            for (int i = 0; i < subscription.getCustomersCommitted(); ++i) {
                double draw = behaviorsProfile.baseCapacityPerCustomer.drawSample();
                baseCapacity += draw / 24.0;
            }
        }
        return DefaultCapacityManager.truncateTo2Decimals(baseCapacity);
    }

    double computeCapacity(Timeslot timeslot, TariffSubscription subscription) {
        double computedCapacity = this.capacityProfile.specType == CapacityProfile.SpecType.BEHAVIORS ? this.computeCapacityFromBehaviors(timeslot, subscription) : this.computeCapacityFromFactors(timeslot, subscription);
        return DefaultCapacityManager.truncateTo2Decimals(computedCapacity);
    }

    double computeCapacityFromBehaviors(Timeslot timeslot, TariffSubscription subscription) {
        double baseCapacity = this.drawBaseCapacitySample(subscription);
        log.info((Object)("Base capacity from behaviors = " + baseCapacity));
        double adjustedCapacity = baseCapacity;
        BehaviorsProfile behaviorsProfile = (BehaviorsProfile)this.capacityProfile;
        if (behaviorsProfile.elasticityOfCapacity != null) {
            adjustedCapacity = this.computeElasticCapacity(timeslot, subscription, baseCapacity);
        }
        adjustedCapacity = DefaultCapacityManager.truncateTo2Decimals(adjustedCapacity);
        log.info((Object)("Adjusted capacity from behaviors = " + adjustedCapacity));
        return adjustedCapacity;
    }

    double computeCapacityFromFactors(Timeslot timeslot, TariffSubscription subscription) {
        double baseCapacity = this.drawBaseCapacitySample(subscription);
        log.info((Object)("Base capacity from factors = " + baseCapacity));
        double adjustedCapacity = baseCapacity;
        BehaviorsProfile behaviorsProfile = (BehaviorsProfile)this.capacityProfile;
        if (behaviorsProfile.elasticityOfCapacity != null) {
            adjustedCapacity = this.computeElasticCapacity(timeslot, subscription, baseCapacity);
        }
        adjustedCapacity = DefaultCapacityManager.truncateTo2Decimals(adjustedCapacity);
        log.info((Object)("Adjusted capacity from factors = " + adjustedCapacity));
        return adjustedCapacity;
    }

    double computeElasticCapacity(Timeslot timeslot, TariffSubscription subscription, double baseCapacity) {
        double chargeForBase = subscription.getTariff().getUsageCharge(timeslot.getStartInstant(), baseCapacity, subscription.getTotalUsage());
        double rateForBase = chargeForBase / baseCapacity;
        double rateRatio = rateForBase / this.capacityProfile.baseBenchmarkRate;
        BehaviorsProfile behaviorsProfile = (BehaviorsProfile)this.capacityProfile;
        double[][] elasticity = behaviorsProfile.elasticityOfCapacity;
        double elasticityFactor = this.lookupElasticityFactor(rateRatio, elasticity);
        log.debug((Object)("Compute elastic capacity - elasticityFactor = " + elasticityFactor));
        double elasticCapacity = baseCapacity * elasticityFactor;
        return elasticCapacity;
    }

    double lookupElasticityFactor(double rateRatio, double[][] elasticity) {
        if (rateRatio == 1.0 || elasticity.length == 0) {
            return 1.0;
        }
        boolean RATE_RATIO_INDEX = false;
        boolean CAPACITY_FACTOR_INDEX = true;
        double rateLowerBound = Double.NEGATIVE_INFINITY;
        double rateUpperBound = Double.POSITIVE_INFINITY;
        double lowerBoundCapacityFactor = 1.0;
        double upperBoundCapacityFactor = 1.0;
        for (int i = 0; i < elasticity.length; ++i) {
            double r = elasticity[i][0];
            if (r <= rateRatio && r > rateLowerBound) {
                rateLowerBound = r;
                lowerBoundCapacityFactor = elasticity[i][1];
            }
            if (!(r >= rateRatio) || !(r < rateUpperBound)) continue;
            rateUpperBound = r;
            upperBoundCapacityFactor = elasticity[i][1];
        }
        return rateRatio < 1.0 ? upperBoundCapacityFactor : lowerBoundCapacityFactor;
    }

    private static double truncateTo2Decimals(double x) {
        double fract;
        double whole;
        if (x > 0.0) {
            whole = Math.floor(x);
            fract = Math.floor((x - whole) * 100.0) / 100.0;
        } else {
            whole = Math.ceil(x);
            fract = Math.ceil((x - whole) * 100.0) / 100.0;
        }
        return whole + fract;
    }
}

