/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerCategory;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.DefaultCapacityManager;
import org.powertac.factoredcustomer.FactoredCustomer;
import org.springframework.beans.factory.annotation.Autowired;

class DefaultFactoredCustomer
extends FactoredCustomer {
    private static Logger log = Logger.getLogger((String)DefaultFactoredCustomer.class.getName());
    @Autowired
    TimeslotRepo timeslotRepo;
    private static final long MEAN_TARIFF_DURATION = 5L;
    protected static Creator creator = new Creator();
    boolean canConsume = false;
    boolean canProduce = false;
    List<DefaultCapacityManager> capacityManagers = new ArrayList<DefaultCapacityManager>();
    List<Tariff> ignoredTariffs = new ArrayList<Tariff>();
    List<List<Double>> tariffAllocationRules = new ArrayList<List<Double>>();

    public static Creator getCreator() {
        return creator;
    }

    DefaultFactoredCustomer(CustomerProfile profile) {
        super(profile);
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.customerProfile = profile;
        for (CapacityProfile capacityProfile : this.customerProfile.capacityProfiles) {
            if (capacityProfile.capacityType == CapacityProfile.CapacityType.CONSUMPTION) {
                this.canConsume = true;
            } else if (capacityProfile.capacityType == CapacityProfile.CapacityType.PRODUCTION) {
                this.canProduce = true;
            }
            DefaultCapacityManager capacityManager = new DefaultCapacityManager(this.customerProfile, capacityProfile);
            this.capacityManagers.add(capacityManager);
        }
        log.info((Object)("Customer created for profile: " + this.customerProfile.name));
    }

    @Override
    void handleNewTariffs(List<Tariff> newTariffs) {
        log.debug((Object)("handleTariffs() begin - " + this.getName()));
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(this.getCustomerInfo());
        if (subscriptions == null || subscriptions.size() == 0) {
            this.subscribeDefault();
        } else {
            this.reevaluateTariffs(newTariffs);
        }
        log.debug((Object)("handleTariffs() end - " + this.getName()));
    }

    @Override
    public void subscribeDefault() {
        for (PowerType powerType : this.getCustomerInfo().getPowerTypes()) {
            if (this.tariffMarketService.getDefaultTariff(powerType) == null) {
                log.info((Object)("subscribeDefault() - " + this.getName() + ": No default tariff for power type " + powerType + "; trying less specific type."));
                CapacityProfile.CapacityType capacityType = CapacityProfile.reportCapacityType(powerType);
                PowerType generalType = CapacityProfile.reportPowerType(capacityType, CapacityProfile.CapacitySubType.NONE);
                if (this.tariffMarketService.getDefaultTariff(generalType) == null) {
                    log.warn((Object)("subscribeDefault() - " + this.getName() + ": No default tariff for general power type " + powerType + " either!"));
                    continue;
                }
                this.tariffMarketService.subscribeToTariff(this.tariffMarketService.getDefaultTariff(generalType), this.getCustomerInfo(), this.getPopulation());
                log.info((Object)("subscribeDefault() - " + this.getName() + " subscribed " + this.getPopulation() + " customers to default " + generalType + " tariff successfully."));
                continue;
            }
            this.tariffMarketService.subscribeToTariff(this.tariffMarketService.getDefaultTariff(powerType), this.getCustomerInfo(), this.getPopulation());
            log.info((Object)("subscribeDefault() - " + this.getName() + " subscribed " + this.getPopulation() + " customers to default " + powerType + " tariff successfully."));
        }
    }

    public void subscribe(Tariff tariff, int customerCount) {
        this.tariffMarketService.subscribeToTariff(tariff, this.getCustomerInfo(), customerCount);
        log.info((Object)("subscribe() - " + this.getName() + " subscribed " + customerCount + " customers to tariff " + tariff.getId() + " successfully."));
    }

    public void unsubscribe(TariffSubscription subscription, int customerCount) {
        subscription.unsubscribe(customerCount);
        log.info((Object)("unsubscribe() - " + this.getName() + " unsubscribed " + customerCount + " customers from tariff " + subscription.getTariff().getId() + " successfully."));
    }

    void reevaluateTariffs(List<Tariff> newTariffs) {
        log.info((Object)("handleNewTariffs() begin - " + this.getName() + ": Received " + newTariffs.size() + " new tariffs."));
        if (this.customerProfile.tariffSwitchingInertia != null) {
            double inertia = this.customerProfile.tariffSwitchingInertia.drawSample();
            if (this.customerProfile.random.nextDouble() < inertia) {
                log.info((Object)"handleNewTariffs() - Ignoring new tariffs for now due to tariff switching inertia.");
                for (Tariff newTariff : newTariffs) {
                    this.ignoredTariffs.add(newTariff);
                }
                return;
            }
        }
        HashMap<Long, Tariff> allTariffs = new HashMap<Long, Tariff>();
        for (Tariff ignoredTariff : this.ignoredTariffs) {
            allTariffs.put(ignoredTariff.getId(), ignoredTariff);
        }
        this.ignoredTariffs.clear();
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(this.getCustomerInfo());
        for (TariffSubscription subscription : subscriptions) {
            allTariffs.put(subscription.getTariff().getId(), subscription.getTariff());
        }
        for (Tariff newTariff : newTariffs) {
            allTariffs.put(newTariff.getId(), newTariff);
        }
        if (this.canConsume) {
            this.manageSubscriptions(allTariffs, CapacityProfile.CapacityType.CONSUMPTION);
        }
        if (this.canProduce) {
            this.manageSubscriptions(allTariffs, CapacityProfile.CapacityType.PRODUCTION);
        }
        log.info((Object)("handleNewTariffs() end - " + this.getName()));
    }

    void manageSubscriptions(Map<Long, Tariff> allTariffs, CapacityProfile.CapacityType capacityType) {
        log.info((Object)("manageSubscriptions() begin - " + this.getName() + "; capacityType: " + (Object)((Object)capacityType)));
        ArrayList<Tariff> evalTariffs = new ArrayList<Tariff>();
        for (Tariff tariff : allTariffs.values()) {
            if (CapacityProfile.reportCapacityType(tariff.getTariffSpec().getPowerType()) != capacityType) continue;
            evalTariffs.add(tariff);
        }
        if (evalTariffs.isEmpty()) {
            log.info((Object)("manageSubscriptions(): end early - No new tariffs to evaluate for capacity type: " + (Object)((Object)capacityType)));
            return;
        }
        log.info((Object)("manageSubscriptions(): Number of " + (Object)((Object)capacityType) + " tariffs for evaluation: " + evalTariffs.size()));
        double[] estimatedPayments = new double[evalTariffs.size()];
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff tariff = (Tariff)evalTariffs.get(i);
            if (tariff.isExpired()) {
                estimatedPayments[i] = Double.POSITIVE_INFINITY;
                continue;
            }
            double totalVariablePayments = 0.0;
            for (DefaultCapacityManager capacityManager : this.capacityManagers) {
                if (capacityManager.capacityProfile.capacityType != capacityType) continue;
                totalVariablePayments += capacityManager.computeDailyUsageCharge(tariff);
            }
            estimatedPayments[i] = this.estimateFixedTariffPayments(tariff) + totalVariablePayments;
        }
        List<Integer> allocations = this.determineAllocations(evalTariffs, estimatedPayments, capacityType);
        log.info((Object)("manageSubscriptions(): " + (Object)((Object)capacityType) + " allocations: " + allocations));
        int overAllocations = 0;
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff evalTariff = (Tariff)evalTariffs.get(i);
            int allocation = allocations.get(i);
            TariffSubscription subscription = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(evalTariff, this.getCustomerInfo());
            int currentCommitted = subscription != null ? subscription.getCustomersCommitted() : 0;
            int numChange = allocation - currentCommitted;
            log.debug((Object)("manageSubscriptions() - evalTariff = " + evalTariff.getId() + ", numChange = " + numChange + ", currentCommitted = " + currentCommitted + ", allocation = " + allocation));
            if (numChange == 0) {
                if (currentCommitted > 0) {
                    log.info((Object)("manageSubscriptions() - Maintaining " + currentCommitted + " " + (Object)((Object)capacityType) + " customers in tariff " + evalTariff.getId()));
                    continue;
                }
                log.info((Object)("manageSubscriptions() - Not allocating any " + (Object)((Object)capacityType) + " customers to tariff " + evalTariff.getId()));
                continue;
            }
            if (numChange > 0) {
                if (evalTariff.isExpired()) {
                    overAllocations += numChange;
                    if (currentCommitted > 0) {
                        log.info((Object)("manageSubscriptions() - Maintaining " + currentCommitted + " " + (Object)((Object)capacityType) + " customers in expired tariff " + evalTariff.getId()));
                    }
                    log.info((Object)("manageSubscriptions() - Reallocating " + numChange + " " + (Object)((Object)capacityType) + " customers from expired tariff " + evalTariff.getId() + " to other tariffs"));
                    continue;
                }
                log.info((Object)("manageSubscriptions() - Subscribing " + numChange + " " + (Object)((Object)capacityType) + " customers to tariff " + evalTariff.getId()));
                this.subscribe(evalTariff, numChange);
                continue;
            }
            if (numChange >= 0) continue;
            log.info((Object)("manageSubscriptions()  - Unsubscribing " + -numChange + " " + (Object)((Object)capacityType) + " customers from tariff " + evalTariff.getId()));
            this.unsubscribe(subscription, -numChange);
        }
        if (overAllocations > 0) {
            int minIndex = 0;
            double minEstimate = Double.POSITIVE_INFINITY;
            for (int i = 0; i < estimatedPayments.length; ++i) {
                if (!(estimatedPayments[i] < minEstimate) || ((Tariff)evalTariffs.get(i)).isExpired()) continue;
                minIndex = i;
                minEstimate = estimatedPayments[i];
            }
            log.info((Object)("manageSubscriptions() - Subscribing " + overAllocations + " over-allocated customers to tariff " + ((Tariff)evalTariffs.get(minIndex)).getId()));
            this.subscribe((Tariff)evalTariffs.get(minIndex), overAllocations);
        }
        log.info((Object)("manageSubscriptions(): end - " + this.getName() + "; capacityType: " + (Object)((Object)capacityType)));
    }

    double estimateFixedTariffPayments(Tariff tariff) {
        double lifecyclePayment = tariff.getEarlyWithdrawPayment() + tariff.getSignupPayment();
        double minDuration = tariff.getMinDuration() == 0L ? 4.32E8 : (double)tariff.getMinDuration();
        return tariff.getPeriodicPayment() + lifecyclePayment / minDuration;
    }

    List<Integer> determineAllocations(List<Tariff> evalTariffs, double[] estimatedPayments, CapacityProfile.CapacityType capacityType) {
        List<Object> allocationRule;
        int numTariffs = evalTariffs.size();
        if (this.customerProfile.tariffAllocationRules.isEmpty()) {
            allocationRule = new ArrayList<Double>(numTariffs);
            allocationRule.add(1.0);
            for (int i = 1; i < numTariffs; ++i) {
                allocationRule.add(0.0);
            }
        } else if (numTariffs <= this.customerProfile.tariffAllocationRules.size()) {
            allocationRule = this.customerProfile.tariffAllocationRules.get(numTariffs - 1);
        } else {
            allocationRule = new ArrayList(numTariffs);
            List<Double> largestRule = this.customerProfile.tariffAllocationRules.get(this.customerProfile.tariffAllocationRules.size() - 1);
            for (int i = 0; i < numTariffs; ++i) {
                if (i < largestRule.size()) {
                    allocationRule.add(largestRule.get(i));
                    continue;
                }
                allocationRule.add(0.0);
            }
        }
        ArrayList<Double> sortedPayments = new ArrayList<Double>(estimatedPayments.length);
        for (double estimatedPayment : estimatedPayments) {
            sortedPayments.add(estimatedPayment);
        }
        Collections.sort(sortedPayments);
        ArrayList<Integer> allocations = new ArrayList<Integer>(numTariffs);
        for (int i = 0; i < numTariffs; ++i) {
            if ((Double)allocationRule.get(i) > 0.0) {
                double nextBest = (Double)sortedPayments.get(i);
                for (int j = 0; j < numTariffs; ++j) {
                    if (estimatedPayments[j] != nextBest) continue;
                    allocations.add((int)Math.round((double)this.getCustomerInfo().getPopulation() * (Double)allocationRule.get(i)));
                }
                continue;
            }
            allocations.add(0);
        }
        return allocations;
    }

    @Override
    public void handleNewTimeslot() {
        Timeslot timeslot = this.timeslotRepo.currentTimeslot();
        log.info((Object)("Customer " + this.customerProfile.name + " begin step for timeslot " + timeslot.getSerialNumber()));
        this.checkRevokedSubscriptions();
        if (this.canConsume) {
            this.consumePower();
        }
        if (this.canProduce) {
            this.producePower();
        }
        log.info((Object)("Customer " + this.customerProfile.name + " end step for timeslot " + timeslot.getSerialNumber()));
    }

    protected void checkRevokedSubscriptions() {
        List revoked = this.tariffSubscriptionRepo.getRevokedSubscriptionList(this.getCustomerInfo());
        for (TariffSubscription revokedSubscription : revoked) {
            revokedSubscription.handleRevokedTariff();
        }
    }

    public void consumePower() {
        Timeslot timeslot = this.timeslotRepo.currentTimeslot();
        double totalConsumption = 0.0;
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(this.getCustomerInfo());
        for (TariffSubscription subscription : subscriptions) {
            if (subscription.getCustomersCommitted() <= 0 || CapacityProfile.reportCapacityType(subscription.getTariff().getTariffSpec().getPowerType()) != CapacityProfile.CapacityType.CONSUMPTION) continue;
            for (DefaultCapacityManager capacityManager : this.capacityManagers) {
                if (capacityManager.capacityProfile.capacityType != CapacityProfile.CapacityType.CONSUMPTION) continue;
                double currCapacity = capacityManager.computeCapacity(timeslot, subscription);
                subscription.usePower(currCapacity);
                totalConsumption += currCapacity;
            }
        }
        log.info((Object)("Total consumption for timeslot " + timeslot.getSerialNumber() + " = " + totalConsumption));
    }

    public void producePower() {
        if (!this.canProduce) {
            return;
        }
        Timeslot timeslot = this.timeslotRepo.currentTimeslot();
        double totalProduction = 0.0;
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(this.getCustomerInfo());
        for (TariffSubscription subscription : subscriptions) {
            if (subscription.getCustomersCommitted() <= 0 || CapacityProfile.reportCapacityType(subscription.getTariff().getTariffSpec().getPowerType()) != CapacityProfile.CapacityType.PRODUCTION) continue;
            for (DefaultCapacityManager capacityManager : this.capacityManagers) {
                if (capacityManager.capacityProfile.capacityType != CapacityProfile.CapacityType.PRODUCTION) continue;
                double currCapacity = -1.0 * capacityManager.computeCapacity(timeslot, subscription);
                subscription.usePower(currCapacity);
                totalProduction = currCapacity;
            }
        }
        log.info((Object)("Total production for timeslot " + timeslot.getSerialNumber() + " = " + totalProduction));
    }

    @Override
    public String toString() {
        return "DefaultFactoredCustomer:" + this.getName();
    }

    public static class Creator
    implements CustomerFactory.CustomerCreator {
        @Override
        public CustomerCategory getCategory() {
            return null;
        }

        @Override
        public FactoredCustomer createModel(CustomerProfile profile) {
            return new DefaultFactoredCustomer(profile);
        }
    }
}

