/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.List;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.factoredcustomer.CustomerProfile;
import org.springframework.beans.factory.annotation.Autowired;

abstract class FactoredCustomer {
    @Autowired
    CustomerRepo customerRepo;
    @Autowired
    TariffMarket tariffMarketService;
    @Autowired
    TariffSubscriptionRepo tariffSubscriptionRepo;
    CustomerProfile customerProfile;

    FactoredCustomer(CustomerProfile profile) {
        this.customerProfile = profile;
        this.customerRepo = (CustomerRepo)SpringApplicationContext.getBean((String)"customerRepo");
        this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean((String)"tariffMarketService");
        this.tariffSubscriptionRepo = (TariffSubscriptionRepo)SpringApplicationContext.getBean((String)"tariffSubscriptionRepo");
        this.customerRepo.add(profile.customerInfo);
    }

    abstract void subscribeDefault();

    abstract void handleNewTariffs(List<Tariff> var1);

    abstract void handleNewTimeslot();

    public CustomerInfo getCustomerInfo() {
        return this.customerProfile.customerInfo;
    }

    public String getName() {
        return this.customerProfile.name;
    }

    public int getPopulation() {
        return this.getCustomerInfo().getPopulation();
    }

    public String toString() {
        return "FactoredCustomer:" + this.getName();
    }
}

