/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Competition;
import org.powertac.common.PluginConfig;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.repo.PluginConfigRepo;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FactoredCustomerInitializationService
implements InitializationService {
    private static Logger log = Logger.getLogger((String)FactoredCustomerInitializationService.class.getName());
    @Autowired
    private FactoredCustomerService factoredCustomerService;
    @Autowired
    private PluginConfigRepo pluginConfigRepo;

    public void setDefaults() {
        this.pluginConfigRepo.makePluginConfig("FactoredCustomer", "").addConfiguration("configResource", "FactoredCustomers.xml");
    }

    public String initialize(Competition competition, List<String> completedInits) {
        if (!completedInits.contains("DefaultBroker")) {
            log.debug((Object)"Waiting for DefaultBroker to initialize");
            return null;
        }
        PluginConfig config = this.pluginConfigRepo.findByRoleName("FactoredCustomer");
        if (config == null) {
            log.error((Object)"PluginConfig for FactoredCustomer does not exist.");
            return "fail";
        }
        this.factoredCustomerService.init(config);
        return "FactoredCustomer";
    }
}

