/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.PluginConfig;
import org.powertac.common.Tariff;
import org.powertac.common.interfaces.BrokerMessageListener;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.DefaultFactoredCustomer;
import org.powertac.factoredcustomer.FactoredCustomer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Service
public class FactoredCustomerService
extends TimeslotPhaseProcessor
implements BrokerMessageListener,
NewTariffListener {
    private static Logger log = Logger.getLogger((String)FactoredCustomerService.class.getName());
    @Autowired
    TariffMarket tariffMarketService;
    @Autowired
    protected RandomSeedRepo randomSeedRepo;
    String configResource = null;
    List<CustomerProfile> customerProfiles = new ArrayList<CustomerProfile>();
    List<FactoredCustomer> customers = new ArrayList<FactoredCustomer>();
    CustomerFactory customerFactory = new CustomerFactory();

    public FactoredCustomerService() {
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
    }

    void init(PluginConfig config) {
        this.customerProfiles.clear();
        this.customers.clear();
        super.init();
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.configResource = config.getConfigurationValue("configResource");
        this.loadCustomerProfiles(this.configResource);
        this.customerFactory.registerDefaultCreator(DefaultFactoredCustomer.getCreator());
        log.info((Object)"Creating factored customers from configuration profiles.");
        for (CustomerProfile customerProfile : this.customerProfiles) {
            FactoredCustomer customer = this.customerFactory.processProfile(customerProfile);
            if (customer != null) {
                this.customers.add(customer);
                customer.subscribeDefault();
                continue;
            }
            throw new Error("Could not create factored customer for profile: " + customerProfile.name);
        }
        log.info((Object)"Successfully initialized factored customers from configuration profiles.");
    }

    protected void loadCustomerProfiles(String configResource) {
        log.info((Object)("Attempting to load factored customer profiles from config resource: " + configResource));
        try {
            InputStream configStream = ClassLoader.getSystemClassLoader().getResourceAsStream(configResource);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(configStream);
            NodeList profileNodes = doc.getElementsByTagName("profile");
            int numProfiles = profileNodes.getLength();
            log.info((Object)("Loading " + numProfiles + " factored customer profiles."));
            for (int i = 0; i < numProfiles; ++i) {
                Element profileElement = (Element)profileNodes.item(i);
                CustomerProfile profile = new CustomerProfile(profileElement);
                this.customerProfiles.add(profile);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading factored customer profiles from config resourcee: " + configResource + "; exception = " + e.toString()));
            throw new Error(e);
        }
        log.info((Object)"Successfully loaded factored customer profiles.");
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        for (FactoredCustomer customer : this.customers) {
            customer.handleNewTariffs(tariffs);
        }
    }

    public void activate(Instant now, int phase) {
        for (FactoredCustomer customer : this.customers) {
            customer.handleNewTimeslot();
        }
    }

    public void receiveMessage(Object msg) {
    }

    public String getConfigResource() {
        return this.configResource;
    }

    public void setConfigResource(String resource) {
        this.configResource = resource;
    }

    public List<FactoredCustomer> getCustomers() {
        return this.customers;
    }
}

