/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import org.powertac.factoredcustomer.DistributionSamplerBase;
import org.powertac.factoredcustomer.DistributionSamplerDegenerate;
import org.powertac.factoredcustomer.DistributionSamplerInterval;
import org.powertac.factoredcustomer.DistributionSamplerNormal;
import org.powertac.factoredcustomer.DistributionSamplerUniform;
import org.w3c.dom.Element;

class ProbabilityDistribution {
    DistributionType distributionType;
    long seed;
    DistributionSamplerBase sampler;

    ProbabilityDistribution(Element xml, long randomSeed) {
        this.seed = randomSeed;
        this.distributionType = Enum.valueOf(DistributionType.class, xml.getAttribute("probability"));
        switch (this.distributionType) {
            case POINTMASS: 
            case DEGENERATE: {
                double value = Double.parseDouble(xml.getAttribute("value"));
                this.sampler = new DistributionSamplerDegenerate(value);
                break;
            }
            case UNIFORM: {
                double low = Double.parseDouble(xml.getAttribute("low"));
                double high = Double.parseDouble(xml.getAttribute("high"));
                this.sampler = new DistributionSamplerUniform(low, high);
                break;
            }
            case NORMAL: 
            case GAUSSIAN: {
                double mean = Double.parseDouble(xml.getAttribute("mean"));
                double stdDev = Double.parseDouble(xml.getAttribute("stdDev"));
                this.sampler = new DistributionSamplerNormal(mean, stdDev);
                break;
            }
            case LOGNORMAL: {
                double expMean = Math.log(Double.parseDouble(xml.getAttribute("expMean")));
                double expStdDev = Math.log(Double.parseDouble(xml.getAttribute("expStdDev")));
                this.sampler = new DistributionSamplerNormal(expMean, expStdDev);
                break;
            }
            case Z: 
            case STDNORMAL: {
                this.sampler = new DistributionSamplerNormal(0.0, 1.0);
                break;
            }
            case INTERVAL: {
                double imean = Double.parseDouble(xml.getAttribute("mean"));
                double istdDev = Double.parseDouble(xml.getAttribute("stdDev"));
                double ilow = Double.parseDouble(xml.getAttribute("low"));
                double ihigh = Double.parseDouble(xml.getAttribute("high"));
                this.sampler = new DistributionSamplerInterval(imean, istdDev, ilow, ihigh);
                break;
            }
            default: {
                throw new Error("Shouldn't be getting to unknown distributionType: " + (Object)((Object)this.distributionType));
            }
        }
        this.sampler.init(this.seed);
    }

    double drawSample() {
        switch (this.distributionType) {
            case LOGNORMAL: {
                return Math.exp(this.sampler.sample());
            }
        }
        return this.sampler.sample();
    }

    public String toString() {
        return "ProbabilityDistribution(distributionType: " + (Object)((Object)this.distributionType) + ", seed: " + this.seed;
    }

    static enum DistributionType {
        DEGENERATE,
        POINTMASS,
        UNIFORM,
        NORMAL,
        GAUSSIAN,
        LOGNORMAL,
        Z,
        STDNORMAL,
        INTERVAL;

    }
}

