/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.factoredcustomer.CapacityManager;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.TariffSubscriberProfile;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class CapacityBundle {
    private TimeslotRepo timeslotRepo;
    private static final int NUM_HOURS_IN_DAY = 24;
    private final Element configXml;
    private final CapacityProfile.CapacityType capacityType;
    private final CapacityProfile.CapacitySubType capacitySubType;
    private final TariffSubscriberProfile subscriberProfile;
    private final List<CapacityManager> capacityManagers = new ArrayList<CapacityManager>();

    CapacityBundle(CustomerProfile profile, Element xml) {
        this.configXml = xml;
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.capacityType = Enum.valueOf(CapacityProfile.CapacityType.class, xml.getAttribute("type"));
        this.capacitySubType = Enum.valueOf(CapacityProfile.CapacitySubType.class, xml.getAttribute("subType"));
        Element tariffSubscriberElement = (Element)xml.getElementsByTagName("tariffSubscriber").item(0);
        this.subscriberProfile = new TariffSubscriberProfile(profile, this, tariffSubscriberElement);
        NodeList capacityNodes = xml.getElementsByTagName("capacity");
        for (int i = 0; i < capacityNodes.getLength(); ++i) {
            Element capacityElement = (Element)capacityNodes.item(i);
            this.capacityManagers.add(new CapacityManager(profile, this, capacityElement));
        }
    }

    double computeDailyUsageCharge(Tariff tariff) {
        Timeslot hourlyTimeslot = this.timeslotRepo.currentTimeslot();
        double totalUsage = 0.0;
        double totalCharge = 0.0;
        for (int i = 0; i < 24; ++i) {
            double hourlyUsage = 0.0;
            for (CapacityManager capacityManager : this.capacityManagers) {
                hourlyUsage += capacityManager.getBaseCapacity(hourlyTimeslot);
            }
            totalCharge += tariff.getUsageCharge(hourlyTimeslot.getStartInstant(), hourlyUsage, totalUsage);
            totalUsage += hourlyUsage;
            hourlyTimeslot = hourlyTimeslot.getNext();
        }
        return totalCharge;
    }

    double useCapacity(Timeslot timeslot, TariffSubscription subscription) {
        double capacity = 0.0;
        for (CapacityManager capacityManager : this.capacityManagers) {
            capacity += capacityManager.useCapacity(timeslot, subscription);
        }
        return capacity;
    }

    CapacityProfile.CapacityType getCapacityType() {
        return this.capacityType;
    }

    CapacityProfile.CapacitySubType getCapacitySubType() {
        return this.capacitySubType;
    }

    List<CapacityManager> getCapacityManagers() {
        return this.capacityManagers;
    }

    public Element getConfigXml() {
        return this.configXml;
    }

    public TariffSubscriberProfile getSubscriberProfile() {
        return this.subscriberProfile;
    }
}

