/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.Map;
import org.powertac.common.enumerations.PowerType;
import org.powertac.factoredcustomer.CapacityBundle;
import org.powertac.factoredcustomer.ParserFunctions;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.powertac.factoredcustomer.TimeseriesProfile;
import org.w3c.dom.Element;

final class CapacityProfile {
    final String capacityId;
    final String description;
    final CapacityBundle parentBundle;
    final BaseCapacityType baseCapacityType;
    final ProbabilityDistribution basePopulationCapacity;
    final ProbabilityDistribution baseIndividualCapacity;
    final TimeseriesProfile baseTimeseriesProfile;
    final double[] dailySkew;
    final double[] hourlySkew;
    final InfluenceKind temperatureInfluence;
    final Map<Integer, Double> temperatureMap = new HashMap<Integer, Double>();
    final double temperatureReference;
    final InfluenceKind windSpeedInfluence;
    final Map<Integer, Double> windSpeedMap = new HashMap<Integer, Double>();
    final InfluenceKind windDirectionInfluence;
    final Map<Integer, Double> windDirectionMap = new HashMap<Integer, Double>();
    final InfluenceKind cloudCoverInfluence;
    final Map<Integer, Double> cloudCoverMap = new HashMap<Integer, Double>();
    final Map<Integer, Double> benchmarkRates = new HashMap<Integer, Double>();
    final ElasticityModelType elasticityModelType;
    final Element elasticityModelXml;

    CapacityProfile(Element xml, CapacityBundle bundle) {
        this.capacityId = xml.getAttribute("id");
        this.description = xml.getAttribute("description");
        this.parentBundle = bundle;
        Element baseCapacityElement = (Element)xml.getElementsByTagName("baseCapacity").item(0);
        this.baseCapacityType = Enum.valueOf(BaseCapacityType.class, baseCapacityElement.getAttribute("type"));
        switch (this.baseCapacityType) {
            case POPULATION: {
                Element populationCapacityElement = (Element)baseCapacityElement.getElementsByTagName("populationCapacity").item(0);
                this.basePopulationCapacity = new ProbabilityDistribution(populationCapacityElement);
                this.baseIndividualCapacity = null;
                this.baseTimeseriesProfile = null;
                break;
            }
            case INDIVIDUAL: {
                this.basePopulationCapacity = null;
                Element individualCapacityElement = (Element)baseCapacityElement.getElementsByTagName("individualCapacity").item(0);
                this.baseIndividualCapacity = new ProbabilityDistribution(individualCapacityElement);
                this.baseTimeseriesProfile = null;
                break;
            }
            case TIMESERIES: {
                this.basePopulationCapacity = null;
                this.baseIndividualCapacity = null;
                Element timeseriesModelElement = (Element)baseCapacityElement.getElementsByTagName("timeseriesModel").item(0);
                this.baseTimeseriesProfile = new TimeseriesProfile(timeseriesModelElement);
                break;
            }
            default: {
                throw new Error("Unexpected base capacity type: " + (Object)((Object)this.baseCapacityType));
            }
        }
        Element dailySkewElement = (Element)xml.getElementsByTagName("dailySkew").item(0);
        this.dailySkew = ParserFunctions.parseDoubleArray(dailySkewElement.getAttribute("array"));
        Element hourlySkewElement = (Element)xml.getElementsByTagName("hourlySkew").item(0);
        this.hourlySkew = ParserFunctions.parseDoubleArray(hourlySkewElement.getAttribute("array"));
        Element temperatureInfluenceElement = (Element)xml.getElementsByTagName("temperature").item(0);
        this.temperatureInfluence = Enum.valueOf(InfluenceKind.class, temperatureInfluenceElement.getAttribute("influence"));
        if (this.temperatureInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(temperatureInfluenceElement.getAttribute("rangeMap"), this.temperatureMap);
            this.temperatureReference = this.temperatureInfluence == InfluenceKind.DEVIATION ? Double.parseDouble(temperatureInfluenceElement.getAttribute("reference")) : Double.NaN;
        } else {
            this.temperatureReference = Double.NaN;
        }
        Element windSpeedInfluenceElement = (Element)xml.getElementsByTagName("windSpeed").item(0);
        this.windSpeedInfluence = Enum.valueOf(InfluenceKind.class, windSpeedInfluenceElement.getAttribute("influence"));
        if (this.windSpeedInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(windSpeedInfluenceElement.getAttribute("rangeMap"), this.windSpeedMap);
        }
        Element windDirectionInfluenceElement = (Element)xml.getElementsByTagName("windDirection").item(0);
        this.windDirectionInfluence = Enum.valueOf(InfluenceKind.class, windDirectionInfluenceElement.getAttribute("influence"));
        if (this.windDirectionInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(windDirectionInfluenceElement.getAttribute("rangeMap"), this.windDirectionMap);
        }
        Element cloudCoverInfluenceElement = (Element)xml.getElementsByTagName("cloudCover").item(0);
        this.cloudCoverInfluence = Enum.valueOf(InfluenceKind.class, cloudCoverInfluenceElement.getAttribute("influence"));
        if (this.cloudCoverInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(cloudCoverInfluenceElement.getAttribute("rangeMap"), this.cloudCoverMap);
        }
        Element priceElasticityElement = (Element)xml.getElementsByTagName("priceElasticity").item(0);
        Element benchmarkRatesElement = (Element)priceElasticityElement.getElementsByTagName("benchmarkRates").item(0);
        ParserFunctions.parseRangeMap(benchmarkRatesElement.getAttribute("rangeMap"), this.benchmarkRates);
        this.elasticityModelXml = (Element)priceElasticityElement.getElementsByTagName("elasticityModel").item(0);
        this.elasticityModelType = Enum.valueOf(ElasticityModelType.class, this.elasticityModelXml.getAttribute("type"));
    }

    static PowerType reportPowerType(CapacityType capacityType, CapacitySubType capacitySubType) {
        switch (capacityType) {
            case CONSUMPTION: {
                switch (capacitySubType) {
                    case NONE: {
                        return PowerType.CONSUMPTION;
                    }
                    case INTERRUPTIBLE: {
                        return PowerType.INTERRUPTIBLE_CONSUMPTION;
                    }
                    case THERMAL_STORAGE: {
                        return PowerType.INTERRUPTIBLE_CONSUMPTION;
                    }
                }
                throw new Error("Incompatible capacity subType: " + (Object)((Object)capacitySubType));
            }
            case PRODUCTION: {
                switch (capacitySubType) {
                    case NONE: {
                        return PowerType.PRODUCTION;
                    }
                    case SOLAR: {
                        return PowerType.SOLAR_PRODUCTION;
                    }
                    case WIND: {
                        return PowerType.WIND_PRODUCTION;
                    }
                    case RUN_OF_RIVER: {
                        return PowerType.RUN_OF_RIVER_PRODUCTION;
                    }
                    case PUMPED_STORAGE: {
                        return PowerType.PUMPED_STORAGE_PRODUCTION;
                    }
                    case CHP: {
                        return PowerType.CHP_PRODUCTION;
                    }
                    case FOSSIL: {
                        return PowerType.FOSSIL_PRODUCTION;
                    }
                }
                throw new Error("Incompatible capacity subType: " + (Object)((Object)capacitySubType));
            }
            case STORAGE: {
                switch (capacitySubType) {
                    case BATTERY_STORAGE: {
                        return PowerType.BATTERY_STORAGE;
                    }
                    case ELECTRIC_VEHICLE: {
                        return PowerType.ELECTRIC_VEHICLE;
                    }
                }
                throw new Error("Incompatible capacity subType: " + (Object)((Object)capacitySubType));
            }
        }
        throw new Error("Incompatible capacity type: " + (Object)((Object)capacityType));
    }

    static CapacityType reportCapacityType(PowerType powerType) {
        if (powerType.isConsumption()) {
            return CapacityType.CONSUMPTION;
        }
        if (powerType.isProduction()) {
            return CapacityType.PRODUCTION;
        }
        if (powerType.isStorage()) {
            return CapacityType.STORAGE;
        }
        throw new Error("Unexpected powerType: " + powerType);
    }

    static enum ElasticityModelType {
        CONTINUOUS,
        STEPWISE;

    }

    static enum BaseCapacityType {
        POPULATION,
        INDIVIDUAL,
        TIMESERIES;

    }

    static enum InfluenceKind {
        DIRECT,
        DEVIATION,
        NONE;

    }

    static enum CapacitySubType {
        NONE,
        INTERRUPTIBLE,
        THERMAL_STORAGE,
        SOLAR,
        WIND,
        RUN_OF_RIVER,
        PUMPED_STORAGE,
        CHP,
        FOSSIL,
        BATTERY_STORAGE,
        ELECTRIC_VEHICLE;

    }

    static enum CapacityType {
        CONSUMPTION,
        PRODUCTION,
        STORAGE;

    }
}

