/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.powertac.common.Tariff;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.factoredcustomer.CustomerProfile;

@Domain
final class CustomerFactory {
    CustomerCreator defaultCreator;
    Map<String, CustomerCreator> customerCreators = new HashMap<String, CustomerCreator>();

    CustomerFactory() {
    }

    @StateChange
    void registerDefaultCreator(CustomerCreator creator) {
        this.defaultCreator = creator;
    }

    @StateChange
    void registerCreator(CustomerCreator creator) {
        this.registerCreator(creator.getKey(), creator);
    }

    @StateChange
    void registerCreator(String key, CustomerCreator creator) {
        this.customerCreators.put(key, creator);
    }

    Customer processProfile(CustomerProfile profile) {
        CustomerCreator creator = this.customerCreators.get(profile.creatorKey);
        if (creator == null) {
            creator = this.defaultCreator;
        }
        return creator.createModel(profile);
    }

    public static interface CustomerCreator {
        public String getKey();

        public Customer createModel(CustomerProfile var1);
    }

    static interface Customer {
        public void handleNewTariffs(List<Tariff> var1);

        public void handleNewTimeslot();
    }
}

