/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import org.powertac.common.CustomerInfo;
import org.powertac.common.enumerations.PowerType;
import org.powertac.factoredcustomer.CapacityProfile;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

final class CustomerProfile {
    private final Element configXml;
    private static long profileCounter = 0L;
    final long profileId = ++profileCounter;
    final String name;
    final String creatorKey;
    final EntityType entityType;
    final CustomerInfo customerInfo;

    CustomerProfile(Element xml) {
        this.configXml = xml;
        this.name = xml.getAttribute("name");
        this.creatorKey = xml.getAttribute("creatorKey");
        Element infoElement = (Element)xml.getElementsByTagName("info").item(0);
        int population = Integer.parseInt(infoElement.getAttribute("population"));
        this.customerInfo = new CustomerInfo(this.name, population).withMultiContracting(Boolean.parseBoolean(infoElement.getAttribute("multiContracting"))).withCanNegotiate(Boolean.parseBoolean(infoElement.getAttribute("canNegotiate")));
        this.entityType = Enum.valueOf(EntityType.class, infoElement.getAttribute("entityType"));
        NodeList capacityBundles = xml.getElementsByTagName("capacityBundle");
        for (int i = 0; i < capacityBundles.getLength(); ++i) {
            Element capacityBundle = (Element)capacityBundles.item(i);
            CapacityProfile.CapacityType capacityType = Enum.valueOf(CapacityProfile.CapacityType.class, capacityBundle.getAttribute("type"));
            CapacityProfile.CapacitySubType capacitySubType = Enum.valueOf(CapacityProfile.CapacitySubType.class, capacityBundle.getAttribute("subType"));
            PowerType powerType = CapacityProfile.reportPowerType(capacityType, capacitySubType);
            if (this.customerInfo.getPowerTypes().contains(powerType)) continue;
            this.customerInfo.addPowerType(powerType);
        }
    }

    public Element getConfigXml() {
        return this.configXml;
    }

    static enum EntityType {
        RESIDENTIAL,
        COMMERCIAL,
        INDUSTRIAL;

    }
}

