/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CapacityBundle;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.UtilityOptimizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Domain
class FactoredCustomer
implements CustomerFactory.Customer {
    private static Logger log = Logger.getLogger((String)FactoredCustomer.class.getName());
    private TimeslotRepo timeslotRepo;
    protected CustomerRepo customerRepo;
    private static Creator creator = new Creator();
    private final CustomerProfile customerProfile;
    private final UtilityOptimizer utilityOptimizer;
    private final List<CapacityBundle> capacityBundles = new ArrayList<CapacityBundle>();

    public static Creator getCreator() {
        return creator;
    }

    FactoredCustomer(CustomerProfile profile) {
        this.customerProfile = profile;
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.customerRepo = (CustomerRepo)SpringApplicationContext.getBean((String)"customerRepo");
        this.customerRepo.add(profile.customerInfo);
        NodeList capacityBundleNodes = this.customerProfile.getConfigXml().getElementsByTagName("capacityBundle");
        for (int i = 0; i < capacityBundleNodes.getLength(); ++i) {
            Element capacityBundleElement = (Element)capacityBundleNodes.item(i);
            this.capacityBundles.add(new CapacityBundle(profile, capacityBundleElement));
        }
        this.utilityOptimizer = new UtilityOptimizer(profile, this.capacityBundles);
        log.info((Object)("Customer created for profile: " + this.customerProfile.name));
    }

    @Override
    public void handleNewTariffs(List<Tariff> newTariffs) {
        Timeslot timeslot = this.timeslotRepo.currentTimeslot();
        log.info((Object)("Customer " + this.getName() + " received " + newTariffs.size() + " new tariffs at timeslot " + timeslot.getSerialNumber()));
        this.utilityOptimizer.handleNewTariffs(newTariffs);
    }

    @Override
    public void handleNewTimeslot() {
        Timeslot timeslot = this.timeslotRepo.currentTimeslot();
        log.info((Object)("Customer " + this.getName() + " activated for timeslot " + timeslot.getSerialNumber()));
        this.utilityOptimizer.handleNewTimeslot(timeslot);
    }

    String getName() {
        return this.customerProfile.name;
    }

    CustomerProfile getCustomerProfile() {
        return this.customerProfile;
    }

    CustomerInfo getCustomerInfo() {
        return this.customerProfile.customerInfo;
    }

    int getPopulation() {
        return this.getCustomerInfo().getPopulation();
    }

    public String toString() {
        return "FactoredCustomer:" + this.getName();
    }

    public static class Creator
    implements CustomerFactory.CustomerCreator {
        @Override
        public String getKey() {
            return null;
        }

        @Override
        public CustomerFactory.Customer createModel(CustomerProfile profile) {
            return new FactoredCustomer(profile);
        }
    }
}

