/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.Tariff;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.BrokerMessageListener;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.FactoredCustomer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Service
public class FactoredCustomerService
extends TimeslotPhaseProcessor
implements InitializationService,
BrokerMessageListener,
NewTariffListener {
    private static Logger log = Logger.getLogger((String)FactoredCustomerService.class.getName());
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private ServerConfiguration serverConfig;
    @ConfigurableValue(valueType="String", description="Resource name for configuration data")
    private String configResource = null;
    private List<CustomerProfile> customerProfiles = new ArrayList<CustomerProfile>();
    private List<CustomerFactory.Customer> customers = new ArrayList<CustomerFactory.Customer>();
    private CustomerFactory customerFactory = new CustomerFactory();

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        if (!completedInits.contains("DefaultBroker") || !completedInits.contains("TariffMarket")) {
            log.debug((Object)"Waiting for DefaultBroker to initialize");
            return null;
        }
        this.customerProfiles.clear();
        this.customers.clear();
        super.init();
        this.serverConfig.configureMe((Object)this);
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.loadCustomerProfiles(this.configResource);
        this.customerFactory.registerDefaultCreator(FactoredCustomer.getCreator());
        log.info((Object)"Creating factored customers from configuration profiles.");
        for (CustomerProfile customerProfile : this.customerProfiles) {
            CustomerFactory.Customer customer = this.customerFactory.processProfile(customerProfile);
            if (customer != null) {
                this.customers.add(customer);
                continue;
            }
            throw new Error("Could not create factored customer for profile: " + customerProfile.name);
        }
        log.info((Object)"Successfully initialized factored customers from configuration profiles.");
        return "FactoredCustomer";
    }

    protected void loadCustomerProfiles(String configResource) {
        log.info((Object)("Attempting to load factored customer profiles from config resource: " + configResource));
        try {
            InputStream configStream = ClassLoader.getSystemClassLoader().getResourceAsStream(configResource);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(configStream);
            NodeList profileNodes = doc.getElementsByTagName("customer");
            int numProfiles = profileNodes.getLength();
            log.info((Object)("Loading " + numProfiles + " factored customer profiles."));
            for (int i = 0; i < numProfiles; ++i) {
                Element profileElement = (Element)profileNodes.item(i);
                CustomerProfile profile = new CustomerProfile(profileElement);
                this.customerProfiles.add(profile);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading factored customer profiles from config resourcee: " + configResource + "; exception = " + e.toString()));
            throw new Error(e);
        }
        log.info((Object)"Successfully loaded factored customer profiles.");
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        for (CustomerFactory.Customer customer : this.customers) {
            customer.handleNewTariffs(tariffs);
        }
    }

    public void activate(Instant now, int phase) {
        for (CustomerFactory.Customer customer : this.customers) {
            customer.handleNewTimeslot();
        }
    }

    public void receiveMessage(Object msg) {
        log.warn((Object)("Ignoring received message: " + msg));
    }

    String getConfigResource() {
        return this.configResource;
    }

    void setConfigResource(String resource) {
        this.configResource = resource;
    }

    List<CustomerFactory.Customer> getCustomers() {
        return this.customers;
    }
}

