/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import org.powertac.factoredcustomer.CapacityBundle;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class TariffSubscriberProfile {
    private final CustomerProfile customerProfile;
    private final CapacityBundle capacityBundle;
    private final Element configXml;
    final AllocationMethod allocationMethod;
    final List<List<Double>> totalOrderRules = new ArrayList<List<Double>>();
    final double logitChoiceRationality;
    final int reconsiderationPeriod;
    final ProbabilityDistribution inertiaDistribution;
    final ProbabilityDistribution customerWealthDistribution;
    final double customerWealthReferenceMedian;
    final ProbabilityDistribution newTariffsExposure;
    final ProbabilityDistribution switchingDelay;
    final ProbabilityDistribution waitAfterSwitch;

    TariffSubscriberProfile(CustomerProfile profile, CapacityBundle bundle, Element xml) {
        this.customerProfile = profile;
        this.capacityBundle = bundle;
        this.configXml = xml;
        Element allocationElement = (Element)xml.getElementsByTagName("allocation").item(0);
        this.allocationMethod = Enum.valueOf(AllocationMethod.class, allocationElement.getAttribute("method"));
        if (this.allocationMethod == AllocationMethod.TOTAL_ORDER) {
            Element totalOrderElement = (Element)allocationElement.getElementsByTagName("totalOrder").item(0);
            this.populateTotalOrderRules(totalOrderElement.getAttribute("rules"));
            this.logitChoiceRationality = 1.0;
        } else {
            Element logitChoiceElement = (Element)allocationElement.getElementsByTagName("logitChoice").item(0);
            this.logitChoiceRationality = Double.parseDouble(logitChoiceElement.getAttribute("rationality"));
        }
        Element reconsiderationElement = (Element)xml.getElementsByTagName("reconsideration").item(0);
        this.reconsiderationPeriod = Integer.parseInt(reconsiderationElement.getAttribute("period"));
        Element inertiaElement = (Element)xml.getElementsByTagName("switchingInertia").item(0);
        Node inertiaDistributionNode = inertiaElement.getElementsByTagName("inertiaDistribution").item(0);
        if (inertiaDistributionNode != null) {
            Element inertiaDistributionElement = (Element)inertiaDistributionNode;
            this.inertiaDistribution = new ProbabilityDistribution(inertiaDistributionElement);
            this.customerWealthDistribution = null;
            this.customerWealthReferenceMedian = 0.0;
            this.newTariffsExposure = null;
            this.switchingDelay = null;
            this.waitAfterSwitch = null;
        } else {
            this.inertiaDistribution = null;
            Node inertiaFactorsNode = inertiaElement.getElementsByTagName("inertiaFactors").item(0);
            if (inertiaFactorsNode == null) {
                throw new Error("TariffSubscriberProfile(): Inertia distribution and factors are both undefined!");
            }
            Element inertiaFactorsElement = (Element)inertiaFactorsNode;
            Element customerWealthElement = (Element)inertiaFactorsElement.getElementsByTagName("customerWealth").item(0);
            this.customerWealthDistribution = new ProbabilityDistribution(customerWealthElement);
            this.customerWealthReferenceMedian = Double.parseDouble(customerWealthElement.getAttribute("referenceMedian"));
            Element newTariffsExposureElement = (Element)inertiaFactorsElement.getElementsByTagName("newTariffsExposure").item(0);
            this.newTariffsExposure = new ProbabilityDistribution(newTariffsExposureElement);
            Element switchingDelayElement = (Element)inertiaFactorsElement.getElementsByTagName("switchingDelay").item(0);
            this.switchingDelay = new ProbabilityDistribution(switchingDelayElement);
            Element waitAfterSwitchElement = (Element)inertiaFactorsElement.getElementsByTagName("waitAfterSwitch").item(0);
            this.waitAfterSwitch = new ProbabilityDistribution(waitAfterSwitchElement);
        }
    }

    private void populateTotalOrderRules(String config) {
        String[] rules = config.split(",");
        ArrayList<Double> degenerateRule = new ArrayList<Double>(1);
        degenerateRule.add(1.0);
        this.totalOrderRules.add(degenerateRule);
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i].length() <= 0) continue;
            String[] vals = rules[i].split(":");
            ArrayList<Double> rule = new ArrayList<Double>(vals.length);
            for (int j = 0; j < vals.length; ++j) {
                rule.add(Double.parseDouble(vals[j]));
            }
            this.totalOrderRules.add(rule);
        }
    }

    CustomerProfile getCustomerProfile() {
        return this.customerProfile;
    }

    CapacityBundle getCapacityBundle() {
        return this.capacityBundle;
    }

    Element getConfigXml() {
        return this.configXml;
    }

    static enum AllocationMethod {
        TOTAL_ORDER,
        LOGIT_CHOICE;

    }
}

