/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.powertac.common.Timeslot;
import org.powertac.factoredcustomer.ParserFunctions;
import org.powertac.factoredcustomer.TimeseriesProfile;

final class TimeseriesGenerator {
    private final Properties modelParams = new Properties();
    private final List<Double> refSeries = new ArrayList<Double>();
    private final Map<Integer, Double> genSeries = new HashMap<Integer, Double>();
    private final TimeseriesProfile tsProfile;
    private final int FORECAST_HORIZON = 48;
    private double Y0;
    private double[] Yd;
    private double[] Yh;
    private double phi1;
    private double Phi1;
    private double theta1;
    private double Theta1;
    private double lambda;
    private double gamma;

    TimeseriesGenerator(TimeseriesProfile profile) {
        this.tsProfile = profile;
        switch (this.tsProfile.modelType) {
            case ARIMA_101x101: {
                this.initArima101x101();
                break;
            }
            default: {
                throw new Error("Unexpected timeseries model type: " + (Object)((Object)this.tsProfile.modelType));
            }
        }
    }

    void initArima101x101() {
        this.initArima101x101ModelParams();
        this.initArima101x101RefSeries();
    }

    void initArima101x101ModelParams() {
        InputStream paramsStream;
        String paramsName = this.tsProfile.modelParamsName;
        switch (this.tsProfile.modelParamsSource) {
            case BUILTIN: {
                throw new Error("Unknown builtin model parameters with name: " + paramsName);
            }
            case CLASSPATH: {
                paramsStream = ClassLoader.getSystemClassLoader().getResourceAsStream(paramsName);
                break;
            }
            case FILEPATH: {
                try {
                    paramsStream = new FileInputStream(paramsName);
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new Error("Could not find file to initialize model parameters: " + paramsName);
                }
            }
            default: {
                throw new Error("Unexpected reference timeseries source type: " + (Object)((Object)this.tsProfile.refSeriesSource));
            }
        }
        if (paramsStream == null) {
            throw new Error("Model parameters input stream is uninitialized!");
        }
        try {
            this.modelParams.load(paramsStream);
        }
        catch (IOException e) {
            throw new Error("Error reading model parameters from file: " + paramsName + "; caught IOException: " + e.toString());
        }
        this.Y0 = Double.parseDouble((String)this.modelParams.get("Y0"));
        this.Yd = ParserFunctions.parseDoubleArray((String)this.modelParams.get("Yd"));
        this.Yh = ParserFunctions.parseDoubleArray((String)this.modelParams.get("Yh"));
        this.phi1 = Double.parseDouble((String)this.modelParams.get("phi1"));
        this.Phi1 = Double.parseDouble((String)this.modelParams.get("Phi1"));
        this.theta1 = Double.parseDouble((String)this.modelParams.get("theta1"));
        this.Theta1 = Double.parseDouble((String)this.modelParams.get("Theta1"));
        this.lambda = Double.parseDouble((String)this.modelParams.get("lambda"));
        this.gamma = Double.parseDouble((String)this.modelParams.get("gamma"));
    }

    void initArima101x101RefSeries() {
        InputStream refStream;
        String seriesName = this.tsProfile.refSeriesName;
        switch (this.tsProfile.refSeriesSource) {
            case BUILTIN: {
                throw new Error("Unknown builtin series name: " + seriesName);
            }
            case CLASSPATH: {
                refStream = ClassLoader.getSystemClassLoader().getResourceAsStream(seriesName);
                break;
            }
            case FILEPATH: {
                try {
                    refStream = new FileInputStream(seriesName);
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new Error("Could not find file to initialize reference timeseries: " + seriesName);
                }
            }
            default: {
                throw new Error("Unexpected reference timeseries source type: " + (Object)((Object)this.tsProfile.refSeriesSource));
            }
        }
        if (refStream == null) {
            throw new Error("Reference timeseries input stream is uninitialized!");
        }
        try {
            List series = IOUtils.readLines((InputStream)refStream);
            for (String line : series) {
                Double element = Double.parseDouble(line);
                this.refSeries.add(element);
            }
        }
        catch (EOFException e) {
            int MIN_TIMESERIES_LENGTH = 26;
            if (this.refSeries.size() < 26) {
                throw new Error("Insufficient data in reference series; expected 26 elements, found only " + this.genSeries.size());
            }
        }
        catch (IOException e) {
            throw new Error("Error reading timeseries data from file: " + seriesName + "; caught IOException: " + e.toString());
        }
    }

    double generateNext(Timeslot timeslot) {
        Double next;
        switch (this.tsProfile.modelType) {
            case ARIMA_101x101: {
                if (this.genSeries.isEmpty()) {
                    this.initArima101x101GenSeries(timeslot);
                }
                if ((next = this.genSeries.get(timeslot.getSerialNumber())) != null) break;
                next = this.generateNextArima101x101(timeslot);
                this.genSeries.put(timeslot.getSerialNumber(), next);
                break;
            }
            default: {
                throw new Error("Unexpected timeseries model type: " + (Object)((Object)this.tsProfile.modelType));
            }
        }
        return next;
    }

    private void initArima101x101GenSeries(Timeslot timeslot) {
        int start = timeslot.getSerialNumber();
        for (int i = 0; i < this.refSeries.size(); ++i) {
            this.genSeries.put(start + i, this.refSeries.get(i));
        }
    }

    private double generateNextArima101x101(Timeslot timeslot) {
        DateTime now = timeslot.getStartInstant().toDateTime();
        int day = now.getDayOfWeek();
        int hour = now.getHourOfDay();
        int t = timeslot.getSerialNumber();
        double logNext = this.Y0 + this.Yd[day - 1] + this.Yh[hour] + this.phi1 * this.getLog(t - 1) + this.Phi1 * this.getLog(t - 24) + this.theta1 * (this.getLog(t - 1) - this.getLog(t - 2)) + this.Theta1 * (this.getLog(t - 24) - this.getLog(t - 25)) + this.theta1 * this.Theta1 * (this.getLog(t - 25) - this.getLog(t - 26));
        double next = Math.exp(logNext += this.lambda * (Math.pow(Math.log(t - 26), 2.0) / Math.pow(Math.log(22.0), 2.0)) * ((1.0 - this.gamma) * this.Yh[hour] + this.gamma * this.Yd[day - 1]));
        if (Double.isNaN(next)) {
            throw new Error("Generated NaN as next time series element!");
        }
        return next;
    }

    private double getLog(int timeslot) {
        return Math.log(this.genSeries.get(timeslot));
    }

    static enum DataSource {
        BUILTIN,
        CLASSPATH,
        FILEPATH;

    }

    static enum ModelType {
        ARIMA_101x101;

    }
}

