/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.powertac.common.CustomerInfo;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.factoredcustomer.CapacityBundle;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerProfile;
import org.powertac.factoredcustomer.TariffSubscriberProfile;

@Domain
class UtilityOptimizer {
    private static Logger log = Logger.getLogger((String)UtilityOptimizer.class.getName());
    protected TariffMarket tariffMarketService;
    protected TariffSubscriptionRepo tariffSubscriptionRepo;
    protected TimeslotRepo timeslotRepo;
    private RandomSeedRepo randomSeedRepo;
    private static final long MEAN_TARIFF_DURATION = 5L;
    private final CustomerProfile customerProfile;
    private final List<CapacityBundle> capacityBundles;
    private final List<Tariff> ignoredTariffs = new ArrayList<Tariff>();
    private final Random inertiaSampler;
    private final Random tariffSelector;
    private final List<Tariff> allTariffs = new ArrayList<Tariff>();
    private int tariffEvaluationCounter = 0;

    UtilityOptimizer(CustomerProfile profile, List<CapacityBundle> bundles) {
        this.customerProfile = profile;
        this.capacityBundles = bundles;
        this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean((String)"tariffMarketService");
        this.tariffSubscriptionRepo = (TariffSubscriptionRepo)SpringApplicationContext.getBean((String)"tariffSubscriptionRepo");
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.inertiaSampler = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.UtilityOptimizer", this.customerProfile.profileId, "InertiaSampler").getValue());
        this.tariffSelector = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.UtilityOptimizer", this.customerProfile.profileId, "TariffSelector").getValue());
        this.subscribeDefault();
    }

    @StateChange
    protected void subscribe(Tariff tariff, int customerCount, boolean verbose) {
        this.tariffMarketService.subscribeToTariff(tariff, this.getCustomerInfo(), customerCount);
        if (verbose) {
            log.info((Object)(this.getName() + ": Subscribed " + customerCount + " customers to tariff " + tariff.getId() + " successfully"));
        }
    }

    @StateChange
    protected void unsubscribe(TariffSubscription subscription, int customerCount, boolean verbose) {
        subscription.unsubscribe(customerCount);
        if (verbose) {
            log.info((Object)(this.getName() + ": Unsubscribed " + customerCount + " customers from tariff " + subscription.getTariff().getId() + " successfully"));
        }
    }

    public void subscribeDefault() {
        for (CapacityBundle bundle : this.capacityBundles) {
            PowerType powerType = CapacityProfile.reportPowerType(bundle.getCapacityType(), bundle.getCapacitySubType());
            if (this.tariffMarketService.getDefaultTariff(powerType) == null) {
                log.info((Object)(this.getName() + ": No default tariff for power type " + powerType + "; trying less specific type."));
                CapacityProfile.CapacityType capacityType = CapacityProfile.reportCapacityType(powerType);
                PowerType generalType = CapacityProfile.reportPowerType(capacityType, CapacityProfile.CapacitySubType.NONE);
                if (this.tariffMarketService.getDefaultTariff(generalType) == null) {
                    log.error((Object)(this.getName() + ": No default tariff for general power type " + generalType + " either!"));
                    continue;
                }
                log.info((Object)(this.getName() + ": Subscribing " + this.getPopulation() + " customers to default " + generalType + " tariff"));
                this.subscribe(this.tariffMarketService.getDefaultTariff(generalType), this.getPopulation(), false);
                continue;
            }
            log.info((Object)(this.getName() + ": Subscribing " + this.getPopulation() + " customers to default " + powerType + " tariff"));
            this.subscribe(this.tariffMarketService.getDefaultTariff(powerType), this.getPopulation(), false);
        }
    }

    void handleNewTariffs(List<Tariff> newTariffs) {
        ++this.tariffEvaluationCounter;
        for (Tariff tariff : newTariffs) {
            this.allTariffs.add(tariff);
        }
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(this.getCustomerInfo());
        if (subscriptions == null || subscriptions.size() == 0) {
            this.subscribeDefault();
        } else {
            this.evaluateTariffs(newTariffs);
        }
    }

    private void evaluateTariffs(List<Tariff> newTariffs) {
        for (CapacityBundle bundle : this.capacityBundles) {
            if (this.tariffEvaluationCounter % bundle.getSubscriberProfile().reconsiderationPeriod == 0) {
                this.reevaluateAllTariffs(bundle);
                continue;
            }
            this.evaluateCurrentTariffs(newTariffs, bundle);
        }
    }

    private void reevaluateAllTariffs(CapacityBundle bundle) {
        log.info((Object)(this.getName() + ": Reevaluating all tariffs for " + (Object)((Object)bundle.getCapacityType()) + " subscriptions"));
        CapacityProfile.CapacityType capacityType = bundle.getCapacityType();
        ArrayList<Tariff> evalTariffs = new ArrayList<Tariff>();
        for (Tariff tariff : this.allTariffs) {
            if (tariff.isRevoked() || tariff.isExpired() || CapacityProfile.reportCapacityType(tariff.getTariffSpec().getPowerType()) != capacityType) continue;
            evalTariffs.add(tariff);
        }
        this.assertNotEmpty(evalTariffs);
        this.manageSubscriptions(evalTariffs, bundle);
    }

    private void evaluateCurrentTariffs(List<Tariff> newTariffs, CapacityBundle bundle) {
        if (bundle.getSubscriberProfile().inertiaDistribution != null) {
            double inertia = bundle.getSubscriberProfile().inertiaDistribution.drawSample();
            if (this.inertiaSampler.nextDouble() < inertia) {
                log.info((Object)(this.getName() + ": Skipping " + (Object)((Object)bundle.getCapacityType()) + " tariff reevaluation due to inertia"));
                for (Tariff newTariff : newTariffs) {
                    this.ignoredTariffs.add(newTariff);
                }
                return;
            }
        }
        HashMap<Long, Tariff> currTariffs = new HashMap<Long, Tariff>();
        for (Tariff ignoredTariff : this.ignoredTariffs) {
            currTariffs.put(ignoredTariff.getId(), ignoredTariff);
        }
        this.ignoredTariffs.clear();
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(this.getCustomerInfo());
        for (TariffSubscription subscription : subscriptions) {
            currTariffs.put(subscription.getTariff().getId(), subscription.getTariff());
        }
        for (Tariff newTariff : newTariffs) {
            currTariffs.put(newTariff.getId(), newTariff);
        }
        CapacityProfile.CapacityType capacityType = bundle.getCapacityType();
        ArrayList<Tariff> evalTariffs = new ArrayList<Tariff>();
        for (Tariff tariff : currTariffs.values()) {
            if (CapacityProfile.reportCapacityType(tariff.getTariffSpec().getPowerType()) != capacityType) continue;
            evalTariffs.add(tariff);
        }
        this.assertNotEmpty(evalTariffs);
        this.manageSubscriptions(evalTariffs, bundle);
    }

    private void assertNotEmpty(List<Tariff> evalTariffs) {
        if (evalTariffs.isEmpty()) {
            throw new Error(this.getName() + ": The evaluation tariffs list is unexpectedly empty!");
        }
    }

    private void manageSubscriptions(List<Tariff> evalTariffs, CapacityBundle bundle) {
        Collections.shuffle(evalTariffs);
        CapacityProfile.CapacityType capacityType = bundle.getCapacityType();
        ArrayList<Long> tariffIds = new ArrayList<Long>(evalTariffs.size());
        for (Tariff tariff : evalTariffs) {
            tariffIds.add(tariff.getId());
        }
        this.logAllocationDetails(this.getName() + ": " + (Object)((Object)capacityType) + " tariffs for evaluation: " + tariffIds);
        List<Double> estimatedPayments = this.estimatePayments(evalTariffs, bundle);
        this.logAllocationDetails(this.getName() + ": Estimated payments for evaluated tariffs: " + estimatedPayments);
        List<Integer> allocations = this.determineAllocations(evalTariffs, estimatedPayments, bundle);
        this.logAllocationDetails(this.getName() + ": Allocations for evaluated tariffs: " + allocations);
        int overAllocations = 0;
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff evalTariff = evalTariffs.get(i);
            int allocation = allocations.get(i);
            TariffSubscription subscription = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(evalTariff, this.getCustomerInfo());
            int currentCommitted = subscription != null ? subscription.getCustomersCommitted() : 0;
            int numChange = allocation - currentCommitted;
            log.debug((Object)(this.getName() + ": evalTariff = " + evalTariff.getId() + ", numChange = " + numChange + ", currentCommitted = " + currentCommitted + ", allocation = " + allocation));
            if (numChange == 0) {
                if (currentCommitted > 0) {
                    log.info((Object)(this.getName() + ": Maintaining " + currentCommitted + " " + (Object)((Object)capacityType) + " customers in tariff " + evalTariff.getId()));
                    continue;
                }
                log.info((Object)(this.getName() + ": Not allocating any " + (Object)((Object)capacityType) + " customers to tariff " + evalTariff.getId()));
                continue;
            }
            if (numChange > 0) {
                if (evalTariff.isExpired()) {
                    overAllocations += numChange;
                    if (currentCommitted > 0) {
                        log.info((Object)(this.getName() + ": Maintaining " + currentCommitted + " " + (Object)((Object)capacityType) + " customers in expired tariff " + evalTariff.getId()));
                    }
                    log.info((Object)(this.getName() + ": Reallocating " + numChange + " " + (Object)((Object)capacityType) + " customers from expired tariff " + evalTariff.getId() + " to other tariffs"));
                    continue;
                }
                log.info((Object)(this.getName() + ": Subscribing " + numChange + " " + (Object)((Object)capacityType) + " customers to tariff " + evalTariff.getId()));
                this.subscribe(evalTariff, numChange, false);
                continue;
            }
            if (numChange >= 0) continue;
            log.info((Object)(this.getName() + ": Unsubscribing " + -numChange + " " + (Object)((Object)capacityType) + " customers from tariff " + evalTariff.getId()));
            this.unsubscribe(subscription, -numChange, false);
        }
        if (overAllocations > 0) {
            int minIndex = 0;
            double minEstimate = Double.POSITIVE_INFINITY;
            for (int i = 0; i < estimatedPayments.size(); ++i) {
                if (!(estimatedPayments.get(i) < minEstimate) || evalTariffs.get(i).isExpired()) continue;
                minIndex = i;
                minEstimate = estimatedPayments.get(i);
            }
            log.info((Object)(this.getName() + ": Subscribing " + overAllocations + " over-allocated customers to tariff " + evalTariffs.get(minIndex).getId()));
            this.subscribe(evalTariffs.get(minIndex), overAllocations, false);
        }
    }

    private List<Double> estimatePayments(List<Tariff> evalTariffs, CapacityBundle bundle) {
        ArrayList<Double> estimatedPayments = new ArrayList<Double>(evalTariffs.size());
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff tariff = evalTariffs.get(i);
            if (tariff.isExpired()) {
                if (bundle.getCapacityType() == CapacityProfile.CapacityType.CONSUMPTION) {
                    estimatedPayments.add(Double.POSITIVE_INFINITY);
                    continue;
                }
                estimatedPayments.add(Double.NEGATIVE_INFINITY);
                continue;
            }
            double fixedPayments = this.estimateFixedTariffPayments(tariff);
            double variablePayment = bundle.computeDailyUsageCharge(tariff);
            double totalPayment = this.truncateTo2Decimals(fixedPayments + variablePayment);
            estimatedPayments.add(totalPayment);
        }
        return estimatedPayments;
    }

    private double estimateFixedTariffPayments(Tariff tariff) {
        double lifecyclePayment = tariff.getEarlyWithdrawPayment() + tariff.getSignupPayment();
        double minDuration = tariff.getMinDuration() == 0L ? 4.32E8 : (double)tariff.getMinDuration();
        return tariff.getPeriodicPayment() + lifecyclePayment / minDuration;
    }

    private List<Integer> determineAllocations(List<Tariff> evalTariffs, List<Double> estimatedPayments, CapacityBundle bundle) {
        if (evalTariffs.size() == 1) {
            ArrayList<Integer> allocations = new ArrayList<Integer>();
            allocations.add(this.getCustomerInfo().getPopulation());
            return allocations;
        }
        if (bundle.getSubscriberProfile().allocationMethod == TariffSubscriberProfile.AllocationMethod.TOTAL_ORDER) {
            return this.determineTotalOrderAllocations(evalTariffs, estimatedPayments, bundle);
        }
        return this.determineLogitChoiceAllocations(evalTariffs, estimatedPayments, bundle);
    }

    private List<Integer> determineTotalOrderAllocations(List<Tariff> evalTariffs, List<Double> estimatedPayments, CapacityBundle bundle) {
        List<Object> allocationRule;
        int numTariffs = evalTariffs.size();
        if (bundle.getSubscriberProfile().totalOrderRules.isEmpty()) {
            allocationRule = new ArrayList<Double>(numTariffs);
            allocationRule.add(1.0);
            for (int i = 1; i < numTariffs; ++i) {
                allocationRule.add(0.0);
            }
        } else if (numTariffs <= bundle.getSubscriberProfile().totalOrderRules.size()) {
            allocationRule = bundle.getSubscriberProfile().totalOrderRules.get(numTariffs - 1);
        } else {
            allocationRule = new ArrayList(numTariffs);
            List<Double> largestRule = bundle.getSubscriberProfile().totalOrderRules.get(bundle.getSubscriberProfile().totalOrderRules.size() - 1);
            for (int i = 0; i < numTariffs; ++i) {
                if (i < largestRule.size()) {
                    allocationRule.add(largestRule.get(i));
                    continue;
                }
                allocationRule.add(0.0);
            }
        }
        ArrayList<Double> sortedPayments = new ArrayList<Double>(numTariffs);
        for (double estimatedPayment : estimatedPayments) {
            sortedPayments.add(estimatedPayment);
        }
        Collections.sort(sortedPayments);
        Collections.reverse(sortedPayments);
        ArrayList<Integer> allocations = new ArrayList<Integer>(numTariffs);
        for (int i = 0; i < numTariffs; ++i) {
            if ((Double)allocationRule.get(i) > 0.0) {
                double nextBest = (Double)sortedPayments.get(i);
                for (int j = 0; j < numTariffs; ++j) {
                    if (estimatedPayments.get(j) != nextBest) continue;
                    allocations.add((int)Math.round((double)this.getCustomerInfo().getPopulation() * (Double)allocationRule.get(i)));
                }
                continue;
            }
            allocations.add(0);
        }
        return allocations;
    }

    private List<Integer> determineLogitChoiceAllocations(List<Tariff> evalTariffs, List<Double> estimatedPayments, CapacityBundle bundle) {
        int numTariffs = evalTariffs.size();
        double bestPayment = Collections.max(estimatedPayments);
        double worstPayment = Collections.min(estimatedPayments);
        double sumPayments = 0.0;
        for (int i = 0; i < numTariffs; ++i) {
            sumPayments += estimatedPayments.get(i).doubleValue();
        }
        double meanPayment = sumPayments / (double)numTariffs;
        double lambda = bundle.getSubscriberProfile().logitChoiceRationality;
        ArrayList<Double> numerators = new ArrayList<Double>(numTariffs);
        double denominator = 0.0;
        for (int i = 0; i < numTariffs; ++i) {
            double basis = Math.max(bestPayment - meanPayment, meanPayment - worstPayment);
            double utility = (estimatedPayments.get(i) - meanPayment) / basis * 3.0;
            double numerator = Math.exp(lambda * utility);
            numerators.add(numerator);
            denominator += numerator;
        }
        ArrayList<Double> probabilities = new ArrayList<Double>(numTariffs);
        for (int i = 0; i < numTariffs; ++i) {
            probabilities.add((Double)numerators.get(i) / denominator);
        }
        ArrayList<Integer> allocations = new ArrayList<Integer>(numTariffs);
        int population = this.getCustomerInfo().getPopulation();
        if (this.getCustomerInfo().isMultiContracting()) {
            int sumAllocations = 0;
            for (int i = 0; i < numTariffs; ++i) {
                int allocation;
                if (i < numTariffs - 1) {
                    allocation = (int)Math.round((double)population * (Double)probabilities.get(i));
                    sumAllocations += allocation;
                } else {
                    allocation = population - sumAllocations;
                }
                allocations.add(allocation);
            }
        } else {
            double r = (double)this.tariffSelector.nextInt(100) / 100.0;
            double cumProbability = 0.0;
            for (int i = 0; i < numTariffs; ++i) {
                if (r <= (cumProbability += ((Double)probabilities.get(i)).doubleValue())) {
                    allocations.add(population);
                    for (int j = i + 1; j < numTariffs; ++j) {
                        allocations.add(0);
                    }
                    break;
                }
                allocations.add(0);
            }
        }
        return allocations;
    }

    public void handleNewTimeslot(Timeslot timeslot) {
        this.checkRevokedSubscriptions();
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(this.getCustomerInfo());
        if (this.haveConsumptionCapacity()) {
            this.consumePower(timeslot, subscriptions);
        }
        if (this.haveProductionCapacity()) {
            this.producePower(timeslot, subscriptions);
        }
    }

    private void checkRevokedSubscriptions() {
        List revoked = this.tariffSubscriptionRepo.getRevokedSubscriptionList(this.getCustomerInfo());
        for (TariffSubscription revokedSubscription : revoked) {
            revokedSubscription.handleRevokedTariff();
        }
    }

    private boolean haveConsumptionCapacity() {
        for (CapacityBundle bundle : this.capacityBundles) {
            if (bundle.getCapacityType() != CapacityProfile.CapacityType.CONSUMPTION) continue;
            return true;
        }
        return false;
    }

    private boolean haveProductionCapacity() {
        for (CapacityBundle bundle : this.capacityBundles) {
            if (bundle.getCapacityType() != CapacityProfile.CapacityType.PRODUCTION) continue;
            return true;
        }
        return false;
    }

    private void consumePower(Timeslot timeslot, List<TariffSubscription> subscriptions) {
        double totalConsumption = 0.0;
        for (TariffSubscription subscription : subscriptions) {
            if (subscription.getCustomersCommitted() <= 0 || CapacityProfile.reportCapacityType(subscription.getTariff().getTariffSpec().getPowerType()) != CapacityProfile.CapacityType.CONSUMPTION) continue;
            for (CapacityBundle bundle : this.capacityBundles) {
                if (bundle.getCapacityType() != CapacityProfile.CapacityType.CONSUMPTION) continue;
                double currCapacity = bundle.useCapacity(timeslot, subscription);
                subscription.usePower(currCapacity);
                totalConsumption += currCapacity;
            }
        }
        log.info((Object)(this.getName() + ": Total consumption for timeslot " + timeslot.getSerialNumber() + " = " + totalConsumption));
    }

    private void producePower(Timeslot timeslot, List<TariffSubscription> subscriptions) {
        double totalProduction = 0.0;
        for (TariffSubscription subscription : subscriptions) {
            if (subscription.getCustomersCommitted() <= 0 || CapacityProfile.reportCapacityType(subscription.getTariff().getTariffSpec().getPowerType()) != CapacityProfile.CapacityType.PRODUCTION) continue;
            for (CapacityBundle bundle : this.capacityBundles) {
                if (bundle.getCapacityType() != CapacityProfile.CapacityType.PRODUCTION) continue;
                double currCapacity = -1.0 * bundle.useCapacity(timeslot, subscription);
                subscription.usePower(currCapacity);
                totalProduction = currCapacity;
            }
        }
        log.info((Object)(this.getName() + ": Total production for timeslot " + timeslot.getSerialNumber() + " = " + totalProduction));
    }

    CustomerInfo getCustomerInfo() {
        return this.customerProfile.customerInfo;
    }

    String getName() {
        return this.customerProfile.name;
    }

    int getPopulation() {
        return this.getCustomerInfo().getPopulation();
    }

    private double truncateTo2Decimals(double x) {
        double fract;
        double whole;
        if (x > 0.0) {
            whole = Math.floor(x);
            fract = Math.floor((x - whole) * 100.0) / 100.0;
        } else {
            whole = Math.ceil(x);
            fract = Math.ceil((x - whole) * 100.0) / 100.0;
        }
        return whole + fract;
    }

    private void logAllocationDetails(String msg) {
        log.debug((Object)msg);
    }

    public String toString() {
        return "UtilityOptimizer:" + this.getName();
    }
}

