/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.Map;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.interfaces.FactoredCustomer;

@Domain
final class CustomerFactory {
    CustomerCreator defaultCreator;
    Map<String, CustomerCreator> customerCreators = new HashMap<String, CustomerCreator>();

    CustomerFactory() {
    }

    @StateChange
    void registerDefaultCreator(CustomerCreator creator) {
        this.defaultCreator = creator;
    }

    @StateChange
    void registerCreator(CustomerCreator creator) {
        this.registerCreator(creator.getKey(), creator);
    }

    @StateChange
    void registerCreator(String key, CustomerCreator creator) {
        this.customerCreators.put(key, creator);
    }

    FactoredCustomer processStructure(CustomerStructure structure) {
        CustomerCreator creator;
        if (structure.creatorKey == null || structure.creatorKey.trim().isEmpty()) {
            creator = this.defaultCreator;
        } else {
            creator = this.customerCreators.get(structure.creatorKey);
            if (creator == null) {
                throw new Error("CustomerFactory does not have a registered creator for key: " + structure.creatorKey);
            }
        }
        return creator.createModel(structure);
    }

    public static interface CustomerCreator {
        public String getKey();

        public FactoredCustomer createModel(CustomerStructure var1);
    }
}

