/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.TariffSubscriberStructure;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.powertac.factoredcustomer.interfaces.UtilityOptimizer;

@Domain
class DefaultUtilityOptimizer
implements UtilityOptimizer {
    protected Logger log = Logger.getLogger((String)DefaultUtilityOptimizer.class.getName());
    protected final FactoredCustomerService factoredCustomerService;
    protected final TariffMarket tariffMarketService;
    protected final TariffSubscriptionRepo tariffSubscriptionRepo;
    protected final TimeslotRepo timeslotRepo;
    protected final RandomSeedRepo randomSeedRepo;
    protected static final int NUM_HOURS_IN_DAY = 24;
    protected static final long MEAN_TARIFF_DURATION = 5L;
    protected final CustomerStructure customerStructure;
    protected final List<CapacityBundle> capacityBundles;
    protected final List<Tariff> ignoredTariffs = new ArrayList<Tariff>();
    protected Random inertiaSampler;
    protected Random tariffSelector;
    protected final List<Tariff> allTariffs = new ArrayList<Tariff>();
    private int tariffEvaluationCounter = 0;

    DefaultUtilityOptimizer(CustomerStructure structure, List<CapacityBundle> bundles) {
        this.customerStructure = structure;
        this.capacityBundles = bundles;
        this.factoredCustomerService = (FactoredCustomerService)((Object)SpringApplicationContext.getBean((String)"factoredCustomerService"));
        this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean((String)"tariffMarketService");
        this.tariffSubscriptionRepo = (TariffSubscriptionRepo)SpringApplicationContext.getBean((String)"tariffSubscriptionRepo");
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
    }

    @Override
    public void initialize() {
        this.inertiaSampler = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.DefaultUtilityOptimizer", this.customerStructure.structureId, "InertiaSampler").getValue());
        this.tariffSelector = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.DefaultUtilityOptimizer", this.customerStructure.structureId, "TariffSelector").getValue());
        this.subscribeDefault();
    }

    @StateChange
    protected void subscribe(Tariff tariff, CapacityBundle bundle, int customerCount, boolean verbose) {
        this.tariffMarketService.subscribeToTariff(tariff, bundle.getCustomerInfo(), customerCount);
        if (verbose) {
            this.log.info((Object)(bundle.getName() + ": Subscribed " + customerCount + " customers to tariff " + tariff.getId() + " successfully"));
        }
    }

    @StateChange
    protected void unsubscribe(TariffSubscription subscription, CapacityBundle bundle, int customerCount, boolean verbose) {
        subscription.unsubscribe(customerCount);
        if (verbose) {
            this.log.info((Object)(bundle.getName() + ": Unsubscribed " + customerCount + " customers from tariff " + subscription.getTariff().getId() + " successfully"));
        }
    }

    protected void subscribeDefault() {
        for (CapacityBundle bundle : this.capacityBundles) {
            PowerType powerType = bundle.getPowerType();
            if (this.tariffMarketService.getDefaultTariff(powerType) != null) {
                this.log.info((Object)(bundle.getName() + ": Subscribing " + bundle.getPopulation() + " customers to default " + powerType + " tariff"));
                this.subscribe(this.tariffMarketService.getDefaultTariff(powerType), bundle, bundle.getPopulation(), false);
                continue;
            }
            this.log.info((Object)(bundle.getName() + ": No default tariff for power type " + powerType + "; trying generic type"));
            PowerType genericType = powerType.getGenericType();
            if (this.tariffMarketService.getDefaultTariff(genericType) == null) {
                this.log.error((Object)(bundle.getName() + ": No default tariff for generic power type " + genericType + " either!"));
                continue;
            }
            this.log.info((Object)(bundle.getName() + ": Subscribing " + bundle.getPopulation() + " customers to default " + genericType + " tariff"));
            this.subscribe(this.tariffMarketService.getDefaultTariff(genericType), bundle, bundle.getPopulation(), false);
        }
    }

    @Override
    public void handleNewTariffs(List<Tariff> newTariffs) {
        ++this.tariffEvaluationCounter;
        for (Tariff tariff : newTariffs) {
            this.allTariffs.add(tariff);
        }
        for (CapacityBundle bundle : this.capacityBundles) {
            this.evaluateTariffs(bundle, newTariffs);
        }
    }

    private void evaluateTariffs(CapacityBundle bundle, List<Tariff> newTariffs) {
        if (this.tariffEvaluationCounter % bundle.getSubscriberStructure().reconsiderationPeriod == 0) {
            this.reevaluateAllTariffs(bundle);
        } else if (!this.ignoredTariffs.isEmpty()) {
            this.evaluateCurrentTariffs(bundle, newTariffs);
        } else if (!newTariffs.isEmpty()) {
            boolean ignoringNewTariffs = true;
            for (Tariff tariff : newTariffs) {
                if (!this.isTariffApplicable(tariff, bundle)) continue;
                ignoringNewTariffs = false;
                this.evaluateCurrentTariffs(bundle, newTariffs);
                break;
            }
            if (ignoringNewTariffs) {
                this.log.info((Object)(bundle.getName() + ": New tariffs are not applicable; skipping evaluation"));
            }
        }
    }

    private void reevaluateAllTariffs(CapacityBundle bundle) {
        this.log.info((Object)(bundle.getName() + ": Reevaluating all tariffs for " + bundle.getPowerType() + " subscriptions"));
        ArrayList<Tariff> evalTariffs = new ArrayList<Tariff>();
        for (Tariff tariff : this.allTariffs) {
            if (tariff.isRevoked() || tariff.isExpired() || !this.isTariffApplicable(tariff, bundle)) continue;
            evalTariffs.add(tariff);
        }
        this.assertNotEmpty(bundle, evalTariffs);
        this.manageSubscriptions(bundle, evalTariffs);
    }

    private boolean isTariffApplicable(Tariff tariff, CapacityBundle bundle) {
        PowerType bundlePowerType = bundle.getCustomerInfo().getPowerType();
        return tariff.getPowerType() == bundlePowerType || tariff.getPowerType() == bundlePowerType.getGenericType();
    }

    private void evaluateCurrentTariffs(CapacityBundle bundle, List<Tariff> newTariffs) {
        if (bundle.getSubscriberStructure().inertiaDistribution != null) {
            double inertia = bundle.getSubscriberStructure().inertiaDistribution.drawSample();
            if (this.inertiaSampler.nextDouble() < inertia) {
                this.log.info((Object)(bundle.getName() + ": Skipping " + bundle.getCustomerInfo().getPowerType() + " tariff reevaluation due to inertia"));
                for (Tariff newTariff : newTariffs) {
                    this.ignoredTariffs.add(newTariff);
                }
                return;
            }
        }
        HashMap<Long, Tariff> currTariffs = new HashMap<Long, Tariff>();
        for (Tariff ignoredTariff : this.ignoredTariffs) {
            currTariffs.put(ignoredTariff.getId(), ignoredTariff);
        }
        this.ignoredTariffs.clear();
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(bundle.getCustomerInfo());
        for (TariffSubscription subscription : subscriptions) {
            currTariffs.put(subscription.getTariff().getId(), subscription.getTariff());
        }
        for (Tariff newTariff : newTariffs) {
            currTariffs.put(newTariff.getId(), newTariff);
        }
        ArrayList<Tariff> evalTariffs = new ArrayList<Tariff>();
        for (Tariff tariff : currTariffs.values()) {
            if (!this.isTariffApplicable(tariff, bundle)) continue;
            evalTariffs.add(tariff);
        }
        this.assertNotEmpty(bundle, evalTariffs);
        this.manageSubscriptions(bundle, evalTariffs);
    }

    private void assertNotEmpty(CapacityBundle bundle, List<Tariff> evalTariffs) {
        if (evalTariffs.isEmpty()) {
            throw new Error(bundle.getName() + ": The evaluation tariffs list is unexpectedly empty!");
        }
    }

    private void manageSubscriptions(CapacityBundle bundle, List<Tariff> evalTariffs) {
        Collections.shuffle(evalTariffs);
        PowerType powerType = bundle.getCustomerInfo().getPowerType();
        ArrayList<Long> tariffIds = new ArrayList<Long>(evalTariffs.size());
        for (Tariff tariff : evalTariffs) {
            tariffIds.add(tariff.getId());
        }
        this.logAllocationDetails(bundle.getName() + ": " + powerType + " tariffs for evaluation: " + tariffIds);
        List<Double> estimatedPayments = this.estimatePayments(bundle, evalTariffs);
        this.logAllocationDetails(bundle.getName() + ": Estimated payments for evaluated tariffs: " + estimatedPayments);
        List<Integer> allocations = this.determineAllocations(bundle, evalTariffs, estimatedPayments);
        this.logAllocationDetails(bundle.getName() + ": Allocations for evaluated tariffs: " + allocations);
        int overAllocations = 0;
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff evalTariff = evalTariffs.get(i);
            int allocation = allocations.get(i);
            TariffSubscription subscription = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(evalTariff, bundle.getCustomerInfo());
            int currentCommitted = subscription != null ? subscription.getCustomersCommitted() : 0;
            int numChange = allocation - currentCommitted;
            this.log.debug((Object)(bundle.getName() + ": evalTariff = " + evalTariff.getId() + ", numChange = " + numChange + ", currentCommitted = " + currentCommitted + ", allocation = " + allocation));
            if (numChange == 0) {
                if (currentCommitted > 0) {
                    this.log.info((Object)(bundle.getName() + ": Maintaining " + currentCommitted + " " + powerType + " customers in tariff " + evalTariff.getId()));
                    continue;
                }
                this.log.info((Object)(bundle.getName() + ": Not allocating any " + powerType + " customers to tariff " + evalTariff.getId()));
                continue;
            }
            if (numChange > 0) {
                if (evalTariff.isExpired()) {
                    overAllocations += numChange;
                    if (currentCommitted > 0) {
                        this.log.info((Object)(bundle.getName() + ": Maintaining " + currentCommitted + " " + powerType + " customers in expired tariff " + evalTariff.getId()));
                    }
                    this.log.info((Object)(bundle.getName() + ": Reallocating " + numChange + " " + powerType + " customers from expired tariff " + evalTariff.getId() + " to other tariffs"));
                    continue;
                }
                this.log.info((Object)(bundle.getName() + ": Subscribing " + numChange + " " + powerType + " customers to tariff " + evalTariff.getId()));
                this.subscribe(evalTariff, bundle, numChange, false);
                continue;
            }
            if (numChange >= 0) continue;
            this.log.info((Object)(bundle.getName() + ": Unsubscribing " + -numChange + " " + powerType + " customers from tariff " + evalTariff.getId()));
            this.unsubscribe(subscription, bundle, -numChange, false);
        }
        if (overAllocations > 0) {
            int minIndex = 0;
            double minEstimate = Double.POSITIVE_INFINITY;
            for (int i = 0; i < estimatedPayments.size(); ++i) {
                if (!(estimatedPayments.get(i) < minEstimate) || evalTariffs.get(i).isExpired()) continue;
                minIndex = i;
                minEstimate = estimatedPayments.get(i);
            }
            this.log.info((Object)(bundle.getName() + ": Subscribing " + overAllocations + " over-allocated customers to tariff " + evalTariffs.get(minIndex).getId()));
            this.subscribe(evalTariffs.get(minIndex), bundle, overAllocations, false);
        }
    }

    private List<Double> estimatePayments(CapacityBundle bundle, List<Tariff> evalTariffs) {
        ArrayList<Double> estimatedPayments = new ArrayList<Double>(evalTariffs.size());
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff tariff = evalTariffs.get(i);
            if (tariff.isExpired()) {
                if (bundle.getCustomerInfo().getPowerType().isConsumption()) {
                    estimatedPayments.add(Double.POSITIVE_INFINITY);
                    continue;
                }
                estimatedPayments.add(Double.NEGATIVE_INFINITY);
                continue;
            }
            double fixedPayments = this.estimateFixedTariffPayments(tariff);
            double variablePayment = this.forecastDailyUsageCharge(bundle, tariff);
            double totalPayment = this.truncateTo2Decimals(fixedPayments + variablePayment);
            estimatedPayments.add(totalPayment);
        }
        return estimatedPayments;
    }

    private double estimateFixedTariffPayments(Tariff tariff) {
        double lifecyclePayment = tariff.getEarlyWithdrawPayment() + tariff.getSignupPayment();
        double minDuration = tariff.getMinDuration() == 0L ? 4.32E8 : (double)tariff.getMinDuration();
        return tariff.getPeriodicPayment() + lifecyclePayment / minDuration;
    }

    private double forecastDailyUsageCharge(CapacityBundle bundle, Tariff tariff) {
        Timeslot hourlyTimeslot = this.timeslotRepo.currentTimeslot();
        double totalUsage = 0.0;
        double totalCharge = 0.0;
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            CapacityProfile forecast = capacityOriginator.getCurrentForecast();
            for (int i = 0; i < 24; ++i) {
                double usageSign = bundle.getPowerType().isConsumption() ? 1.0 : -1.0;
                double hourlyUsage = usageSign * forecast.getCapacity(i);
                totalCharge += tariff.getUsageCharge(hourlyTimeslot.getStartInstant(), hourlyUsage, totalUsage);
                totalUsage += hourlyUsage;
            }
        }
        return totalCharge;
    }

    private List<Integer> determineAllocations(CapacityBundle bundle, List<Tariff> evalTariffs, List<Double> estimatedPayments) {
        if (evalTariffs.size() == 1) {
            ArrayList<Integer> allocations = new ArrayList<Integer>();
            allocations.add(bundle.getPopulation());
            return allocations;
        }
        if (bundle.getSubscriberStructure().allocationMethod == TariffSubscriberStructure.AllocationMethod.TOTAL_ORDER) {
            return this.determineTotalOrderAllocations(bundle, evalTariffs, estimatedPayments);
        }
        return this.determineLogitChoiceAllocations(bundle, evalTariffs, estimatedPayments);
    }

    private List<Integer> determineTotalOrderAllocations(CapacityBundle bundle, List<Tariff> evalTariffs, List<Double> estimatedPayments) {
        List<Object> allocationRule;
        int numTariffs = evalTariffs.size();
        if (bundle.getSubscriberStructure().totalOrderRules.isEmpty()) {
            allocationRule = new ArrayList<Double>(numTariffs);
            allocationRule.add(1.0);
            for (int i = 1; i < numTariffs; ++i) {
                allocationRule.add(0.0);
            }
        } else if (numTariffs <= bundle.getSubscriberStructure().totalOrderRules.size()) {
            allocationRule = bundle.getSubscriberStructure().totalOrderRules.get(numTariffs - 1);
        } else {
            allocationRule = new ArrayList(numTariffs);
            List<Double> largestRule = bundle.getSubscriberStructure().totalOrderRules.get(bundle.getSubscriberStructure().totalOrderRules.size() - 1);
            for (int i = 0; i < numTariffs; ++i) {
                if (i < largestRule.size()) {
                    allocationRule.add(largestRule.get(i));
                    continue;
                }
                allocationRule.add(0.0);
            }
        }
        ArrayList<Double> sortedPayments = new ArrayList<Double>(numTariffs);
        for (double estimatedPayment : estimatedPayments) {
            sortedPayments.add(estimatedPayment);
        }
        Collections.sort(sortedPayments, Collections.reverseOrder());
        ArrayList<Integer> allocations = new ArrayList<Integer>(numTariffs);
        for (int i = 0; i < numTariffs; ++i) {
            if ((Double)allocationRule.get(i) > 0.0) {
                double nextBest = (Double)sortedPayments.get(i);
                for (int j = 0; j < numTariffs; ++j) {
                    if (estimatedPayments.get(j) != nextBest) continue;
                    allocations.add((int)Math.round((double)bundle.getCustomerInfo().getPopulation() * (Double)allocationRule.get(i)));
                }
                continue;
            }
            allocations.add(0);
        }
        return allocations;
    }

    private List<Integer> determineLogitChoiceAllocations(CapacityBundle bundle, List<Tariff> evalTariffs, List<Double> estimatedPayments) {
        int numTariffs = evalTariffs.size();
        double bestPayment = Collections.max(estimatedPayments);
        double worstPayment = Collections.min(estimatedPayments);
        ArrayList<Double> probabilities = new ArrayList<Double>(numTariffs);
        if (bestPayment - worstPayment < 0.01) {
            for (int i = 0; i < numTariffs; ++i) {
                probabilities.add(1.0 / (double)numTariffs);
            }
        } else {
            int i;
            double sumPayments = 0.0;
            for (int i2 = 0; i2 < numTariffs; ++i2) {
                sumPayments += estimatedPayments.get(i2).doubleValue();
            }
            double meanPayment = sumPayments / (double)numTariffs;
            double lambda = bundle.getSubscriberStructure().logitChoiceRationality;
            ArrayList<Double> numerators = new ArrayList<Double>(numTariffs);
            double denominator = 0.0;
            for (i = 0; i < numTariffs; ++i) {
                double basis = Math.max(bestPayment - meanPayment, meanPayment - worstPayment);
                double utility = (estimatedPayments.get(i) - meanPayment) / basis * 3.0;
                double numerator = Math.exp(lambda * utility);
                numerators.add(numerator);
                denominator += numerator;
            }
            for (i = 0; i < numTariffs; ++i) {
                probabilities.add((Double)numerators.get(i) / denominator);
            }
        }
        ArrayList<Integer> allocations = new ArrayList<Integer>(numTariffs);
        int population = bundle.getPopulation();
        if (bundle.getCustomerInfo().isMultiContracting()) {
            int sumAllocations = 0;
            for (int i = 0; i < numTariffs; ++i) {
                int allocation;
                if (i < numTariffs - 1) {
                    allocation = (int)Math.round((double)population * (Double)probabilities.get(i));
                    sumAllocations += allocation;
                } else {
                    allocation = population - sumAllocations;
                }
                allocations.add(allocation);
            }
        } else {
            double r = (double)this.tariffSelector.nextInt(100) / 100.0;
            double cumProbability = 0.0;
            for (int i = 0; i < numTariffs; ++i) {
                if (r <= (cumProbability += ((Double)probabilities.get(i)).doubleValue())) {
                    allocations.add(population);
                    for (int j = i + 1; j < numTariffs; ++j) {
                        allocations.add(0);
                    }
                    break;
                }
                allocations.add(0);
            }
        }
        return allocations;
    }

    @Override
    public void handleNewTimeslot(Timeslot timeslot) {
        this.checkRevokedSubscriptions();
        this.usePower(timeslot);
    }

    private void checkRevokedSubscriptions() {
        for (CapacityBundle bundle : this.capacityBundles) {
            List revoked = this.tariffSubscriptionRepo.getRevokedSubscriptionList(bundle.getCustomerInfo());
            for (TariffSubscription revokedSubscription : revoked) {
                revokedSubscription.handleRevokedTariff();
            }
        }
    }

    private void usePower(Timeslot timeslot) {
        for (CapacityBundle bundle : this.capacityBundles) {
            List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(bundle.getCustomerInfo());
            double totalCapacity = 0.0;
            double totalUsageCharge = 0.0;
            for (TariffSubscription subscription : subscriptions) {
                if (subscription.getCustomersCommitted() <= 0) continue;
                double usageSign = bundle.getPowerType().isConsumption() ? 1.0 : -1.0;
                double currCapacity = usageSign * this.useCapacity(subscription, bundle);
                if (this.factoredCustomerService.getUsageChargesLogging()) {
                    double charge = subscription.getTariff().getUsageCharge(currCapacity, subscription.getTotalUsage(), false);
                    totalUsageCharge += charge;
                }
                subscription.usePower(currCapacity);
                totalCapacity += currCapacity;
            }
            this.log.info((Object)(bundle.getName() + ": Total " + bundle.getPowerType() + " capacity for timeslot " + timeslot.getSerialNumber() + " = " + totalCapacity));
            this.logUsageCharges(bundle.getName() + ": Total " + bundle.getPowerType() + " usage charge for timeslot " + timeslot.getSerialNumber() + " = " + totalUsageCharge);
        }
    }

    public double useCapacity(TariffSubscription subscription, CapacityBundle bundle) {
        double capacity = 0.0;
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            capacity += capacityOriginator.useCapacity(subscription);
        }
        return capacity;
    }

    protected String getCustomerName() {
        return this.customerStructure.name;
    }

    protected double truncateTo2Decimals(double x) {
        double fract;
        double whole;
        if (x > 0.0) {
            whole = Math.floor(x);
            fract = Math.floor((x - whole) * 100.0) / 100.0;
        } else {
            whole = Math.ceil(x);
            fract = Math.ceil((x - whole) * 100.0) / 100.0;
        }
        return whole + fract;
    }

    private void logAllocationDetails(String msg) {
        if (this.factoredCustomerService.getAllocationDetailsLogging()) {
            this.log.info((Object)msg);
        }
    }

    private void logUsageCharges(String msg) {
        if (this.factoredCustomerService.getUsageChargesLogging()) {
            this.log.info((Object)msg);
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.getCustomerName();
    }
}

