/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.AdaptiveCapacityBundle;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultFactoredCustomer;
import org.powertac.factoredcustomer.LearningUtilityOptimizer;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.UtilityOptimizer;
import org.w3c.dom.Element;

@Domain
class LearningFactoredCustomer
extends DefaultFactoredCustomer {
    LearningFactoredCustomer(CustomerStructure structure) {
        super(structure);
        this.log = Logger.getLogger((String)LearningFactoredCustomer.class.getName());
    }

    @Override
    protected CapacityBundle createCapacityBundle(CustomerStructure structure, Element capacityBundleElement) {
        return new AdaptiveCapacityBundle(structure, capacityBundleElement);
    }

    @Override
    protected UtilityOptimizer createUtilityOptimizer(CustomerStructure structure, List<CapacityBundle> capacityBundles) {
        return new LearningUtilityOptimizer(structure, capacityBundles);
    }
}

