/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.TariffEvaluationHelper;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.TariffSubscriberStructure;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.powertac.factoredcustomer.interfaces.UtilityOptimizer;

@Domain
class DefaultUtilityOptimizer
implements UtilityOptimizer {
    protected Logger log = Logger.getLogger((String)DefaultUtilityOptimizer.class.getName());
    protected final FactoredCustomerService factoredCustomerService;
    protected final TariffMarket tariffMarketService;
    protected final TariffSubscriptionRepo tariffSubscriptionRepo;
    protected final TimeslotRepo timeslotRepo;
    protected final RandomSeedRepo randomSeedRepo;
    protected static final int NUM_HOURS_IN_DAY = 24;
    protected static final long MEAN_TARIFF_DURATION = 5L;
    protected final CustomerStructure customerStructure;
    protected final List<CapacityBundle> capacityBundles;
    protected final List<Tariff> ignoredTariffs = new ArrayList<Tariff>();
    protected Random inertiaSampler;
    protected Random tariffSelector;
    protected final TariffEvaluationHelper tariffEvalHelper = new TariffEvaluationHelper();
    protected final List<Tariff> allTariffs = new ArrayList<Tariff>();
    protected int tariffEvaluationCounter = 0;
    protected List<CapacityBundle> bundlesWithRevokedTariffs = new ArrayList<CapacityBundle>();

    DefaultUtilityOptimizer(CustomerStructure structure, List<CapacityBundle> bundles) {
        this.customerStructure = structure;
        this.capacityBundles = bundles;
        this.factoredCustomerService = (FactoredCustomerService)((Object)SpringApplicationContext.getBean((String)"factoredCustomerService"));
        this.tariffMarketService = (TariffMarket)SpringApplicationContext.getBean((String)"tariffMarketService");
        this.tariffSubscriptionRepo = (TariffSubscriptionRepo)SpringApplicationContext.getBean((String)"tariffSubscriptionRepo");
        this.timeslotRepo = (TimeslotRepo)SpringApplicationContext.getBean((String)"timeslotRepo");
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
    }

    @Override
    public void initialize() {
        this.inertiaSampler = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.DefaultUtilityOptimizer", this.customerStructure.structureId, "InertiaSampler").getValue());
        this.tariffSelector = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.DefaultUtilityOptimizer", this.customerStructure.structureId, "TariffSelector").getValue());
        this.subscribeDefault();
    }

    @StateChange
    protected void subscribe(Tariff tariff, CapacityBundle bundle, int customerCount, boolean verbose) {
        this.tariffMarketService.subscribeToTariff(tariff, bundle.getCustomerInfo(), customerCount);
        if (verbose) {
            this.log.info((Object)(bundle.getName() + ": Subscribed " + customerCount + " customers to tariff " + tariff.getId() + " successfully"));
        }
    }

    @StateChange
    protected void unsubscribe(TariffSubscription subscription, CapacityBundle bundle, int customerCount, boolean verbose) {
        subscription.unsubscribe(customerCount);
        if (verbose) {
            this.log.info((Object)(bundle.getName() + ": Unsubscribed " + customerCount + " customers from tariff " + subscription.getTariff().getId() + " successfully"));
        }
    }

    protected void subscribeDefault() {
        for (CapacityBundle bundle : this.capacityBundles) {
            PowerType powerType = bundle.getPowerType();
            if (this.tariffMarketService.getDefaultTariff(powerType) != null) {
                this.log.info((Object)(bundle.getName() + ": Subscribing " + bundle.getPopulation() + " customers to default " + powerType + " tariff"));
                this.subscribe(this.tariffMarketService.getDefaultTariff(powerType), bundle, bundle.getPopulation(), false);
                continue;
            }
            this.log.info((Object)(bundle.getName() + ": No default tariff for power type " + powerType + "; trying generic type"));
            PowerType genericType = powerType.getGenericType();
            if (this.tariffMarketService.getDefaultTariff(genericType) == null) {
                this.log.error((Object)(bundle.getName() + ": No default tariff for generic power type " + genericType + " either!"));
                continue;
            }
            this.log.info((Object)(bundle.getName() + ": Subscribing " + bundle.getPopulation() + " customers to default " + genericType + " tariff"));
            this.subscribe(this.tariffMarketService.getDefaultTariff(genericType), bundle, bundle.getPopulation(), false);
        }
    }

    @Override
    public void handleNewTariffs(List<Tariff> newTariffs) {
        ++this.tariffEvaluationCounter;
        for (Tariff tariff : newTariffs) {
            this.allTariffs.add(tariff);
        }
        for (CapacityBundle bundle : this.capacityBundles) {
            this.evaluateTariffs(bundle, newTariffs);
        }
        this.bundlesWithRevokedTariffs.clear();
    }

    private boolean isTariffApplicable(Tariff tariff, CapacityBundle bundle) {
        PowerType bundlePowerType = bundle.getCustomerInfo().getPowerType();
        return tariff.getPowerType() == bundlePowerType || tariff.getPowerType() == bundlePowerType.getGenericType();
    }

    private void evaluateTariffs(CapacityBundle bundle, List<Tariff> newTariffs) {
        if (this.tariffEvaluationCounter % bundle.getSubscriberStructure().reconsiderationPeriod == 0 || this.bundlesWithRevokedTariffs.contains(bundle)) {
            this.reevaluateAllTariffs(bundle);
        } else if (!this.ignoredTariffs.isEmpty()) {
            this.evaluateCurrentTariffs(bundle, newTariffs);
        } else if (!newTariffs.isEmpty()) {
            boolean ignoringNewTariffs = true;
            for (Tariff tariff : newTariffs) {
                if (!this.isTariffApplicable(tariff, bundle)) continue;
                ignoringNewTariffs = false;
                this.evaluateCurrentTariffs(bundle, newTariffs);
                break;
            }
            if (ignoringNewTariffs) {
                this.log.info((Object)(bundle.getName() + ": New tariffs are not applicable; skipping evaluation"));
            }
        }
    }

    private void reevaluateAllTariffs(CapacityBundle bundle) {
        this.log.info((Object)(bundle.getName() + ": Reevaluating all tariffs for " + bundle.getPowerType() + " subscriptions"));
        ArrayList<Tariff> evalTariffs = new ArrayList<Tariff>();
        for (Tariff tariff : this.allTariffs) {
            if (tariff.isRevoked() || tariff.isExpired() || !this.isTariffApplicable(tariff, bundle)) continue;
            evalTariffs.add(tariff);
        }
        this.assertNotEmpty(bundle, evalTariffs);
        this.ignoredTariffs.clear();
        this.manageSubscriptions(bundle, evalTariffs);
    }

    private void evaluateCurrentTariffs(CapacityBundle bundle, List<Tariff> newTariffs) {
        if (bundle.getSubscriberStructure().inertiaDistribution != null) {
            double inertia = bundle.getSubscriberStructure().inertiaDistribution.drawSample();
            if (this.inertiaSampler.nextDouble() < inertia) {
                this.log.info((Object)(bundle.getName() + ": Skipping " + bundle.getCustomerInfo().getPowerType() + " tariff reevaluation due to inertia"));
                for (Tariff newTariff : newTariffs) {
                    this.ignoredTariffs.add(newTariff);
                }
                return;
            }
        }
        HashMap<Long, Tariff> currTariffs = new HashMap<Long, Tariff>();
        for (Tariff ignoredTariff : this.ignoredTariffs) {
            currTariffs.put(ignoredTariff.getId(), ignoredTariff);
        }
        this.ignoredTariffs.clear();
        List subscriptions = this.tariffSubscriptionRepo.findSubscriptionsForCustomer(bundle.getCustomerInfo());
        for (TariffSubscription subscription : subscriptions) {
            Tariff subTariff = subscription.getTariff();
            if (subTariff.isExpired() || subTariff.isExpired()) continue;
            currTariffs.put(subTariff.getId(), subTariff);
        }
        for (Tariff newTariff : newTariffs) {
            currTariffs.put(newTariff.getId(), newTariff);
        }
        Tariff defaultTariff = this.getDefaultTariff(bundle);
        if (!currTariffs.containsKey(defaultTariff.getId())) {
            currTariffs.put(defaultTariff.getId(), defaultTariff);
        }
        ArrayList<Tariff> evalTariffs = new ArrayList<Tariff>();
        for (Tariff tariff : currTariffs.values()) {
            if (!this.isTariffApplicable(tariff, bundle)) continue;
            evalTariffs.add(tariff);
        }
        this.assertNotEmpty(bundle, evalTariffs);
        this.manageSubscriptions(bundle, evalTariffs);
    }

    private void assertNotEmpty(CapacityBundle bundle, List<Tariff> evalTariffs) {
        if (evalTariffs.isEmpty()) {
            throw new Error(bundle.getName() + ": The evaluation tariffs list is unexpectedly empty!");
        }
    }

    private void manageSubscriptions(CapacityBundle bundle, List<Tariff> evalTariffs) {
        Collections.shuffle(evalTariffs);
        PowerType powerType = bundle.getCustomerInfo().getPowerType();
        ArrayList<Long> tariffIds = new ArrayList<Long>(evalTariffs.size());
        for (Tariff tariff : evalTariffs) {
            tariffIds.add(tariff.getId());
        }
        this.logAllocationDetails(bundle.getName() + ": " + powerType + " tariffs for evaluation: " + tariffIds);
        List<Double> estimatedPayments = this.estimatePayments(bundle, evalTariffs);
        this.logAllocationDetails(bundle.getName() + ": Estimated payments for tariffs: " + estimatedPayments);
        List<Integer> allocations = this.determineAllocations(bundle, evalTariffs, estimatedPayments);
        this.logAllocationDetails(bundle.getName() + ": Allocations for tariffs: " + allocations);
        int overAllocations = 0;
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff evalTariff = evalTariffs.get(i);
            int allocation = allocations.get(i);
            TariffSubscription subscription = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(evalTariff, bundle.getCustomerInfo());
            int currentCommitted = subscription != null ? subscription.getCustomersCommitted() : 0;
            int numChange = allocation - currentCommitted;
            this.log.debug((Object)(bundle.getName() + ": evalTariff = " + evalTariff.getId() + ", numChange = " + numChange + ", currentCommitted = " + currentCommitted + ", allocation = " + allocation));
            if (numChange == 0) {
                if (currentCommitted > 0) {
                    this.log.info((Object)(bundle.getName() + ": Maintaining " + currentCommitted + " " + powerType + " customers in tariff " + evalTariff.getId()));
                    continue;
                }
                this.log.info((Object)(bundle.getName() + ": Not allocating any " + powerType + " customers to tariff " + evalTariff.getId()));
                continue;
            }
            if (numChange > 0) {
                if (evalTariff.isExpired()) {
                    overAllocations += numChange;
                    if (currentCommitted > 0) {
                        this.log.info((Object)(bundle.getName() + ": Maintaining " + currentCommitted + " " + powerType + " customers in expired tariff " + evalTariff.getId()));
                    }
                    this.log.info((Object)(bundle.getName() + ": Reallocating " + numChange + " " + powerType + " customers from expired tariff " + evalTariff.getId() + " to other tariffs"));
                    continue;
                }
                this.log.info((Object)(bundle.getName() + ": Subscribing " + numChange + " " + powerType + " customers to tariff " + evalTariff.getId()));
                this.subscribe(evalTariff, bundle, numChange, false);
                continue;
            }
            if (numChange >= 0) continue;
            this.log.info((Object)(bundle.getName() + ": Unsubscribing " + -numChange + " " + powerType + " customers from tariff " + evalTariff.getId()));
            this.unsubscribe(subscription, bundle, -numChange, false);
        }
        if (overAllocations > 0) {
            int minIndex = 0;
            double minEstimate = Double.POSITIVE_INFINITY;
            for (int i = 0; i < estimatedPayments.size(); ++i) {
                if (!(estimatedPayments.get(i) < minEstimate) || evalTariffs.get(i).isExpired()) continue;
                minIndex = i;
                minEstimate = estimatedPayments.get(i);
            }
            this.log.info((Object)(bundle.getName() + ": Subscribing " + overAllocations + " over-allocated customers to tariff " + evalTariffs.get(minIndex).getId()));
            this.subscribe(evalTariffs.get(minIndex), bundle, overAllocations, false);
        }
    }

    private List<Double> estimatePayments(CapacityBundle bundle, List<Tariff> evalTariffs) {
        ArrayList<Double> estimatedPayments = new ArrayList<Double>(evalTariffs.size());
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff tariff = evalTariffs.get(i);
            double fixedPayments = this.estimateFixedTariffPayments(bundle, tariff);
            double variablePayment = this.forecastDailyUsageCharge(bundle, tariff);
            double totalPayment = this.truncateTo2Decimals(fixedPayments + variablePayment);
            double adjustedPayment = this.adjustForInterruptibility(bundle, tariff, totalPayment);
            estimatedPayments.add(adjustedPayment);
        }
        return estimatedPayments;
    }

    private double estimateFixedTariffPayments(CapacityBundle bundle, Tariff tariff) {
        double lifecyclePayment = tariff.getEarlyWithdrawPayment() + tariff.getSignupPayment();
        double minDuration = tariff.getMinDuration() == 0L ? 5.0 : (double)tariff.getMinDuration() / 8.64E7;
        double dailyLifecyclePayment = lifecyclePayment / minDuration;
        return (double)bundle.getPopulation() * dailyLifecyclePayment;
    }

    private double forecastDailyUsageCharge(CapacityBundle bundle, Tariff tariff) {
        double usageSign = bundle.getPowerType().isConsumption() ? 1.0 : -1.0;
        double[] usageForecast = new double[24];
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            CapacityProfile forecast = capacityOriginator.getCurrentForecast();
            int i = 0;
            while (i < 24) {
                double hourlyUsage = usageSign * forecast.getCapacity(i);
                int n = i++;
                usageForecast[n] = usageForecast[n] + hourlyUsage;
            }
        }
        TariffSubscriberStructure subStructure = bundle.getSubscriberStructure();
        this.tariffEvalHelper.init(subStructure.expMeanPriceWeight.doubleValue(), subStructure.maxValuePriceWeight.doubleValue(), subStructure.realizedPriceWeight.doubleValue(), this.tariffEvalHelper.getSoldThreshold());
        return this.tariffEvalHelper.estimateCost(tariff, usageForecast);
    }

    private double adjustForInterruptibility(CapacityBundle bundle, Tariff tariff, double totalPayment) {
        double interruptibilityDiscount = bundle.getSubscriberStructure().interruptibilityDiscount;
        if (interruptibilityDiscount > 0.0 && tariff.getPowerType().isInterruptible()) {
            double effectSign = tariff.getPowerType().isConsumption() ? -1.0 : 1.0;
            double adjustedPayment = (1.0 + effectSign * interruptibilityDiscount) * totalPayment;
            return adjustedPayment;
        }
        return totalPayment;
    }

    private List<Integer> determineAllocations(CapacityBundle bundle, List<Tariff> evalTariffs, List<Double> estimatedPayments) {
        ArrayList<Integer> allocations = new ArrayList<Integer>();
        if (evalTariffs.size() == 1) {
            allocations.add(bundle.getPopulation());
            return allocations;
        }
        List<Boolean> validTariffsIndex = this.enforceTariffConstraints(bundle, evalTariffs, estimatedPayments);
        ArrayList<Tariff> checkedTariffs = new ArrayList<Tariff>();
        ArrayList<Double> checkedPayments = new ArrayList<Double>();
        for (int i = 0; i < evalTariffs.size(); ++i) {
            if (!validTariffsIndex.get(i).booleanValue()) continue;
            checkedTariffs.add(evalTariffs.get(i));
            checkedPayments.add(estimatedPayments.get(i));
        }
        List<Integer> checkedAllocs = bundle.getSubscriberStructure().allocationMethod == TariffSubscriberStructure.AllocationMethod.TOTAL_ORDER ? this.determineTotalOrderAllocations(bundle, checkedTariffs, checkedPayments) : this.determineLogitChoiceAllocations(bundle, checkedTariffs, checkedPayments);
        int checkedCounter = 0;
        for (int i = 0; i < evalTariffs.size(); ++i) {
            allocations.add(validTariffsIndex.get(i) != false ? checkedAllocs.get(checkedCounter++) : 0);
        }
        return allocations;
    }

    private List<Boolean> enforceTariffConstraints(CapacityBundle bundle, List<Tariff> evalTariffs, List<Double> estimatedPayments) {
        ArrayList<Boolean> validityIndex = new ArrayList<Boolean>();
        Tariff defaultTariff = this.getDefaultTariff(bundle);
        if (defaultTariff == null) {
            throw new Error("Default tariff not found amongst eval tariffs!");
        }
        double defaultPayment = estimatedPayments.get(evalTariffs.indexOf(defaultTariff));
        boolean benchmarkRiskEnabled = bundle.getSubscriberStructure().benchmarkRiskEnabled;
        boolean tariffThrottlingEnabled = bundle.getSubscriberStructure().tariffThrottlingEnabled;
        HashMap<Long, Integer> brokerBests = new HashMap<Long, Integer>();
        for (int i = 0; i < evalTariffs.size(); ++i) {
            Tariff evalTariff = evalTariffs.get(i);
            if (evalTariff == defaultTariff) {
                validityIndex.add(true);
                continue;
            }
            if (evalTariff.isExpired() || evalTariff.isRevoked()) {
                this.log.info((Object)("Tariff " + evalTariff.getId() + " has expired or been revoked; being ignored."));
                validityIndex.add(false);
                continue;
            }
            if (benchmarkRiskEnabled) {
                double evalRatio = estimatedPayments.get(i) / defaultPayment;
                if (bundle.getPowerType().isConsumption() && evalRatio > bundle.getSubscriberStructure().benchmarkRiskRatio || bundle.getPowerType().isProduction() && evalRatio < bundle.getSubscriberStructure().benchmarkRiskRatio) {
                    this.logAllocationDetails(bundle.getName() + ": Tariff " + evalTariff.getId() + " has a worse than constrained benchmark risk at: " + evalRatio);
                    validityIndex.add(false);
                    continue;
                }
            }
            if (tariffThrottlingEnabled) {
                Long brokerId = evalTariff.getBroker().getId();
                if (!brokerBests.containsKey(brokerId)) {
                    brokerBests.put(brokerId, i);
                } else {
                    TariffSubscription evalSub = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(evalTariff, bundle.getCustomerInfo());
                    if (evalSub == null || evalSub.getCustomersCommitted() == 0) {
                        double evalPayment = estimatedPayments.get(i);
                        double bestPayment = estimatedPayments.get((Integer)brokerBests.get(brokerId));
                        if (bundle.getPowerType().isConsumption() && evalPayment <= bestPayment || bundle.getPowerType().isProduction() && evalPayment >= bestPayment) {
                            this.logAllocationDetails(bundle.getName() + ": Tariff " + evalTariff.getId() + " is no better than " + evalTariffs.get((Integer)brokerBests.get(brokerId)).getId());
                            validityIndex.add(false);
                            continue;
                        }
                        TariffSubscription sub = this.tariffSubscriptionRepo.findSubscriptionForTariffAndCustomer(evalTariff, bundle.getCustomerInfo());
                        if (sub == null || sub.getCustomersCommitted() == 0) {
                            validityIndex.set((Integer)brokerBests.get(brokerId), false);
                            brokerBests.put(brokerId, i);
                        }
                    }
                }
            }
            validityIndex.add(true);
        }
        this.logAllocationDetails(bundle.getName() + ": Tariff constraint validation index: " + validityIndex);
        return validityIndex;
    }

    private List<Integer> determineTotalOrderAllocations(CapacityBundle bundle, List<Tariff> checkedTariffs, List<Double> estimatedPayments) {
        List<Object> allocationRule;
        int numTariffs = checkedTariffs.size();
        if (bundle.getSubscriberStructure().totalOrderRules.isEmpty()) {
            allocationRule = new ArrayList<Double>(numTariffs);
            allocationRule.add(1.0);
            for (int i = 1; i < numTariffs; ++i) {
                allocationRule.add(0.0);
            }
        } else if (numTariffs <= bundle.getSubscriberStructure().totalOrderRules.size()) {
            allocationRule = bundle.getSubscriberStructure().totalOrderRules.get(numTariffs - 1);
        } else {
            allocationRule = new ArrayList(numTariffs);
            List<Double> largestRule = bundle.getSubscriberStructure().totalOrderRules.get(bundle.getSubscriberStructure().totalOrderRules.size() - 1);
            for (int i = 0; i < numTariffs; ++i) {
                if (i < largestRule.size()) {
                    allocationRule.add(largestRule.get(i));
                    continue;
                }
                allocationRule.add(0.0);
            }
        }
        ArrayList<Double> sortedPayments = new ArrayList<Double>(numTariffs);
        for (double estimatedPayment : estimatedPayments) {
            sortedPayments.add(estimatedPayment);
        }
        Collections.sort(sortedPayments, Collections.reverseOrder());
        ArrayList<Integer> allocations = new ArrayList<Integer>(numTariffs);
        for (int i = 0; i < numTariffs; ++i) {
            if ((Double)allocationRule.get(i) > 0.0) {
                double nextBest = (Double)sortedPayments.get(i);
                for (int j = 0; j < numTariffs; ++j) {
                    if (estimatedPayments.get(j) != nextBest) continue;
                    allocations.add((int)Math.round((double)bundle.getCustomerInfo().getPopulation() * (Double)allocationRule.get(i)));
                }
                continue;
            }
            allocations.add(0);
        }
        return allocations;
    }

    private List<Integer> determineLogitChoiceAllocations(CapacityBundle bundle, List<Tariff> checkedTariffs, List<Double> estimatedPayments) {
        int numTariffs = checkedTariffs.size();
        double bestPayment = Collections.max(estimatedPayments);
        double worstPayment = Collections.min(estimatedPayments);
        ArrayList<Double> probabilities = new ArrayList<Double>(numTariffs);
        if (bestPayment - worstPayment < 0.01) {
            for (int i = 0; i < numTariffs; ++i) {
                probabilities.add(1.0 / (double)numTariffs);
            }
        } else {
            int i;
            double midPayment = (worstPayment + bestPayment) / 2.0;
            double basis = Math.max(bestPayment - midPayment, midPayment - worstPayment);
            double absMin = Double.MAX_VALUE;
            double absMax = Double.MIN_VALUE;
            for (int i2 = 0; i2 < numTariffs; ++i2) {
                double absPayment = Math.abs(estimatedPayments.get(i2));
                absMin = Math.min(absPayment, absMin);
                absMax = Math.max(absPayment, absMax);
            }
            double kappa = Math.min(10.0, Math.max(1.0, absMax / absMin));
            double lambda = bundle.getSubscriberStructure().logitChoiceRationality;
            ArrayList<Double> numerators = new ArrayList<Double>(numTariffs);
            double denominator = 0.0;
            for (i = 0; i < numTariffs; ++i) {
                double utility = (estimatedPayments.get(i) - midPayment) / basis * kappa;
                double numerator = Math.exp(lambda * utility);
                if (Double.isNaN(numerator)) {
                    numerator = 0.0;
                }
                numerators.add(numerator);
                denominator += numerator;
            }
            for (i = 0; i < numTariffs; ++i) {
                probabilities.add((Double)numerators.get(i) / denominator);
            }
        }
        ArrayList<Integer> allocations = new ArrayList<Integer>(numTariffs);
        int population = bundle.getPopulation();
        if (bundle.getCustomerInfo().isMultiContracting()) {
            int sumAllocations = 0;
            for (int i = 0; i < numTariffs; ++i) {
                int allocation;
                if (sumAllocations == population) {
                    allocation = 0;
                } else if (i < numTariffs - 1) {
                    allocation = (int)Math.round((double)population * (Double)probabilities.get(i));
                    if (sumAllocations + allocation > population) {
                        allocation = population - sumAllocations;
                    }
                    sumAllocations += allocation;
                } else {
                    allocation = population - sumAllocations;
                }
                allocations.add(allocation);
            }
        } else {
            double r = (double)this.tariffSelector.nextInt(100) / 100.0;
            double cumProbability = 0.0;
            for (int i = 0; i < numTariffs; ++i) {
                if (r <= (cumProbability += ((Double)probabilities.get(i)).doubleValue())) {
                    allocations.add(population);
                    for (int j = i + 1; j < numTariffs; ++j) {
                        allocations.add(0);
                    }
                    break;
                }
                allocations.add(0);
            }
        }
        return allocations;
    }

    private Tariff getDefaultTariff(CapacityBundle bundle) {
        Tariff defaultTariff = this.tariffMarketService.getDefaultTariff(bundle.getPowerType());
        if (defaultTariff == null) {
            defaultTariff = this.tariffMarketService.getDefaultTariff(bundle.getPowerType().getGenericType());
        }
        if (defaultTariff == null) {
            throw new Error(bundle.getName() + ": There is no default tariff for bundle type or it's generic type!");
        }
        return defaultTariff;
    }

    @Override
    public void handleNewTimeslot(Timeslot timeslot) {
        this.checkRevokedSubscriptions();
        this.usePower(timeslot);
    }

    private void checkRevokedSubscriptions() {
        for (CapacityBundle bundle : this.capacityBundles) {
            List revoked = this.tariffSubscriptionRepo.getRevokedSubscriptionList(bundle.getCustomerInfo());
            for (TariffSubscription revokedSubscription : revoked) {
                revokedSubscription.handleRevokedTariff();
                this.bundlesWithRevokedTariffs.add(bundle);
            }
        }
    }

    private void usePower(Timeslot timeslot) {
        for (CapacityBundle bundle : this.capacityBundles) {
            List subscriptions = this.tariffSubscriptionRepo.findActiveSubscriptionsForCustomer(bundle.getCustomerInfo());
            double totalCapacity = 0.0;
            double totalUsageCharge = 0.0;
            for (TariffSubscription subscription : subscriptions) {
                double usageSign = bundle.getPowerType().isConsumption() ? 1.0 : -1.0;
                double currCapacity = usageSign * this.useCapacity(subscription, bundle);
                if (this.factoredCustomerService.getUsageChargesLogging()) {
                    double charge = subscription.getTariff().getUsageCharge(currCapacity, subscription.getTotalUsage(), false);
                    totalUsageCharge += charge;
                }
                subscription.usePower(currCapacity);
                totalCapacity += currCapacity;
            }
            this.log.info((Object)(bundle.getName() + ": Total " + bundle.getPowerType() + " capacity for timeslot " + timeslot.getSerialNumber() + " = " + totalCapacity));
            this.logUsageCharges(bundle.getName() + ": Total " + bundle.getPowerType() + " usage charge for timeslot " + timeslot.getSerialNumber() + " = " + totalUsageCharge);
        }
    }

    public double useCapacity(TariffSubscription subscription, CapacityBundle bundle) {
        double capacity = 0.0;
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            capacity += capacityOriginator.useCapacity(subscription);
        }
        return capacity;
    }

    protected String getCustomerName() {
        return this.customerStructure.name;
    }

    protected double truncateTo2Decimals(double x) {
        double fract;
        double whole;
        if (x > 0.0) {
            whole = Math.floor(x);
            fract = Math.floor((x - whole) * 100.0) / 100.0;
        } else {
            whole = Math.ceil(x);
            fract = Math.ceil((x - whole) * 100.0) / 100.0;
        }
        return whole + fract;
    }

    private void logAllocationDetails(String msg) {
        if (this.factoredCustomerService.getAllocationDetailsLogging()) {
            this.log.info((Object)msg);
        }
    }

    private void logUsageCharges(String msg) {
        if (this.factoredCustomerService.getUsageChargesLogging()) {
            this.log.info((Object)msg);
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.getCustomerName();
    }
}

