/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultUtilityOptimizer;
import org.powertac.factoredcustomer.ProfileOptimizerStructure;
import org.powertac.factoredcustomer.ProfileRecommendation;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;

@Domain
class LearningUtilityOptimizer
extends DefaultUtilityOptimizer {
    private static final double NUM_SAMPLING_ITERATIONS = 30.0;
    private Random recommendationMaker;

    LearningUtilityOptimizer(CustomerStructure structure, List<CapacityBundle> bundles) {
        super(structure, bundles);
        this.log = Logger.getLogger((String)LearningUtilityOptimizer.class.getName());
    }

    @Override
    public void initialize() {
        this.inertiaSampler = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.LearningUtilityOptimizer", this.customerStructure.structureId, "InertiaSampler").getValue());
        this.tariffSelector = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.LearningUtilityOptimizer", this.customerStructure.structureId, "TariffSelector").getValue());
        this.recommendationMaker = new Random(this.randomSeedRepo.getRandomSeed("factoredcustomer.LearningUtilityOptimizer", this.customerStructure.structureId, "RecommendationMaker").getValue());
        this.subscribeDefault();
    }

    @Override
    public void handleNewTariffs(List<Tariff> newTariffs) {
        super.handleNewTariffs(newTariffs);
        this.recommendProfilesToBundles();
    }

    private void recommendProfilesToBundles() {
        for (CapacityBundle bundle : this.capacityBundles) {
            if (!bundle.getOptimizerStructure().receiveRecommendations) continue;
            this.recommendProfilesToBundle(bundle);
        }
    }

    private void recommendProfilesToBundle(CapacityBundle bundle) {
        List<TariffSubscription> subscriptions = this.getBundleSubscriptions(bundle);
        HashMap<CapacityOriginator, ForecastRecord> forecasts = new HashMap<CapacityOriginator, ForecastRecord>();
        HashMap<CapacityOriginator, List<CapacityProfile>> perms = new HashMap<CapacityOriginator, List<CapacityProfile>>();
        HashMap<CapacityOriginator, ProfileRecommendation> recs = new HashMap<CapacityOriginator, ProfileRecommendation>();
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            CapacityProfile forecast = capacityOriginator.getCurrentForecast();
            double charge = this.computeProfileUsageCharge(forecast, subscriptions, capacityOriginator);
            ForecastRecord forecastRecord = new ForecastRecord(forecast, charge);
            forecasts.put(capacityOriginator, forecastRecord);
            CapacityProfile.PermutationRule permutationRule = bundle.getOptimizerStructure().permutationRule;
            if (permutationRule == null) {
                permutationRule = CapacityProfile.PermutationRule.ALL_SHIFTS;
            }
            perms.put(capacityOriginator, forecast.getPermutations(permutationRule));
            this.log.info((Object)(bundle.getName() + ": Evaluating " + ((List)perms.get(capacityOriginator)).size() + " profile permutations for " + bundle.getCustomerInfo().getPowerType() + " capacity originator: " + capacityOriginator.getCapacityName()));
            recs.put(capacityOriginator, this.getProfileRecommendation(capacityOriginator, bundle, forecastRecord, perms, subscriptions));
        }
        if (bundle.getOptimizerStructure().raconcileRecommendations) {
            this.reconcileRecommendations(subscriptions, forecasts, perms, recs);
        }
        for (CapacityOriginator capacityOriginator : bundle.getCapacityOriginators()) {
            if (!(capacityOriginator instanceof ProfileRecommendation.Listener)) continue;
            ProfileRecommendation rec = (ProfileRecommendation)recs.get(capacityOriginator);
            if (!rec.isEmpty()) {
                this.log.info((Object)(bundle.getName() + ": Submitting " + rec.getOpinions().size() + " profile suggestions to " + bundle.getCustomerInfo().getPowerType() + " capacity originator: " + capacityOriginator.getCapacityName()));
                ((ProfileRecommendation.Listener)((Object)capacityOriginator)).handleProfileRecommendation(rec);
                continue;
            }
            this.log.info((Object)(bundle.getName() + ": No beneficial profile permutations for " + bundle.getCustomerInfo().getPowerType() + " capacity originator: " + capacityOriginator.getCapacityName()));
        }
    }

    private List<TariffSubscription> getBundleSubscriptions(CapacityBundle bundle) {
        return this.tariffSubscriptionRepo.findSubscriptionsForCustomer(bundle.getCustomerInfo());
    }

    private ProfileRecommendation getProfileRecommendation(CapacityOriginator capacityOriginator, CapacityBundle bundle, ForecastRecord forecastRecord, Map<CapacityOriginator, List<CapacityProfile>> perms, List<TariffSubscription> subscriptions) {
        this.logRecommendationDetails("Forecast " + forecastRecord.capacityProfile + " usage charge = " + forecastRecord.usageCharge);
        ProfileRecommendation rec = new ProfileRecommendation();
        for (CapacityProfile perm : perms.get(capacityOriginator)) {
            double usageCharge = this.computeProfileUsageCharge(perm, subscriptions, capacityOriginator);
            this.logRecommendationDetails("Permutation " + perm + " usage charge = " + usageCharge);
            if (!this.isPermutationAcceptable(capacityOriginator, bundle.getOptimizerStructure(), usageCharge, forecastRecord.usageCharge)) continue;
            ProfileRecommendation.Opinion opinion = new ProfileRecommendation.Opinion(rec);
            opinion.usageCharge = this.computeProfileUsageCharge(perm, subscriptions, capacityOriginator);
            opinion.profileChange = forecastRecord.capacityProfile.distanceTo(perm);
            rec.setOpinion(perm, opinion);
        }
        if (!rec.isEmpty()) {
            this.computeDerivedValues(rec, bundle.getOptimizerStructure());
        }
        return rec;
    }

    private void computeDerivedValues(ProfileRecommendation rec, ProfileOptimizerStructure optimizerStructure) {
        rec.normalizeOpinions();
        rec.computeScores(optimizerStructure.profileChangeWeight, optimizerStructure.bundleValueWeight);
        rec.computeUtilities();
        rec.computeProbabilities(optimizerStructure.rationalityFactor);
    }

    private double computeProfileUsageCharge(CapacityProfile profile, List<TariffSubscription> subscriptions, CapacityOriginator capacityOriginator) {
        Timeslot timeslot = this.timeslotRepo.currentTimeslot();
        double totalCharge = 0.0;
        for (int i = 0; i < 24; ++i) {
            double totalTimeslotUsage = profile.getCapacity(i);
            double timeslotCharge = 0.0;
            for (TariffSubscription subscription : subscriptions) {
                double subTimeslotUsage = capacityOriginator.adjustCapacityForSubscription(timeslot, totalTimeslotUsage, subscription);
                timeslotCharge += subscription.getTariff().getUsageCharge(timeslot.getStartInstant(), subTimeslotUsage, 0.0);
            }
            totalCharge += timeslotCharge;
            timeslot = timeslot.getNext();
        }
        return totalCharge;
    }

    private boolean isPermutationAcceptable(CapacityOriginator capacityOriginator, ProfileOptimizerStructure optimizerStructure, double permCharge, double forecastCharge) {
        Double threshold = null;
        switch (optimizerStructure.usageChargeStance) {
            case NEUTRAL: {
                return true;
            }
            case BENEFIT: {
                threshold = capacityOriginator.getParentBundle().getCustomerInfo().getPowerType().isConsumption() ? Double.valueOf((1.0 - optimizerStructure.usageChargePercentBenefit) * forecastCharge) : Double.valueOf((1.0 + optimizerStructure.usageChargePercentBenefit) * forecastCharge);
            }
            case THRESHOLD: {
                if (threshold == null) {
                    threshold = optimizerStructure.usageChargeThreshold;
                }
                return permCharge > threshold;
            }
        }
        throw new Error("Unexpected case in usage charge stance: " + (Object)((Object)optimizerStructure.usageChargeStance));
    }

    private void reconcileRecommendations(List<TariffSubscription> subscriptions, Map<CapacityOriginator, ForecastRecord> forecasts, Map<CapacityOriginator, List<CapacityProfile>> perms, Map<CapacityOriginator, ProfileRecommendation> recs) {
        for (Map.Entry<CapacityOriginator, ProfileRecommendation> targetEntry : recs.entrySet()) {
            CapacityOriginator targetOriginator = targetEntry.getKey();
            ProfileRecommendation targetRec = targetEntry.getValue();
            if (targetRec.isEmpty() || targetOriginator.getParentBundle().getCapacityOriginators().size() == 1) continue;
            double[] othersCapacities = new double[24];
            int s = 0;
            while ((double)s < 30.0) {
                for (Map.Entry<CapacityOriginator, ProfileRecommendation> otherEntry : recs.entrySet()) {
                    ProfileRecommendation otherRec = otherEntry.getValue();
                    CapacityProfile otherProfile = otherRec.isEmpty() ? forecasts.get((Object)otherEntry.getKey()).capacityProfile : this.drawProfileFromRecommendation(otherRec);
                    for (int i = 0; i < 24; ++i) {
                        int n = i;
                        othersCapacities[n] = othersCapacities[n] + otherProfile.getCapacity(i);
                        if ((double)s != 30.0) continue;
                        othersCapacities[i] = othersCapacities[i] / 30.0;
                    }
                }
                ++s;
            }
            CapacityProfile forecastProfile = forecasts.get((Object)targetOriginator).capacityProfile;
            double forecastVariance = this.computeAggregateVariance(forecastProfile, othersCapacities);
            for (Map.Entry<CapacityProfile, ProfileRecommendation.Opinion> opinionEntry : targetRec.getOpinions().entrySet()) {
                double bundleValue;
                CapacityProfile targetProfile = opinionEntry.getKey();
                double targetVariance = this.computeAggregateVariance(targetProfile, othersCapacities);
                opinionEntry.getValue().bundleValue = bundleValue = forecastVariance / targetVariance;
            }
            this.computeDerivedValues(targetRec, targetOriginator.getParentBundle().getOptimizerStructure());
        }
    }

    private double computeAggregateVariance(CapacityProfile profile, double[] otherCapacities) {
        double[] aggCapacities = new double[24];
        for (int i = 0; i < 24; ++i) {
            aggCapacities[i] = profile.getCapacity(i) + otherCapacities[i];
        }
        return new Variance().evaluate(aggCapacities);
    }

    private CapacityProfile drawProfileFromRecommendation(ProfileRecommendation rec) {
        double draw = this.recommendationMaker.nextFloat();
        double sumProb = 0.0;
        for (Map.Entry<CapacityProfile, Double> entry : rec.getProbabilities().entrySet()) {
            if (!(draw < (sumProb += entry.getValue().doubleValue()))) continue;
            return entry.getKey();
        }
        throw new Error("Drawing from recommendation resulted in a null profile!");
    }

    private void logRecommendationDetails(String msg) {
        this.log.debug((Object)msg);
    }

    private class ForecastRecord {
        CapacityProfile capacityProfile;
        double usageCharge;

        ForecastRecord(CapacityProfile p, double c) {
            this.capacityProfile = p;
            this.usageCharge = c;
        }
    }
}

