/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.Random;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.BetaDistributionImpl;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.apache.commons.math.distribution.CauchyDistributionImpl;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.apache.commons.math.distribution.ExponentialDistributionImpl;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.apache.commons.math.distribution.GammaDistributionImpl;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.commons.math.distribution.PoissonDistributionImpl;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.distribution.WeibullDistributionImpl;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.spring.SpringApplicationContext;
import org.w3c.dom.Element;

final class ProbabilityDistribution {
    private RandomSeedRepo randomSeedRepo;
    private static long distCounter = 0L;
    private final long distId = ++distCounter;
    private final DistType type;
    private final Sampler sampler;
    private double param1;
    private double param2;
    private double param3;
    private double param4;

    ProbabilityDistribution(Element xml) {
        this.randomSeedRepo = (RandomSeedRepo)SpringApplicationContext.getBean((String)"randomSeedRepo");
        this.type = Enum.valueOf(DistType.class, xml.getAttribute("distribution"));
        switch (this.type) {
            case POINTMASS: 
            case DEGENERATE: {
                this.param1 = Double.parseDouble(xml.getAttribute("value"));
                this.sampler = new DegenerateSampler(this.param1);
                break;
            }
            case UNIFORM: {
                this.param1 = Double.parseDouble(xml.getAttribute("low"));
                this.param2 = Double.parseDouble(xml.getAttribute("high"));
                this.sampler = new UniformSampler(this.param1, this.param2);
                break;
            }
            case INTERVAL: {
                this.param1 = Double.parseDouble(xml.getAttribute("mean"));
                this.param2 = Double.parseDouble(xml.getAttribute("stdDev"));
                this.param3 = Double.parseDouble(xml.getAttribute("low"));
                this.param4 = Double.parseDouble(xml.getAttribute("high"));
                this.sampler = new IntervalSampler(this.param1, this.param2, this.param3, this.param4);
                break;
            }
            case NORMAL: 
            case GAUSSIAN: {
                this.param1 = Double.parseDouble(xml.getAttribute("mean"));
                this.param2 = Double.parseDouble(xml.getAttribute("stdDev"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new NormalDistributionImpl(this.param1, this.param2));
                break;
            }
            case STDNORMAL: {
                this.param1 = 0.0;
                this.param2 = 1.0;
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new NormalDistributionImpl(this.param1, this.param2));
                break;
            }
            case LOGNORMAL: {
                this.param1 = Double.parseDouble(xml.getAttribute("expMean"));
                this.param2 = Double.parseDouble(xml.getAttribute("expStdDev"));
                this.sampler = new LogNormalSampler(this.param1, this.param2);
                break;
            }
            case CAUCHY: {
                this.param1 = Double.parseDouble(xml.getAttribute("median"));
                this.param2 = Double.parseDouble(xml.getAttribute("scale"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new CauchyDistributionImpl(this.param1, this.param2));
                break;
            }
            case BETA: {
                this.param1 = Double.parseDouble(xml.getAttribute("alpha"));
                this.param2 = Double.parseDouble(xml.getAttribute("beta"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new BetaDistributionImpl(this.param1, this.param2));
                break;
            }
            case BINOMIAL: {
                this.param1 = Double.parseDouble(xml.getAttribute("trials"));
                this.param2 = Double.parseDouble(xml.getAttribute("success"));
                this.sampler = new DiscreteSampler((AbstractIntegerDistribution)new BinomialDistributionImpl((int)this.param1, this.param2));
                break;
            }
            case POISSON: {
                this.param1 = Double.parseDouble(xml.getAttribute("lambda"));
                this.sampler = new DiscreteSampler((AbstractIntegerDistribution)new PoissonDistributionImpl(this.param1));
                break;
            }
            case CHISQUARED: {
                this.param1 = Double.parseDouble(xml.getAttribute("dof"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new ChiSquaredDistributionImpl(this.param1));
                break;
            }
            case EXPONENTIAL: {
                this.param1 = Double.parseDouble(xml.getAttribute("mean"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new ExponentialDistributionImpl(this.param1));
                break;
            }
            case GAMMA: {
                this.param1 = Double.parseDouble(xml.getAttribute("alpha"));
                this.param2 = Double.parseDouble(xml.getAttribute("beta"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new GammaDistributionImpl(this.param1, this.param2));
                break;
            }
            case WEIBULL: {
                this.param1 = Double.parseDouble(xml.getAttribute("alpha"));
                this.param2 = Double.parseDouble(xml.getAttribute("beta"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new WeibullDistributionImpl(this.param1, this.param2));
                break;
            }
            case STUDENT: {
                this.param1 = Double.parseDouble(xml.getAttribute("dof"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new TDistributionImpl(this.param1));
                break;
            }
            case SNEDECOR: {
                this.param1 = Double.parseDouble(xml.getAttribute("d1"));
                this.param2 = Double.parseDouble(xml.getAttribute("d2"));
                this.sampler = new ContinuousSampler((AbstractContinuousDistribution)new FDistributionImpl(this.param1, this.param2));
                break;
            }
            default: {
                throw new Error("Invalid probability distribution type!");
            }
        }
        this.sampler.reseedRandomGenerator(this.randomSeedRepo.getRandomSeed("factoredcustomer.ProbabilityDistribution", this.distId, "Sampler").getValue());
    }

    double drawSample() {
        try {
            return this.sampler.sample();
        }
        catch (MathException e) {
            System.err.println("ProbabilityDistribution(" + this.toString() + ") - drawSample():" + this.toString() + " Caught MathException:\n");
            e.printStackTrace(System.err);
            throw new Error("ProbabilityDistribution(" + this.toString() + ") - drawSample(): Caught MathException: " + e.toString());
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.distId + ":" + (Object)((Object)this.type) + "(" + this.param1 + ", " + this.param2 + ", " + this.param3 + ", " + this.param4 + ")";
    }

    final class ContinuousSampler
    implements Sampler {
        final AbstractContinuousDistribution impl;

        ContinuousSampler(AbstractContinuousDistribution i) {
            this.impl = i;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.impl.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() throws MathException {
            return this.impl.sample();
        }
    }

    final class DiscreteSampler
    implements Sampler {
        final AbstractIntegerDistribution impl;

        DiscreteSampler(AbstractIntegerDistribution i) {
            this.impl = i;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.impl.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() throws MathException {
            return this.impl.sample();
        }
    }

    final class LogNormalSampler
    implements Sampler {
        final NormalDistributionImpl normalSampler;

        LogNormalSampler(double m, double s) {
            this.normalSampler = new NormalDistributionImpl(Math.log(m), Math.log(s));
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.normalSampler.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() throws MathException {
            return Math.exp(this.normalSampler.sample());
        }
    }

    final class IntervalSampler
    implements Sampler {
        final double low;
        final double high;
        final NormalDistributionImpl normalSampler;

        IntervalSampler(double m, double s, double l, double h) {
            this.normalSampler = new NormalDistributionImpl(m, s);
            this.low = l;
            this.high = h;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.normalSampler.reseedRandomGenerator(seed);
        }

        @Override
        public double sample() throws MathException {
            return Math.min(this.high, Math.max(this.low, this.normalSampler.sample()));
        }
    }

    final class UniformSampler
    implements Sampler {
        final Random random;
        final double low;
        final int range;

        UniformSampler(double l, double h) {
            this.low = l;
            this.range = this.safeLongToInt(Math.round(h - this.low));
            this.random = new Random();
        }

        @Override
        public void reseedRandomGenerator(long seed) {
            this.random.setSeed(seed);
        }

        @Override
        public double sample() throws MathException {
            return this.low + (double)this.random.nextInt(this.range);
        }

        protected int safeLongToInt(long x) {
            if (x < Integer.MIN_VALUE || x > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(x + " cannot be cast to int without changing its value.");
            }
            return (int)x;
        }
    }

    final class DegenerateSampler
    implements Sampler {
        final double value;

        DegenerateSampler(double v) {
            this.value = v;
        }

        @Override
        public void reseedRandomGenerator(long seed) {
        }

        @Override
        public double sample() throws MathException {
            return this.value;
        }
    }

    static interface Sampler {
        public void reseedRandomGenerator(long var1);

        public double sample() throws MathException;
    }

    static enum DistType {
        DEGENERATE,
        POINTMASS,
        UNIFORM,
        INTERVAL,
        NORMAL,
        GAUSSIAN,
        STDNORMAL,
        LOGNORMAL,
        CAUCHY,
        BETA,
        BINOMIAL,
        POISSON,
        CHISQUARED,
        EXPONENTIAL,
        GAMMA,
        WEIBULL,
        STUDENT,
        SNEDECOR;

    }
}

