/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.w3c.dom.Element;

public final class ProfileOptimizerStructure {
    private static final double DEFAULT_REACTIVITY_FACTOR = 1.0;
    private static final double DEFAULT_RECEPTIVITY_FACTOR = 1.0;
    private static final double DEFAULT_RATIONALITY_FACTOR = 1.0;
    private static final UsageChargeStance DEFAULT_USAGE_CHARGE_STANCE = UsageChargeStance.BENEFIT;
    private static final double DEFAULT_USAGE_CHARGE_PERCENT_BENEFIT = 0.01;
    private static final double DEFAULT_PROFILE_CHANGE_WEIGHT = -1.0;
    private static final double DEFAULT_BUNDLE_VALUE_WEIGHT = 10.0;
    private final CustomerStructure customerStructure;
    private final CapacityBundle capacityBundle;
    final boolean receiveRecommendations;
    final CapacityProfile.PermutationRule permutationRule;
    final boolean raconcileRecommendations;
    final ProfileSelectionMethod profileSelectionMethod = ProfileSelectionMethod.LOGIT_CHOICE;
    final double reactivityFactor;
    final double receptivityFactor;
    final double rationalityFactor;
    final UsageChargeStance usageChargeStance;
    final double usageChargePercentBenefit;
    final double usageChargeThreshold;
    final double profileChangeWeight;
    final double bundleValueWeight;

    ProfileOptimizerStructure(CustomerStructure structure, CapacityBundle bundle, Element xml) {
        this.customerStructure = structure;
        this.capacityBundle = bundle;
        if (xml == null) {
            this.receiveRecommendations = false;
            this.raconcileRecommendations = false;
            this.permutationRule = null;
            this.reactivityFactor = 1.0;
            this.receptivityFactor = 1.0;
            this.rationalityFactor = 1.0;
            this.usageChargeStance = DEFAULT_USAGE_CHARGE_STANCE;
            this.usageChargePercentBenefit = 0.01;
            this.usageChargeThreshold = Double.NaN;
            this.profileChangeWeight = -1.0;
            this.bundleValueWeight = 10.0;
        } else {
            this.receiveRecommendations = Boolean.parseBoolean(xml.getAttribute("recommendation"));
            this.raconcileRecommendations = Boolean.parseBoolean(xml.getAttribute("reconcile"));
            this.permutationRule = Enum.valueOf(CapacityProfile.PermutationRule.class, xml.getAttribute("permutationRule"));
            Element responseFactorsElement = (Element)xml.getElementsByTagName("responseFactors").item(0);
            this.reactivityFactor = Double.parseDouble(responseFactorsElement.getAttribute("reactivity"));
            this.receptivityFactor = Double.parseDouble(responseFactorsElement.getAttribute("receptivity"));
            this.rationalityFactor = Double.parseDouble(responseFactorsElement.getAttribute("rationality"));
            Element constraintsElement = (Element)xml.getElementsByTagName("constraints").item(0);
            this.usageChargeStance = Enum.valueOf(UsageChargeStance.class, constraintsElement.getAttribute("usageChargeStance"));
            String percentBenefitString = constraintsElement.getAttribute("percentBenefit");
            this.usageChargePercentBenefit = percentBenefitString.isEmpty() ? Double.NaN : Double.parseDouble(percentBenefitString);
            String thresholdString = constraintsElement.getAttribute("threshold");
            this.usageChargeThreshold = thresholdString.isEmpty() ? Double.NaN : Double.parseDouble(thresholdString);
            Element scoringWeightsElement = (Element)xml.getElementsByTagName("scoringWeights").item(0);
            this.profileChangeWeight = Double.parseDouble(scoringWeightsElement.getAttribute("profileChange"));
            this.bundleValueWeight = Double.parseDouble(scoringWeightsElement.getAttribute("bundleValue"));
        }
    }

    CustomerStructure getCustomerStructure() {
        return this.customerStructure;
    }

    CapacityBundle getCapacityBundle() {
        return this.capacityBundle;
    }

    static enum ProfileSelectionMethod {
        BEST_UTILITY,
        LOGIT_CHOICE;

    }

    static enum UsageChargeStance {
        NEUTRAL,
        BENEFIT,
        THRESHOLD;

    }
}

