/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.ParserFunctions;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class TariffSubscriberStructure {
    private final CustomerStructure customerStructure;
    private final CapacityBundle capacityBundle;
    final boolean benchmarkRiskEnabled;
    final double benchmarkRiskRatio;
    final boolean tariffThrottlingEnabled;
    final double interruptibilityDiscount;
    final Double expMeanPriceWeight;
    final Double maxValuePriceWeight;
    final Double realizedPriceWeight;
    final AllocationMethod allocationMethod;
    final List<List<Double>> totalOrderRules = new ArrayList<List<Double>>();
    final double logitChoiceRationality;
    final int reconsiderationPeriod;
    final ProbabilityDistribution inertiaDistribution;
    final ProbabilityDistribution customerWealthDistribution;
    final double customerWealthReferenceMedian;
    final ProbabilityDistribution newTariffsExposure;
    final ProbabilityDistribution switchingDelay;
    final ProbabilityDistribution waitAfterSwitch;

    TariffSubscriberStructure(CustomerStructure structure, CapacityBundle bundle, Element xml) {
        this.customerStructure = structure;
        this.capacityBundle = bundle;
        Element constraintsElement = (Element)xml.getElementsByTagName("constraints").item(0);
        if (constraintsElement != null) {
            Element benchmarkRiskElement = (Element)constraintsElement.getElementsByTagName("benchmarkRisk").item(0);
            if (benchmarkRiskElement != null) {
                this.benchmarkRiskEnabled = Boolean.parseBoolean(benchmarkRiskElement.getAttribute("enable"));
                double[][] ratio = ParserFunctions.parseMapToDoubleArray(benchmarkRiskElement.getAttribute("ratio"));
                this.benchmarkRiskRatio = ratio[0][0] / ratio[0][1];
            } else {
                this.benchmarkRiskEnabled = false;
                this.benchmarkRiskRatio = Double.NaN;
            }
            Element tariffThrottlingElement = (Element)constraintsElement.getElementsByTagName("tariffThrottling").item(0);
            this.tariffThrottlingEnabled = tariffThrottlingElement != null ? Boolean.parseBoolean(tariffThrottlingElement.getAttribute("enable")) : false;
        } else {
            throw new Error("Tariff subscriber constraints element must be included, even if empty.");
        }
        Element influenceFactorsElement = (Element)xml.getElementsByTagName("influenceFactors").item(0);
        if (influenceFactorsElement != null) {
            Element interruptibilityElement = (Element)influenceFactorsElement.getElementsByTagName("interruptibility").item(0);
            this.interruptibilityDiscount = interruptibilityElement != null ? Double.parseDouble(interruptibilityElement.getAttribute("discount")) : 0.0;
            Element priceWeightsElement = (Element)influenceFactorsElement.getElementsByTagName("priceWeights").item(0);
            if (priceWeightsElement != null) {
                this.expMeanPriceWeight = Double.parseDouble(priceWeightsElement.getAttribute("expMean"));
                this.maxValuePriceWeight = Double.parseDouble(priceWeightsElement.getAttribute("maxValue"));
                this.realizedPriceWeight = Double.parseDouble(priceWeightsElement.getAttribute("realized"));
            } else {
                this.expMeanPriceWeight = null;
                this.maxValuePriceWeight = null;
                this.realizedPriceWeight = null;
            }
        } else {
            throw new Error("Tariff subscriber influence factors element must be included, even if empty.");
        }
        Element allocationElement = (Element)xml.getElementsByTagName("allocation").item(0);
        this.allocationMethod = Enum.valueOf(AllocationMethod.class, allocationElement.getAttribute("method"));
        if (this.allocationMethod == AllocationMethod.TOTAL_ORDER) {
            Element totalOrderElement = (Element)allocationElement.getElementsByTagName("totalOrder").item(0);
            this.populateTotalOrderRules(totalOrderElement.getAttribute("rules"));
            this.logitChoiceRationality = 1.0;
        } else {
            Element logitChoiceElement = (Element)allocationElement.getElementsByTagName("logitChoice").item(0);
            this.logitChoiceRationality = Double.parseDouble(logitChoiceElement.getAttribute("rationality"));
        }
        Element reconsiderationElement = (Element)xml.getElementsByTagName("reconsideration").item(0);
        this.reconsiderationPeriod = Integer.parseInt(reconsiderationElement.getAttribute("period"));
        Element inertiaElement = (Element)xml.getElementsByTagName("switchingInertia").item(0);
        Node inertiaDistributionNode = inertiaElement.getElementsByTagName("inertiaDistribution").item(0);
        if (inertiaDistributionNode != null) {
            Element inertiaDistributionElement = (Element)inertiaDistributionNode;
            this.inertiaDistribution = new ProbabilityDistribution(inertiaDistributionElement);
            this.customerWealthDistribution = null;
            this.customerWealthReferenceMedian = 0.0;
            this.newTariffsExposure = null;
            this.switchingDelay = null;
            this.waitAfterSwitch = null;
        } else {
            this.inertiaDistribution = null;
            Node inertiaFactorsNode = inertiaElement.getElementsByTagName("inertiaFactors").item(0);
            if (inertiaFactorsNode == null) {
                throw new Error("TariffSubscriberStructure(): Inertia distribution and factors are both undefined!");
            }
            Element inertiaFactorsElement = (Element)inertiaFactorsNode;
            Element customerWealthElement = (Element)inertiaFactorsElement.getElementsByTagName("customerWealth").item(0);
            this.customerWealthDistribution = new ProbabilityDistribution(customerWealthElement);
            this.customerWealthReferenceMedian = Double.parseDouble(customerWealthElement.getAttribute("referenceMedian"));
            Element newTariffsExposureElement = (Element)inertiaFactorsElement.getElementsByTagName("newTariffsExposure").item(0);
            this.newTariffsExposure = new ProbabilityDistribution(newTariffsExposureElement);
            Element switchingDelayElement = (Element)inertiaFactorsElement.getElementsByTagName("switchingDelay").item(0);
            this.switchingDelay = new ProbabilityDistribution(switchingDelayElement);
            Element waitAfterSwitchElement = (Element)inertiaFactorsElement.getElementsByTagName("waitAfterSwitch").item(0);
            this.waitAfterSwitch = new ProbabilityDistribution(waitAfterSwitchElement);
        }
    }

    private void populateTotalOrderRules(String config) {
        String[] rules = config.split(",");
        ArrayList<Double> degenerateRule = new ArrayList<Double>(1);
        degenerateRule.add(1.0);
        this.totalOrderRules.add(degenerateRule);
        for (int i = 0; i < rules.length; ++i) {
            if (rules[i].length() <= 0) continue;
            String[] vals = rules[i].split(":");
            ArrayList<Double> rule = new ArrayList<Double>(vals.length);
            for (int j = 0; j < vals.length; ++j) {
                rule.add(Double.parseDouble(vals[j]));
            }
            this.totalOrderRules.add(rule);
        }
    }

    CustomerStructure getCustomerStructure() {
        return this.customerStructure;
    }

    CapacityBundle getCapacityBundle() {
        return this.capacityBundle;
    }

    static enum AllocationMethod {
        TOTAL_ORDER,
        LOGIT_CHOICE;

    }
}

