/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.powertac.common.state.Domain;
import org.powertac.common.state.StateChange;
import org.powertac.factoredcustomer.CapacityProfile;

@Domain
public class ProfileRecommendation {
    private static final double UTILITY_RANGE_MAX_VALUE = 3.0;
    private final Map<CapacityProfile, Opinion> opinions;
    private final Map<CapacityProfile, Double> scores = new HashMap<CapacityProfile, Double>();
    private final Map<CapacityProfile, Double> utilities = new HashMap<CapacityProfile, Double>();
    private final Map<CapacityProfile, Double> probabilities = new HashMap<CapacityProfile, Double>();

    ProfileRecommendation() {
        this.opinions = new HashMap<CapacityProfile, Opinion>();
    }

    ProfileRecommendation(Map<CapacityProfile, Opinion> map) {
        this.opinions = map;
    }

    @StateChange
    public void setOpinion(CapacityProfile profile, Opinion opinion) {
        this.opinions.put(profile, opinion);
    }

    public Map<CapacityProfile, Opinion> getOpinions() {
        return this.opinions;
    }

    @StateChange
    public void setScore(CapacityProfile profile, Double score) {
        this.scores.put(profile, score);
    }

    public Map<CapacityProfile, Double> getScores() {
        return this.scores;
    }

    public Map<CapacityProfile, Double> getUtilities() {
        return this.utilities;
    }

    public Map<CapacityProfile, Double> getProbabilities() {
        return this.probabilities;
    }

    public boolean isEmpty() {
        return this.opinions.size() == 0;
    }

    @StateChange
    public void normalizeOpinions() {
        double sumUsageCharge = 0.0;
        double sumProfileChange = 0.0;
        double sumBundleValue = 0.0;
        for (Opinion opinion : this.opinions.values()) {
            sumUsageCharge += opinion.usageCharge;
            sumProfileChange += opinion.profileChange;
            sumBundleValue += opinion.bundleValue;
        }
        for (Opinion opinion : this.opinions.values()) {
            opinion.normUsageCharge = sumUsageCharge == 0.0 ? 0.0 : opinion.usageCharge / sumUsageCharge;
            opinion.normProfileChange = sumProfileChange == 0.0 ? 0.0 : opinion.profileChange / sumProfileChange;
            opinion.normBundleValue = sumBundleValue == 0.0 ? 0.0 : opinion.bundleValue / sumBundleValue;
        }
    }

    public void computeScores(Map<ScoringFactor, Double> weights) {
        this.computeScores(weights.get((Object)ScoringFactor.PROFILE_CHANGE), weights.get((Object)ScoringFactor.BUNDLE_VALUE));
    }

    @StateChange
    public void computeScores(double profileChangeWeight, double bundleValueWeight) {
        for (CapacityProfile profile : this.opinions.keySet()) {
            Opinion opinion = this.opinions.get(profile);
            double usageChargeScoringSign = opinion.normUsageCharge > 0.0 ? 1.0 : -1.0;
            Double score = usageChargeScoringSign * opinion.normUsageCharge + profileChangeWeight * opinion.normProfileChange + bundleValueWeight * opinion.normBundleValue;
            this.scores.put(profile, score);
        }
    }

    @StateChange
    public void computeUtilities() {
        if (this.scores.size() == 1) {
            this.utilities.put(this.scores.keySet().iterator().next(), 3.0);
            return;
        }
        double best = Collections.max(this.scores.values());
        double worst = Collections.max(this.scores.values());
        double sum = 0.0;
        for (Double score : this.scores.values()) {
            sum += score.doubleValue();
        }
        double mean = sum / (double)this.scores.size();
        double basis = Math.max(best - mean, mean - worst);
        if (Math.abs(basis - 0.0) < 1.0E-4) {
            for (Map.Entry<CapacityProfile, Double> entry : this.scores.entrySet()) {
                this.utilities.put(entry.getKey(), 3.0);
            }
        } else {
            for (Map.Entry<CapacityProfile, Double> entry : this.scores.entrySet()) {
                double utility = (entry.getValue() - mean) / basis * 3.0;
                this.utilities.put(entry.getKey(), utility);
            }
        }
    }

    @StateChange
    public void computeProbabilities(double rationality) {
        double numerator;
        double denominator = 0.0;
        for (Map.Entry<CapacityProfile, Double> entry : this.utilities.entrySet()) {
            numerator = Math.exp(rationality * this.utilities.get(entry.getKey()));
            this.probabilities.put(entry.getKey(), numerator);
            denominator += numerator;
        }
        for (Map.Entry<CapacityProfile, Double> entry : this.probabilities.entrySet()) {
            numerator = entry.getValue();
            double probability = numerator / denominator;
            if (Double.isNaN(probability)) {
                System.err.println(this.getClass().getCanonicalName() + ": Computed probability is NaN!");
                System.err.println("  *** opinions: " + this.opinions.keySet() + ": " + this.opinions.values());
                System.err.println("  *** scores: " + this.scores.keySet() + ": " + this.scores.values());
                System.err.println("  *** utilities: " + this.utilities.keySet() + ": " + this.utilities.values());
                System.err.println("  *** probabilities: " + this.probabilities.keySet() + ": " + this.probabilities.values());
                throw new Error("Computed probability is NaN!");
            }
            entry.setValue(probability);
        }
    }

    public static interface Listener {
        public void handleProfileRecommendation(ProfileRecommendation var1);
    }

    public class Opinion {
        double usageCharge;
        double profileChange;
        double bundleValue;
        double normUsageCharge;
        double normProfileChange;
        double normBundleValue;

        public String toString() {
            return "Opinion:[" + this.usageCharge + ", " + this.profileChange + ", " + this.bundleValue + ", " + this.normUsageCharge + ", " + this.normProfileChange + ", " + this.normBundleValue + "]";
        }
    }

    static enum ScoringFactor {
        USAGE_CHARGE,
        PROFILE_CHANGE,
        BUNDLE_VALUE;

    }
}

