/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CapacityStructure;
import org.powertac.factoredcustomer.DefaultCapacityBundle;
import org.powertac.factoredcustomer.DefaultCapacityOriginator;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ProfileOptimizerStructure;
import org.powertac.factoredcustomer.ProfileRecommendation;
import org.powertac.factoredcustomer.utils.SeedIdGenerator;

@Domain
final class AdaptiveCapacityOriginator
extends DefaultCapacityOriginator
implements ProfileRecommendation.Listener {
    private final ProfileOptimizerStructure optimizerStructure;
    private final Random recommendationHandler;

    AdaptiveCapacityOriginator(FactoredCustomerService service, CapacityStructure capacityStructure, DefaultCapacityBundle bundle) {
        super(service, capacityStructure, bundle);
        this.log = Logger.getLogger((String)AdaptiveCapacityOriginator.class.getName());
        this.optimizerStructure = this.getParentBundle().getOptimizerStructure();
        this.recommendationHandler = new Random(service.getRandomSeedRepo().getRandomSeed("factoredcustomer.AdaptiveCapacityOriginator", (long)SeedIdGenerator.getId(), "RecommendationHandler").getValue());
    }

    @Override
    public void handleProfileRecommendation(ProfileRecommendation globalRec) {
        ProfileRecommendation localRec;
        double draw1 = this.recommendationHandler.nextFloat();
        if (draw1 > this.optimizerStructure.reactivityFactor) {
            this.log.info((Object)(this.logIdentifier + ": Ignoring received profile recommendation"));
            return;
        }
        double draw2 = this.recommendationHandler.nextFloat();
        if (draw2 < this.optimizerStructure.receptivityFactor) {
            this.log.info((Object)(this.logIdentifier + ": Adopting profile recommendation as received"));
            localRec = globalRec;
        } else {
            localRec = new ProfileRecommendation(globalRec.getOpinions());
            HashMap<ProfileRecommendation.ScoringFactor, Double> weights = new HashMap<ProfileRecommendation.ScoringFactor, Double>();
            weights.put(ProfileRecommendation.ScoringFactor.PROFILE_CHANGE, this.optimizerStructure.profileChangeWeight);
            weights.put(ProfileRecommendation.ScoringFactor.BUNDLE_VALUE, this.optimizerStructure.bundleValueWeight);
            localRec.computeScores(weights);
            localRec.computeUtilities();
            localRec.computeProbabilities(this.optimizerStructure.rationalityFactor);
        }
        CapacityProfile chosenProfile = this.optimizerStructure.profileSelectionMethod == ProfileOptimizerStructure.ProfileSelectionMethod.BEST_UTILITY ? this.selectBestProfileInRecommendation(localRec) : this.drawProfileFromRecommendation(localRec);
        this.overwriteForecastCapacities(this.service.getTimeslotRepo().currentTimeslot(), chosenProfile);
    }

    private CapacityProfile selectBestProfileInRecommendation(ProfileRecommendation rec) {
        double bestUtility = Double.MIN_VALUE;
        CapacityProfile bestProfile = null;
        for (Map.Entry<CapacityProfile, Double> entry : rec.getUtilities().entrySet()) {
            if (!(entry.getValue() > bestUtility)) continue;
            bestUtility = entry.getValue();
            bestProfile = entry.getKey();
        }
        if (bestProfile == null) {
            throw new Error("Best profile in recommendation is null!");
        }
        return bestProfile;
    }

    private CapacityProfile drawProfileFromRecommendation(ProfileRecommendation rec) {
        double draw = this.recommendationHandler.nextFloat();
        double sumProb = 0.0;
        for (Map.Entry<CapacityProfile, Double> entry : rec.getProbabilities().entrySet()) {
            if (!(draw < (sumProb += entry.getValue().doubleValue()))) continue;
            return entry.getKey();
        }
        throw new Error("Drawing from recommendation resulted in a null profile!");
    }

    private void overwriteForecastCapacities(Timeslot timeslot, CapacityProfile profile) {
        Timeslot slider = timeslot;
        for (int i = 0; i < 24; ++i) {
            this.forecastCapacities.put(slider.getSerialNumber(), profile.getCapacity(i));
            slider = this.service.getTimeslotRepo().getNext(slider);
        }
    }

    @Override
    public double useCapacity(TariffSubscription subscription) {
        int timeslot = this.service.getTimeslotRepo().currentSerialNumber();
        double forecastCapacity = this.getForecastCapacity(timeslot);
        this.logCapacityDetails(this.logIdentifier + ": Forecast capacity being used for timeslot " + timeslot + " = " + forecastCapacity);
        double adjustedCapacity = forecastCapacity;
        adjustedCapacity = this.adjustCapacityForSubscription(timeslot, adjustedCapacity, subscription);
        if (Double.isNaN(adjustedCapacity)) {
            throw new Error("Adjusted capacity is NaN for forecast capacity = " + forecastCapacity);
        }
        adjustedCapacity = this.truncateTo2Decimals(adjustedCapacity);
        this.actualCapacities.put(timeslot, adjustedCapacity);
        this.log.info((Object)(this.logIdentifier + ": Adjusted capacity for tariff " + subscription.getTariff().getId() + " = " + adjustedCapacity));
        return adjustedCapacity;
    }
}

