/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.HashMap;
import java.util.Map;
import org.powertac.factoredcustomer.DefaultCapacityBundle;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ParserFunctions;
import org.powertac.factoredcustomer.ProbabilityDistribution;
import org.powertac.factoredcustomer.TimeseriesStructure;
import org.w3c.dom.Element;

public final class CapacityStructure {
    final String capacityName;
    final String description;
    final BaseCapacityType baseCapacityType;
    final ProbabilityDistribution basePopulationCapacity;
    final ProbabilityDistribution baseIndividualCapacity;
    final TimeseriesStructure baseTimeseriesStructure;
    final double[] dailySkew;
    final double[] hourlySkew;
    final InfluenceKind temperatureInfluence;
    final Map<Integer, Double> temperatureMap = new HashMap<Integer, Double>();
    final double temperatureReference;
    final InfluenceKind windSpeedInfluence;
    final Map<Integer, Double> windSpeedMap = new HashMap<Integer, Double>();
    final InfluenceKind windDirectionInfluence;
    final Map<Integer, Double> windDirectionMap = new HashMap<Integer, Double>();
    final InfluenceKind cloudCoverInfluence;
    final Map<Integer, Double> cloudCoverMap = new HashMap<Integer, Double>();
    final Map<Integer, Double> benchmarkRates = new HashMap<Integer, Double>();
    final ElasticityModelType elasticityModelType;
    final Element elasticityModelXml;
    final double[] curtailmentShifts;

    CapacityStructure(FactoredCustomerService service, String name, Element xml, DefaultCapacityBundle bundle) {
        this.capacityName = name;
        this.description = xml.getAttribute("description");
        Element baseCapacityElement = (Element)xml.getElementsByTagName("baseCapacity").item(0);
        this.baseCapacityType = Enum.valueOf(BaseCapacityType.class, baseCapacityElement.getAttribute("type"));
        switch (this.baseCapacityType) {
            case POPULATION: {
                Element populationCapacityElement = (Element)baseCapacityElement.getElementsByTagName("populationCapacity").item(0);
                this.basePopulationCapacity = new ProbabilityDistribution(service, populationCapacityElement);
                this.baseIndividualCapacity = null;
                this.baseTimeseriesStructure = null;
                break;
            }
            case INDIVIDUAL: {
                this.basePopulationCapacity = null;
                Element individualCapacityElement = (Element)baseCapacityElement.getElementsByTagName("individualCapacity").item(0);
                this.baseIndividualCapacity = new ProbabilityDistribution(service, individualCapacityElement);
                this.baseTimeseriesStructure = null;
                break;
            }
            case TIMESERIES: {
                this.basePopulationCapacity = null;
                this.baseIndividualCapacity = null;
                Element timeseriesModelElement = (Element)baseCapacityElement.getElementsByTagName("timeseriesModel").item(0);
                this.baseTimeseriesStructure = new TimeseriesStructure(timeseriesModelElement);
                break;
            }
            default: {
                throw new Error("Unexpected base capacity type: " + (Object)((Object)this.baseCapacityType));
            }
        }
        Element dailySkewElement = (Element)xml.getElementsByTagName("dailySkew").item(0);
        this.dailySkew = ParserFunctions.parseDoubleArray(dailySkewElement.getAttribute("array"));
        Element hourlySkewElement = (Element)xml.getElementsByTagName("hourlySkew").item(0);
        this.hourlySkew = ParserFunctions.parseDoubleArray(hourlySkewElement.getAttribute("array"));
        Element temperatureInfluenceElement = (Element)xml.getElementsByTagName("temperature").item(0);
        this.temperatureInfluence = Enum.valueOf(InfluenceKind.class, temperatureInfluenceElement.getAttribute("influence"));
        if (this.temperatureInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(temperatureInfluenceElement.getAttribute("rangeMap"), this.temperatureMap);
            this.temperatureReference = this.temperatureInfluence == InfluenceKind.DEVIATION ? Double.parseDouble(temperatureInfluenceElement.getAttribute("reference")) : Double.NaN;
        } else {
            this.temperatureReference = Double.NaN;
        }
        Element windSpeedInfluenceElement = (Element)xml.getElementsByTagName("windSpeed").item(0);
        this.windSpeedInfluence = Enum.valueOf(InfluenceKind.class, windSpeedInfluenceElement.getAttribute("influence"));
        if (this.windSpeedInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(windSpeedInfluenceElement.getAttribute("rangeMap"), this.windSpeedMap);
        }
        Element windDirectionInfluenceElement = (Element)xml.getElementsByTagName("windDirection").item(0);
        this.windDirectionInfluence = Enum.valueOf(InfluenceKind.class, windDirectionInfluenceElement.getAttribute("influence"));
        if (this.windDirectionInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(windDirectionInfluenceElement.getAttribute("rangeMap"), this.windDirectionMap);
        }
        Element cloudCoverInfluenceElement = (Element)xml.getElementsByTagName("cloudCover").item(0);
        this.cloudCoverInfluence = Enum.valueOf(InfluenceKind.class, cloudCoverInfluenceElement.getAttribute("influence"));
        if (this.cloudCoverInfluence != InfluenceKind.NONE) {
            ParserFunctions.parseRangeMap(cloudCoverInfluenceElement.getAttribute("percentMap"), this.cloudCoverMap);
        }
        Element priceElasticityElement = (Element)xml.getElementsByTagName("priceElasticity").item(0);
        Element benchmarkRatesElement = (Element)priceElasticityElement.getElementsByTagName("benchmarkRates").item(0);
        ParserFunctions.parseRangeMap(benchmarkRatesElement.getAttribute("rangeMap"), this.benchmarkRates);
        this.elasticityModelXml = (Element)priceElasticityElement.getElementsByTagName("elasticityModel").item(0);
        this.elasticityModelType = Enum.valueOf(ElasticityModelType.class, this.elasticityModelXml.getAttribute("type"));
        Element curtailmentElement = (Element)xml.getElementsByTagName("curtailment").item(0);
        this.curtailmentShifts = curtailmentElement != null ? ParserFunctions.parseDoubleArray(curtailmentElement.getAttribute("shifts")) : null;
    }

    public static enum ElasticityModelType {
        CONTINUOUS,
        STEPWISE;

    }

    public static enum BaseCapacityType {
        POPULATION,
        INDIVIDUAL,
        TIMESERIES;

    }

    public static enum InfluenceKind {
        DIRECT,
        DEVIATION,
        NONE;

    }
}

