/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import org.powertac.common.CustomerInfo;
import org.powertac.common.enumerations.PowerType;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CapacityStructure;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultCapacityOriginator;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ProfileOptimizerStructure;
import org.powertac.factoredcustomer.TariffSubscriberStructure;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.CapacityOriginator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Domain
class DefaultCapacityBundle
implements CapacityBundle {
    protected FactoredCustomerService service;
    private final CustomerStructure customerStructure;
    private final String name;
    private final CustomerInfo customerInfo;
    private final TariffSubscriberStructure subscriberStructure;
    private final ProfileOptimizerStructure optimizerStructure;
    protected final List<CapacityOriginator> capacityOriginators = new ArrayList<CapacityOriginator>();

    DefaultCapacityBundle(FactoredCustomerService service, CustomerStructure structure, Element xml) {
        this.service = service;
        this.customerStructure = structure;
        String bundleId = xml.getAttribute("id");
        this.name = bundleId == null || bundleId.isEmpty() ? this.customerStructure.name : this.customerStructure.name + "@" + bundleId;
        this.customerInfo = new CustomerInfo(this.name, Integer.parseInt(xml.getAttribute("population"))).withPowerType(PowerType.valueOf((String)xml.getAttribute("powerType"))).withMultiContracting(Boolean.parseBoolean(xml.getAttribute("multiContracting"))).withCanNegotiate(Boolean.parseBoolean(xml.getAttribute("canNegotiate")));
        Element tariffSubscriberElement = (Element)xml.getElementsByTagName("tariffSubscriber").item(0);
        this.subscriberStructure = new TariffSubscriberStructure(service, structure, this, tariffSubscriberElement);
        Element profileOptimizerElement = (Element)xml.getElementsByTagName("profileOptimizer").item(0);
        this.optimizerStructure = new ProfileOptimizerStructure(structure, this, profileOptimizerElement);
    }

    @Override
    public void initialize(CustomerStructure structure, Element xml) {
        NodeList capacityNodes = xml.getElementsByTagName("capacity");
        for (int i = 0; i < capacityNodes.getLength(); ++i) {
            Element capacityElement = (Element)capacityNodes.item(i);
            String name = capacityElement.getAttribute("name");
            String countString = capacityElement.getAttribute("count");
            if (countString == null || Integer.parseInt(countString) == 1) {
                CapacityStructure capacityStructure = new CapacityStructure(this.service, name, capacityElement, this);
                this.capacityOriginators.add(this.createCapacityOriginator(capacityStructure));
                continue;
            }
            if (name == null) {
                name = "";
            }
            for (int j = 1; j < 1 + Integer.parseInt(countString); ++j) {
                CapacityStructure capacityStructure = new CapacityStructure(this.service, name + j, capacityElement, this);
                this.capacityOriginators.add(this.createCapacityOriginator(capacityStructure));
            }
        }
    }

    protected CapacityOriginator createCapacityOriginator(CapacityStructure capacityStructure) {
        return new DefaultCapacityOriginator(this.service, capacityStructure, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPopulation() {
        return this.customerInfo.getPopulation();
    }

    @Override
    public PowerType getPowerType() {
        return this.customerInfo.getPowerType();
    }

    @Override
    public CustomerInfo getCustomerInfo() {
        return this.customerInfo;
    }

    @Override
    public TariffSubscriberStructure getSubscriberStructure() {
        return this.subscriberStructure;
    }

    @Override
    public ProfileOptimizerStructure getOptimizerStructure() {
        return this.optimizerStructure;
    }

    @Override
    public List<CapacityOriginator> getCapacityOriginators() {
        return this.capacityOriginators;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.customerStructure.name + ":" + this.customerInfo.getPowerType();
    }
}

