/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.powertac.common.Timeslot;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultCapacityBundle;
import org.powertac.factoredcustomer.DefaultUtilityOptimizer;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.interfaces.CapacityBundle;
import org.powertac.factoredcustomer.interfaces.FactoredCustomer;
import org.powertac.factoredcustomer.interfaces.UtilityOptimizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Domain
class DefaultFactoredCustomer
implements FactoredCustomer {
    protected Logger log = Logger.getLogger((String)DefaultFactoredCustomer.class.getName());
    protected CustomerStructure customerStructure;
    protected UtilityOptimizer utilityOptimizer;
    protected final List<CapacityBundle> capacityBundles = new ArrayList<CapacityBundle>();
    protected FactoredCustomerService service;
    private static Creator creator = new Creator();

    DefaultFactoredCustomer(CustomerStructure structure) {
        this.customerStructure = structure;
    }

    @Override
    public void initialize(FactoredCustomerService service, CustomerStructure structure) {
        this.log.info((Object)("Initializing customer " + this.customerStructure.name));
        this.service = service;
        NodeList capacityBundleNodes = this.customerStructure.getConfigXml().getElementsByTagName("capacityBundle");
        for (int i = 0; i < capacityBundleNodes.getLength(); ++i) {
            Element capacityBundleElement = (Element)capacityBundleNodes.item(i);
            CapacityBundle capacityBundle = this.createCapacityBundle(structure, capacityBundleElement);
            capacityBundle.initialize(structure, capacityBundleElement);
            this.capacityBundles.add(capacityBundle);
            this.getCustomerRepo().add(capacityBundle.getCustomerInfo());
        }
        this.utilityOptimizer = this.createUtilityOptimizer(structure, this.capacityBundles);
        this.utilityOptimizer.initialize(service);
        this.log.info((Object)("Successfully initialized customer " + this.customerStructure.name));
    }

    protected CustomerRepo getCustomerRepo() {
        return this.service.getCustomerRepo();
    }

    protected TimeslotRepo getTimeslotRepo() {
        return this.service.getTimeslotRepo();
    }

    protected CapacityBundle createCapacityBundle(CustomerStructure structure, Element capacityBundleElement) {
        return new DefaultCapacityBundle(this.service, structure, capacityBundleElement);
    }

    protected UtilityOptimizer createUtilityOptimizer(CustomerStructure structure, List<CapacityBundle> capacityBundles) {
        return new DefaultUtilityOptimizer(structure, capacityBundles);
    }

    @Override
    public void evaluateTariffs() {
        Timeslot timeslot = this.getTimeslotRepo().currentTimeslot();
        this.log.info((Object)("Customer " + this.getName() + " evaluating tariffs at timeslot " + timeslot.getSerialNumber()));
        this.utilityOptimizer.evaluateTariffs();
    }

    @Override
    public void handleNewTimeslot() {
        Timeslot timeslot = this.getTimeslotRepo().currentTimeslot();
        this.log.info((Object)("Customer " + this.getName() + " activated for timeslot " + timeslot.getSerialNumber()));
        this.utilityOptimizer.handleNewTimeslot(timeslot);
    }

    String getName() {
        return this.customerStructure.name;
    }

    CustomerStructure getCustomerStructure() {
        return this.customerStructure;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + ":" + this.getName();
    }

    public static CustomerFactory.CustomerCreator getCreator() {
        return creator;
    }

    public static class Creator
    implements CustomerFactory.CustomerCreator {
        @Override
        public String getKey() {
            return null;
        }

        @Override
        public FactoredCustomer createModel(CustomerStructure structure) {
            return new DefaultFactoredCustomer(structure);
        }
    }
}

