/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.joda.time.Instant;
import org.powertac.common.Competition;
import org.powertac.common.Tariff;
import org.powertac.common.TimeService;
import org.powertac.common.config.ConfigurableValue;
import org.powertac.common.interfaces.InitializationService;
import org.powertac.common.interfaces.NewTariffListener;
import org.powertac.common.interfaces.ServerConfiguration;
import org.powertac.common.interfaces.TariffMarket;
import org.powertac.common.interfaces.TimeslotPhaseProcessor;
import org.powertac.common.repo.CustomerRepo;
import org.powertac.common.repo.RandomSeedRepo;
import org.powertac.common.repo.TariffRepo;
import org.powertac.common.repo.TariffSubscriptionRepo;
import org.powertac.common.repo.TimeslotRepo;
import org.powertac.common.repo.WeatherForecastRepo;
import org.powertac.common.repo.WeatherReportRepo;
import org.powertac.factoredcustomer.CustomerFactory;
import org.powertac.factoredcustomer.CustomerStructure;
import org.powertac.factoredcustomer.DefaultFactoredCustomer;
import org.powertac.factoredcustomer.interfaces.FactoredCustomer;
import org.powertac.factoredcustomer.utils.SeedIdGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Service
public class FactoredCustomerService
extends TimeslotPhaseProcessor
implements InitializationService,
NewTariffListener {
    private static Logger log = Logger.getLogger((String)FactoredCustomerService.class.getName());
    @Autowired
    private TimeService timeService;
    @Autowired
    private TariffMarket tariffMarketService;
    @Autowired
    private TariffRepo tariffRepo;
    @Autowired
    private ServerConfiguration serverConfig;
    @Autowired
    private CustomerRepo customerRepo;
    @Autowired
    private TariffRepo getTariffRepo;
    @Autowired
    private TimeslotRepo timeslotRepo;
    @Autowired
    private RandomSeedRepo randomSeedRepo;
    @Autowired
    private TariffSubscriptionRepo tariffSubscriptionRepo;
    @Autowired
    private WeatherReportRepo weatherReportRepo;
    @Autowired
    private WeatherForecastRepo weatherForecastRepo;
    @ConfigurableValue(valueType="String", description="Resource name for configuration data")
    private String configResource = null;
    @ConfigurableValue(valueType="Boolean", description="Toggle logging of tariff allocation details")
    private boolean allocationDetailsLogging = true;
    @ConfigurableValue(valueType="Boolean", description="Toogle logging of capacity adjustment details")
    private boolean capacityDetailsLogging = false;
    @ConfigurableValue(valueType="Boolean", description="Toggle logging of expected usage charges")
    private boolean usageChargesLogging = true;
    private List<CustomerStructure> customerStructures = new ArrayList<CustomerStructure>();
    private List<FactoredCustomer> customers = new ArrayList<FactoredCustomer>();
    private CustomerFactory customerFactory = new CustomerFactory();

    public void setDefaults() {
    }

    public String initialize(Competition competition, List<String> completedInits) {
        if (!completedInits.contains("DefaultBroker") || !completedInits.contains("TariffMarket")) {
            log.debug((Object)"Waiting for DefaultBroker and TariffMarket to initialize");
            return null;
        }
        this.customerStructures.clear();
        this.customers.clear();
        SeedIdGenerator.reset();
        super.init();
        this.serverConfig.configureMe((Object)this);
        this.tariffMarketService.registerNewTariffListener((NewTariffListener)this);
        this.registerAvailableCustomerCreators();
        this.loadCustomerStructures(this.configResource);
        log.info((Object)"Creating factored customers from configuration structures...");
        for (CustomerStructure customerStructure : this.customerStructures) {
            FactoredCustomer customer = this.customerFactory.processStructure(customerStructure);
            if (customer != null) {
                customer.initialize(this, customerStructure);
                this.customers.add(customer);
                continue;
            }
            throw new Error("Could not create factored customer for structure: " + customerStructure.name);
        }
        log.info((Object)("Successfully initialized " + this.customers.size() + " factored customers from " + this.customerStructures.size() + " structures"));
        return "FactoredCustomer";
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    CustomerRepo getCustomerRepo() {
        return this.customerRepo;
    }

    TariffRepo getTariffRepo() {
        return this.tariffRepo;
    }

    TimeslotRepo getTimeslotRepo() {
        return this.timeslotRepo;
    }

    RandomSeedRepo getRandomSeedRepo() {
        return this.randomSeedRepo;
    }

    TariffSubscriptionRepo getTariffSubscriptionRepo() {
        return this.tariffSubscriptionRepo;
    }

    TariffMarket getTariffMarket() {
        return this.tariffMarketService;
    }

    WeatherReportRepo getWeatherReportRepo() {
        return this.weatherReportRepo;
    }

    WeatherForecastRepo getWeatherForecastRepo() {
        return this.weatherForecastRepo;
    }

    private void registerAvailableCustomerCreators() {
        this.customerFactory.registerDefaultCreator(DefaultFactoredCustomer.getCreator());
        log.info((Object)"Registered default factored customer creator");
        ArrayList<String> creatorNames = new ArrayList<String>();
        creatorNames.add("org.powertac.factoredcustomer.LearningCustomerCreator");
        for (String name : creatorNames) {
            try {
                CustomerFactory.CustomerCreator creator = (CustomerFactory.CustomerCreator)Class.forName(name).newInstance();
                this.customerFactory.registerCreator(creator);
                log.info((Object)("Registered creator: " + name));
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                throw new Error("Could not register creator for name: " + name + "; caught exception: " + e);
            }
        }
    }

    protected void loadCustomerStructures(String configResource) {
        log.info((Object)("Attempting to load factored customer structures from config resource: " + configResource));
        try {
            InputStream configStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(configResource);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(configStream);
            NodeList customerNodes = doc.getElementsByTagName("customer");
            int numStructures = customerNodes.getLength();
            log.info((Object)("Loading " + numStructures + " factored customer structures"));
            for (int i = 0; i < numStructures; ++i) {
                Element customerElement = (Element)customerNodes.item(i);
                String name = customerElement.getAttribute("name");
                String countString = customerElement.getAttribute("count");
                int count = countString == null || countString.trim().isEmpty() ? 1 : Integer.parseInt(countString);
                if (count == 0) continue;
                if (count == 1) {
                    CustomerStructure structure = new CustomerStructure(name, customerElement);
                    this.customerStructures.add(structure);
                    continue;
                }
                for (int j = 1; j <= count; ++j) {
                    CustomerStructure structure = new CustomerStructure(name + j, customerElement);
                    this.customerStructures.add(structure);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading factored customer structures from config resourcee: " + configResource + "; exception = " + e.toString()));
            throw new Error(e);
        }
        log.info((Object)"Successfully loaded factored customer structures");
    }

    public void publishNewTariffs(List<Tariff> tariffs) {
        for (FactoredCustomer customer : this.customers) {
            customer.evaluateTariffs();
        }
    }

    public void activate(Instant now, int phase) {
        for (FactoredCustomer customer : this.customers) {
            customer.handleNewTimeslot();
        }
    }

    String getConfigResource() {
        return this.configResource;
    }

    void setConfigResource(String resource) {
        this.configResource = resource;
    }

    boolean getAllocationDetailsLogging() {
        return this.allocationDetailsLogging;
    }

    void setAllocationDetailsLogging(boolean value) {
        this.allocationDetailsLogging = value;
    }

    boolean getCapacityDetailsLogging() {
        return this.capacityDetailsLogging;
    }

    void setCapacityDetailsLogging(boolean value) {
        this.capacityDetailsLogging = value;
    }

    boolean getUsageChargesLogging() {
        return this.usageChargesLogging;
    }

    void setUsageChargesLogging(boolean value) {
        this.usageChargesLogging = value;
    }

    List<FactoredCustomer> getCustomers() {
        return this.customers;
    }
}

