/*
 * Decompiled with CFR 0.152.
 */
package org.powertac.factoredcustomer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.powertac.common.Tariff;
import org.powertac.common.TariffSubscription;
import org.powertac.common.Timeslot;
import org.powertac.common.state.Domain;
import org.powertac.factoredcustomer.CapacityProfile;
import org.powertac.factoredcustomer.CapacityStructure;
import org.powertac.factoredcustomer.DefaultCapacityBundle;
import org.powertac.factoredcustomer.DefaultCapacityOriginator;
import org.powertac.factoredcustomer.FactoredCustomerService;
import org.powertac.factoredcustomer.ProfileOptimizerStructure;
import org.powertac.factoredcustomer.ProfileRecommendation;
import org.powertac.factoredcustomer.utils.SeedIdGenerator;

@Domain
final class AdaptiveCapacityOriginator
extends DefaultCapacityOriginator
implements ProfileRecommendation.Listener {
    private final ProfileOptimizerStructure optimizerStructure;
    private final Random recommendationHandler;
    private Map<TariffSubscription, Map<Integer, Double>> forecastCapacitiesPerSub;
    private Map<Tariff, Double> tariff2inconv;

    AdaptiveCapacityOriginator(FactoredCustomerService service, CapacityStructure capacityStructure, DefaultCapacityBundle bundle) {
        super(service, capacityStructure, bundle);
        this.log = Logger.getLogger((String)AdaptiveCapacityOriginator.class.getName());
        this.optimizerStructure = this.getParentBundle().getOptimizerStructure();
        this.recommendationHandler = new Random(service.getRandomSeedRepo().getRandomSeed("factoredcustomer.AdaptiveCapacityOriginator", (long)SeedIdGenerator.getId(), "RecommendationHandler").getValue());
        this.forecastCapacitiesPerSub = new HashMap<TariffSubscription, Map<Integer, Double>>();
        this.tariff2inconv = new HashMap<Tariff, Double>();
    }

    @Override
    public void handleProfileRecommendation(ProfileRecommendation globalRec) {
        ProfileRecommendation localRec;
        double draw1 = this.recommendationHandler.nextFloat();
        if (draw1 > this.optimizerStructure.reactivityFactor) {
            this.log.info((Object)(this.logIdentifier + ": Ignoring received profile recommendation"));
            return;
        }
        double draw2 = this.recommendationHandler.nextFloat();
        if (draw2 < this.optimizerStructure.receptivityFactor) {
            this.log.info((Object)(this.logIdentifier + ": Adopting profile recommendation as received"));
            localRec = globalRec;
        } else {
            localRec = new ProfileRecommendation(globalRec.getOpinions());
            HashMap<ProfileRecommendation.ScoringFactor, Double> weights = new HashMap<ProfileRecommendation.ScoringFactor, Double>();
            weights.put(ProfileRecommendation.ScoringFactor.PROFILE_CHANGE, this.optimizerStructure.profileChangeWeight);
            weights.put(ProfileRecommendation.ScoringFactor.BUNDLE_VALUE, this.optimizerStructure.bundleValueWeight);
            localRec.computeScores(weights);
            localRec.computeUtilities();
            localRec.computeProbabilities(this.optimizerStructure.rationalityFactor);
        }
        CapacityProfile chosenProfile = this.optimizerStructure.profileSelectionMethod == ProfileOptimizerStructure.ProfileSelectionMethod.BEST_UTILITY ? this.selectBestProfileInRecommendation(localRec) : this.drawProfileFromRecommendation(localRec);
        this.overwriteForecastCapacities(this.service.getTimeslotRepo().currentTimeslot(), chosenProfile);
    }

    @Override
    public void handleProfileRecommendationPerSub(ProfileRecommendation globalRec, TariffSubscription sub, CapacityProfile capacityProfile) {
        ProfileRecommendation localRec;
        double draw1 = this.recommendationHandler.nextFloat();
        if (draw1 > this.optimizerStructure.reactivityFactor) {
            this.log.info((Object)(this.logIdentifier + ": Ignoring received profile recommendation"));
            return;
        }
        double draw2 = this.recommendationHandler.nextFloat();
        if (draw2 < this.optimizerStructure.receptivityFactor) {
            this.log.info((Object)(this.logIdentifier + ": Adopting profile recommendation as received"));
            localRec = globalRec;
        } else {
            localRec = new ProfileRecommendation(globalRec.getOpinions());
            HashMap<ProfileRecommendation.ScoringFactor, Double> weights = new HashMap<ProfileRecommendation.ScoringFactor, Double>();
            weights.put(ProfileRecommendation.ScoringFactor.PROFILE_CHANGE, this.optimizerStructure.profileChangeWeight);
            weights.put(ProfileRecommendation.ScoringFactor.BUNDLE_VALUE, this.optimizerStructure.bundleValueWeight);
            localRec.computeScores(weights);
            localRec.computeUtilities();
            localRec.computeProbabilities(this.optimizerStructure.rationalityFactor);
        }
        CapacityProfile chosenProfile = this.optimizerStructure.profileSelectionMethod == ProfileOptimizerStructure.ProfileSelectionMethod.BEST_UTILITY ? this.selectBestProfileInRecommendation(localRec) : this.drawProfileFromRecommendation(localRec);
        if (!chosenProfile.toString().equals(capacityProfile.toString())) {
            // empty if block
        }
        this.overwriteForecastCapacitiesPerSub(this.service.getTimeslotRepo().currentTimeslot(), chosenProfile, sub);
        ProfileRecommendation.Opinion opinionOnChosenProfile = localRec.getOpinions().get(chosenProfile);
        double originalScore = localRec.getNonScaledScore(chosenProfile);
        double costNormalizationConst = opinionOnChosenProfile.normUsageCharge != 0.0 ? opinionOnChosenProfile.usageCharge / opinionOnChosenProfile.normUsageCharge : 0.0;
        double inconvenienceFactor = Math.abs(costNormalizationConst) * originalScore - opinionOnChosenProfile.usageCharge;
        this.tariff2inconv.put(sub.getTariff(), inconvenienceFactor);
    }

    private CapacityProfile selectBestProfileInRecommendation(ProfileRecommendation rec) {
        double bestUtility = Double.MIN_VALUE;
        CapacityProfile bestProfile = null;
        for (Map.Entry<CapacityProfile, Double> entry : rec.getUtilities().entrySet()) {
            if (!(entry.getValue() > bestUtility)) continue;
            bestUtility = entry.getValue();
            bestProfile = entry.getKey();
        }
        if (bestProfile == null) {
            throw new Error("Best profile in recommendation is null!");
        }
        return bestProfile;
    }

    private CapacityProfile drawProfileFromRecommendation(ProfileRecommendation rec) {
        double draw = this.recommendationHandler.nextFloat();
        ArrayList<Map.Entry<CapacityProfile, Double>> l = new ArrayList<Map.Entry<CapacityProfile, Double>>(rec.getProbabilities().entrySet());
        Collections.sort(l, new Comparator<Map.Entry<CapacityProfile, Double>>(){

            @Override
            public int compare(Map.Entry<CapacityProfile, Double> o1, Map.Entry<CapacityProfile, Double> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        double sumProb = 0.0;
        for (Map.Entry<CapacityProfile, Double> entry : l) {
            if (!(draw < (sumProb += entry.getValue().doubleValue()))) continue;
            return entry.getKey();
        }
        throw new Error("Drawing from recommendation resulted in a null profile!");
    }

    private void overwriteForecastCapacities(Timeslot timeslot, CapacityProfile profile) {
        Timeslot slider = timeslot;
        for (int i = 0; i < 24; ++i) {
            this.forecastCapacities.put(slider.getSerialNumber(), profile.getCapacity(i));
            slider = this.service.getTimeslotRepo().getNext(slider);
        }
    }

    private void overwriteForecastCapacitiesPerSub(Timeslot timeslot, CapacityProfile profile, TariffSubscription sub) {
        Timeslot slider = timeslot;
        for (int i = 0; i < 24; ++i) {
            int futureTimeslot = slider.getSerialNumber();
            double futureCapacity = profile.getCapacity(i);
            this.insertIntoForecastCapacitiesPerSub(sub, futureTimeslot, futureCapacity);
            slider = this.service.getTimeslotRepo().getNext(slider);
        }
    }

    private void insertIntoForecastCapacitiesPerSub(TariffSubscription sub, int futureTimeslot, double futureCapacity) {
        Map<Integer, Double> ts2capacity = this.forecastCapacitiesPerSub.get(sub);
        if (null == ts2capacity) {
            ts2capacity = new HashMap<Integer, Double>();
            this.forecastCapacitiesPerSub.put(sub, ts2capacity);
        }
        ts2capacity.put(futureTimeslot, futureCapacity);
    }

    @Override
    public double getShiftingInconvenienceFactor(Tariff tariff) {
        Double inconv = this.tariff2inconv.get(tariff);
        if (inconv != null) {
            return inconv;
        }
        this.log.error((Object)"How come inconvenience is null?");
        return 0.0;
    }

    @Override
    public double useCapacity(TariffSubscription subscription) {
        double forecastCapacity;
        int timeslot = this.service.getTimeslotRepo().currentSerialNumber();
        double adjustedCapacity = forecastCapacity = this.getForecastCapacityPerSub(timeslot, subscription).doubleValue();
        if (Double.isNaN(adjustedCapacity = this.adjustCapacityForSubscription(timeslot, adjustedCapacity, subscription))) {
            throw new Error("Adjusted capacity is NaN for forecast capacity = " + forecastCapacity);
        }
        adjustedCapacity = this.truncateTo2Decimals(adjustedCapacity);
        this.actualCapacities.put(timeslot, adjustedCapacity);
        this.log.info((Object)(this.logIdentifier + ": Adjusted capacity for tariff " + subscription.getTariff().getId() + " = " + adjustedCapacity));
        return adjustedCapacity;
    }

    @Override
    public CapacityProfile getCurrentForecastPerSub(TariffSubscription sub) {
        int timeslot = this.service.getTimeslotRepo().currentSerialNumber();
        return this.getForecastPerSubStartingAt(timeslot, sub);
    }

    @Override
    public CapacityProfile getForecastPerSubStartingAt(int startingTimeslot, TariffSubscription subscription) {
        int timeslot = startingTimeslot;
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < 24; ++i) {
            values.add(this.getForecastCapacityPerSub(timeslot, subscription));
            ++timeslot;
        }
        return new CapacityProfile(values);
    }

    private Double getForecastCapacityPerSub(int timeslot, TariffSubscription subscription) {
        Map<Integer, Double> ts2capacity = this.forecastCapacitiesPerSub.get(subscription);
        if (null == ts2capacity || null == ts2capacity.get(timeslot)) {
            return this.getForecastCapacity(timeslot);
        }
        double perAllCapacity = this.getForecastCapacity(timeslot);
        double perSubCapacity = ts2capacity.get(timeslot);
        return perSubCapacity;
    }
}

